package cz.cuni.amis.pogamut.base.agent.navigation;

/**
 * Stuck detector provides a functionality to detect the situation in which the bot is unable
 * to reach its destination. Stuck detector does that (usually) based on some heuristics. 
 * 
 * @author Jimmy
 */
public interface IStuckDetector {

	/**
	 * Tells the stuck detector, that the bot is waiting for something, thus the detector should not detect stuck!
	 * @param state
	 */
	public void setBotWaiting(boolean state);
	
	/**
	 * Tells whether the detector has detected a stuck.
	 * @return
	 */
	public boolean isStuck();
	
	/**
	 * Restarts the detector - this method is called just before the executor
	 * starts to follow the path.
	 * <p><p>
	 * If {@link IStuckDetector#isStuck()} was reporting true, it should report 'false' after 
	 * the reset (until next stuck is detected).
	 */
	public void reset();
	
}
