/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.communication.worldview.property;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.utils.HashCode;
import cz.cuni.amis.utils.maps.HashMapMap;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.Serializable;

public class PropertyId
implements Serializable {
    private static final long serialVersionUID = 7196633078273572529L;
    private Token token;
    private WorldObjectId objectId;
    private int hashCode;
    private static HashMapMap<WorldObjectId, String, PropertyId> stringMap = new HashMapMap();
    private static HashMapMap<WorldObjectId, Long, PropertyId> longMap = new HashMapMap();

    private PropertyId(WorldObjectId objectId, Token token) {
        this.objectId = objectId;
        this.token = token;
        this.hashCode = new HashCode().add((Object)objectId).add((Object)token).getHash();
    }

    private PropertyId(WorldObjectId objectId, String name) {
        this.objectId = objectId;
        this.token = Tokens.get((String)name);
        this.hashCode = new HashCode().add((Object)objectId).add((Object)this.token).getHash();
    }

    private PropertyId(WorldObjectId objectId, long id) {
        this.objectId = objectId;
        this.token = Tokens.get((long)id);
        this.hashCode = new HashCode().add((Object)objectId).add((Object)this.token).getHash();
    }

    public WorldObjectId getWorldObjectId() {
        return this.objectId;
    }

    public Token getPropertyToken() {
        return this.token;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof PropertyId)) {
            return false;
        }
        return this.token.equals((Object)((PropertyId)other).token) && this.objectId.equals(((PropertyId)other).objectId);
    }

    public String getStringId() {
        return this.objectId.getStringId() + "-" + this.token.getToken();
    }

    public String toString() {
        return "PropertyId[" + this.objectId.toString() + "," + this.getStringId() + "]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static PropertyId get(WorldObjectId objectId, String name) {
        PropertyId value = (PropertyId)stringMap.get((Object)objectId, (Object)name);
        if (value != null) {
            return value;
        }
        value = new PropertyId(objectId, name);
        stringMap.put((Object)objectId, (Object)name, (Object)value);
        return value;
    }

    public static PropertyId get(WorldObjectId objectId, long id) {
        PropertyId value = (PropertyId)longMap.get((Object)objectId, (Object)id);
        if (value != null) {
            return value;
        }
        value = new PropertyId(objectId, id);
        longMap.put((Object)objectId, (Object)id, (Object)value);
        return value;
    }
}

