package cz.cuni.amis.pogamut.base.utils.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

import cz.cuni.amis.pogamut.base.agent.IAgentId;

/**
 * Pogamut custom formatter used as default formatter for {@link LogPublisher}.
 *
 * @author Jimmy
 */
public class LogFormatter extends Formatter {
	
	private static SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
	
	private static String longestAgentName = "";
	
	private static String longestComponentName = "";
	
	private StringBuffer buffer = new StringBuffer(512);

	/**
	 * Whether to append "newline" after the log message.
	 */
	private boolean lineEnds;

	private IAgentId name = null;

	public static final String[] whitespaces = new String[] {
		"        ",
		"       ",
		"      ",
		"     ",
		"    ",
		"   ",
		"  ",
		" ",
		""
	};
	
	

	public LogFormatter() {
		this(null, false);
	}

	public LogFormatter(boolean lineEnds) {
		this(null, lineEnds);
	}

	public LogFormatter(IAgentId agentId) {
		this(agentId, false);
	}
	
	public LogFormatter(IAgentId agentId, boolean lineEnds) {
		this.name = agentId;
		this.lineEnds = lineEnds;
	}

	@Override
	public synchronized String format(LogRecord record) {
		buffer.delete(0, buffer.length());

		if (name != null) {
			String n = name.getName().getFlag();
			if (n == null) n = "null";
			if (n.length() > longestAgentName.length()) {
				StringBuffer longest = new StringBuffer();
				for (int i = 0; i < n.length(); ++i) {
					longest.append(" ");
				}
				longestAgentName = longest.toString();
			}
			buffer.append("(");
			buffer.append(n);
			buffer.append(") ");
			int count = longestAgentName.length() - n.length();
			for (int i = 0; i < count; ++i) {
				buffer.append(" ");
			}
		} else {
			if (longestAgentName.length() > 0) {
				buffer.append("()");
				buffer.append(longestAgentName);
			} else {
				buffer.append("() ");
			}
		}
		
		buffer.append("[");
		buffer.append(record.getLevel().toString());
		buffer.append("]");
		buffer.append(whitespaces[record.getLevel().toString().length()]);

		synchronized(dateFormat) {
			buffer.append(dateFormat.format(new Date(record.getMillis())));
		}
		
		buffer.append(" ");
		
		String n = record.getLoggerName();
		if (n == null) n = "null";
		if (n.length() > longestComponentName.length()) {
			StringBuffer longest = new StringBuffer();
			for (int i = 0; i < n.length(); ++i) {
				longest.append(" ");
			}
			longestComponentName = longest.toString();
		}
		buffer.append("<");
		buffer.append(n);
		buffer.append("> ");
		int count = longestComponentName.length() - n.length();
		for (int i = 0; i < count; ++i) {
			buffer.append(" ");
		}
		
		buffer.append(record.getMessage());
		
		if (lineEnds) {
			buffer.append("\r\n");
		}
		
		return buffer.toString();
	}

}
