/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.episodic.launcher;

import cz.cuni.amis.pogamut.episodic.decisions.Node;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.memory.Parameters;
import cz.cuni.amis.pogamut.episodic.query.ComboTexts.ComboType;
import cz.cuni.amis.pogamut.episodic.query.QueryExecutor;
import decisionMakingSystem.GMTTime;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.Assert;
import pogamutEndEvent.PogamutEndAffordanceUsed;
import pogamutEndEvent.PogamutEndEvent;
import utils.TimeUtils;

/**
 *
 * @author Miso
 */
//public class LauncherTest extends TestCase {
public class LauncherTest {

    public LauncherTest() {
    }

 //   @Ignore
    @Test
    public void testEventData() {
        //THIS IS THE BEST OVERALL TEST (BLACKBOX TEST)
        //IT TAKES EVENTS FOR 7+ DAYS AND PROCESSES THEM BY MEMORY MODULE
        AgentMemory.visualize = false;
        int maxTime = 7*24*60;
        AgentMemory mem = new AgentMemory();
        PogamutEndEventListener listener = new PogamutEndEventListener(mem);

        try {
            FileInputStream evtLog = new FileInputStream("inputEvents");
            ObjectInputStream evtStream = new ObjectInputStream(evtLog);

            PogamutEndEvent evt = null;
            while (true) {
                    evt = (PogamutEndEvent) evtStream.readObject();
                    listener.handlePogamutEndEvent(evt);
                    if (evt.time > maxTime) break;
            }
        } catch (FileNotFoundException e) {
            System.err.println(e);
            System.out.println("Test testEventData skipped!");
            Assert.fail("cannot find the input file");
        } catch (IOException e) {
            System.err.println(e);
            System.out.println("Test testEventData skipped!");
            Assert.fail("IO exception");
        } catch (ClassNotFoundException e) {
            System.err.println(e);
            System.out.println("Test testEventData skipped!");
            Assert.fail("class not found exception");
   /*     } catch (Exception e) {
            System.err.println(e);
            Assert.fail("processing events failed");*/
        }
    }

    @Ignore
    @Test
    public void testExperimentFalseMemories() {
/*
 * Experiment will try to achieve ratio of correctly/falsely rememebered events
 * sa as in Loftus: Eyewittness testimony p.70 table 4.1.
 * Data go as following:
 *   - recalled items in less than 8 days: 45
 *   - number of false importations in less than 8 days: 3
 *   - recalled items in less 21-28 days: 24
 *   - number of false importations in 21-28 days: 4
 */
        AgentMemory mem = new AgentMemory();
        System.out.println("Starting false memory experiment");
        performExperimentFalseMemories(mem, "inputEvents", 2*24*60 + 0*60 + 10);
    }

    @Ignore
    @Test
    public void testExperimentRoomSchema() {
        AgentMemory mem = new AgentMemory();
        Parameters.REMEMBER_SEEN_ITEMS = true;
        // 50/30/10 nothing is forgotten
        // 42/22/2 all regular are forgotten
        //         - with 0.6 there are both forgotten and added
        // 40/20/0 everything is forgotten
        // 45/25/5 something is forgotten - 0.6 false objects are added
        //                                - 0.7 correct objects are added
        //                                - 0.8 few objects are added
        Parameters.MAX_OBJECT_SCORE = 42;
        Parameters.DEFAULT_OBJECT_SCORE = 22;
        Parameters.MIN_OBJECT_SCORE = 2;
        Parameters.PERCENTAGE_TO_DERIVE_OBJECT = 0.6;
        System.out.println("Starting room schema experiment (expected run time ~40s)");
        performExperimentRoomSchema(mem, "observeEvents", 22*24*60 + 10*60 + 10);
    }
    
    @Ignore
    @Test
    public void testExperimentForgettingCurve() {
        AgentMemory mem = new AgentMemory();
        System.out.println("Starting forgetting curve experiment (expected run time ~?s)");
        performExperimentForgettingCurve(mem, "inputEvents", 20*24*60 + 10*60 + 10);
    }

    @Ignore
    @Test
    public void Ignore_testExperiment7Days() {
        AgentMemory mem = new AgentMemory();
        Parameters.MAX_CHRONOBAG_LEVELS = 3;
        Parameters.CHRONOBAG_INTERVAL_LENGHTS[0] = 1;
        Parameters.CHRONOBAG_INTERVAL_LENGHTS[1] = 10;
        Parameters.CHRONOBAG_INTERVAL_LENGHTS[2] = 20;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = 3;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = 7;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = 11;
        Parameters.MAX_OBJECT_SCORE = 80;
      //  performExperiment7Days(mem, "inputEvents", 2*24*60 + 10*60 + 10);
        System.out.print("Starting 7 days experiment (expected run time ~40s)");
        performExperiment7Days(mem, "inputEvents", 100*24*60 + 10*60 + 10);

    }

    public void performExperimentFalseMemories(AgentMemory mem, String filename, int maxTime) {
        AgentMemory.visualize = false;
        PogamutEndEventListener listener = new PogamutEndEventListener(mem);
        QueryExecutor query = new QueryExecutor(mem);

        ObjectInputStream evtStream = null;
        ObjectInputStream evtStreamFull = null;

        try {
            FileInputStream evtLog = new FileInputStream(filename);
            evtStream = new ObjectInputStream(evtLog);
            FileInputStream evtLogFull = new FileInputStream(filename);
            evtStreamFull = new ObjectInputStream(evtLogFull);
        } catch (Exception e) {
            System.err.println(e);
            System.out.println("ExperimentFalseMemories skipped!");
            Assert.fail();
        }

        Map<Integer, Integer> processed2full = new HashMap<Integer, Integer>();
        Map<Integer, Integer> full2processed = new HashMap<Integer, Integer>();
        
        AgentMemory memFull = new AgentMemory();
        PogamutEndEventListener listenerFull = new PogamutEndEventListener(memFull);
        QueryExecutor queryFull = new QueryExecutor(memFull);
        try {
            PogamutEndEvent evt = null;
            PogamutEndEvent evtFull = null;
            int maxDay = 0;
            while (true) {
                    evt = (PogamutEndEvent) evtStream.readObject();
                    evtFull = (PogamutEndEvent) evtStreamFull.readObject();

                    Parameters.NO_FORGETTING = false;
                  //  Parameters.NO_ABSTRACT_CHRONOBAGS = true; //TODO: temporary
                    Parameters.NO_ABSTRACT_CHRONOBAGS = false;
                    Parameters.NO_EPISODE_MERGING = false;
                    listener.handlePogamutEndEvent(evt);
                    
                    Parameters.NO_FORGETTING = true;
                    Parameters.NO_ABSTRACT_CHRONOBAGS = true;
                    Parameters.NO_EPISODE_MERGING = true;
                    listenerFull.handlePogamutEndEvent(evtFull);

                    Integer id1 = mem.getLastEpisodeId();
                    Integer id2 = memFull.getLastEpisodeId();
                    if (id1 != null && id2 != null) {
                        processed2full.put(id1, id2);
                        full2processed.put(id2, id1);
                    }

              /*      if (evt.time > maxDay) {
                        System.out.println(evt.time);
                        maxDay = evt.time + 2*60;
                    }*/
                    if (evt.time > maxTime) {
                        System.out.println("Max time reached.");
                        break;
                    }
            }
        } catch (IOException e) {
            System.out.println("End of input.");
        } catch (NullPointerException e) {
            System.err.println(e);
            //Assert.fail();
        } catch (Exception e) {
            System.err.println(e);
            Assert.fail();
        }

        int forgottenNodes = 0;
        int importedNodes = 0;
        int totalNodes = 0;

        for (Map.Entry<Integer, Integer> entry : processed2full.entrySet()) {
            forgottenNodes += query.getNumberOfForgottenNodes(entry.getKey(), memFull, entry.getValue(), true, false);
        }
        for (Map.Entry<Integer, Integer> entry : full2processed.entrySet()) {
            importedNodes += queryFull.getNumberOfForgottenNodes(entry.getKey(), mem, entry.getValue(), false, true);
        }
        for (Map.Entry<Integer, Integer> entry : processed2full.entrySet()) {
            totalNodes += query.getNumberOfForgottenNodes(0, memFull, entry.getValue(), false, false);
        }

        System.out.println("Forgotten: " + forgottenNodes);
        System.out.println("Imported: " + importedNodes);
        System.out.println("Total: " + totalNodes);
    }

    public void performExperimentForgettingCurve(AgentMemory mem, String filename, int maxTime) {
        AgentMemory.visualize = false;
        PogamutEndEventListener listener = new PogamutEndEventListener(mem);
        QueryExecutor query = new QueryExecutor(mem);

        ObjectInputStream evtStream = null;

        try {
            FileInputStream evtLog = new FileInputStream(filename);
            evtStream = new ObjectInputStream(evtLog);
        } catch (Exception e) {
            System.err.println(e);
            System.out.println("ExperimentForgettingCurve skipped!");
            Assert.fail();
        }

        //will continuosly keep list of episode IDs and their day of execution
        //than will ask for number of nodes in each episode and create the table
        //to show number of nodes remembered from each day
        HashMap<Integer, Integer> episodeAges = new HashMap<Integer, Integer>();

        try {
            PogamutEndEvent evt = null;
            while (true) {
                    evt = (PogamutEndEvent) evtStream.readObject();
                    Chronobag last = mem.getPresentChronobag();
                    Collection<Episode> episodes = mem.getPresentChronobag().getEpisodes();
                    listener.handlePogamutEndEvent(evt);
                    if (mem.getPresentChronobag() != last) {
                        for (Map.Entry<Integer, Integer> e : episodeAges.entrySet()) {
                            e.setValue(e.getValue() + 1);
                        }
                        for (Episode e : episodes) {
                            episodeAges.put(e.getIdEpisode(), 1);
                        }
                    }
                    if (evt.time > maxTime) {
                        System.out.println("Max time reached.");
                        break;
                    }
            }
        } catch (IOException e) {
            System.out.println("End of input.");
        } catch (Exception e) {
            System.err.println(e);
            Assert.fail();
        }
        Collection<Episode> episodes = mem.getPresentChronobag().getEpisodes();
        for (Episode e : episodes) {
            episodeAges.put(e.getIdEpisode(), 0);
        }

        //System.out.println("Ages of episodes: " + episodeAges.values());
        
        Map<Integer, Integer> result = query.executeForgettingCurveQuery(episodeAges.keySet());

        Map<Integer, Integer> totalRemembered = new HashMap<Integer, Integer>();
        for (Integer i : episodeAges.keySet()) {
            if (!totalRemembered.containsKey(episodeAges.get(i))) {
                totalRemembered.put(episodeAges.get(i), result.get(i));
            } else {
                totalRemembered.put(episodeAges.get(i), totalRemembered.get(episodeAges.get(i))+result.get(i));
            }
        }
        System.out.println("Number of nodes remembered by memory age (age = total):");
        System.out.println(totalRemembered);
    }

    public void performExperimentRoomSchema(AgentMemory mem, String filename, int maxTime) {
        AgentMemory.visualize = false;
        PogamutEndEventListener listener = new PogamutEndEventListener(mem);
        QueryExecutor query = new QueryExecutor(mem);

        ObjectInputStream evtStream = null;

        try {
            FileInputStream evtLog = new FileInputStream(filename);
            evtStream = new ObjectInputStream(evtLog);
        } catch (Exception e) {
            System.err.println(e);
            System.out.println("ExperimentRoomSchema skipped!");
            Assert.fail();
        }

        ArrayList<String> lastPerceived = new ArrayList<String>();

        try {
            PogamutEndEvent evt = null;
            while (true) {
                    evt = (PogamutEndEvent) evtStream.readObject();
                    listener.handlePogamutEndEvent(evt);
                    if (evt.atomic != null && evt.atomic.equals("OBSERVE")) {
                        lastPerceived.clear();
                        for (PogamutEndAffordanceUsed aff: evt.affordances) {
                            if (aff.usedOn.equals("AObserve")) {
                                lastPerceived.add(aff.item);
                            }
                        }
                    }
                    if (evt.time > maxTime) {
                        System.out.println("Max time reached.");
                        break;
                    }
            }
        } catch (IOException e) {
            System.out.println("End of input.");
        } catch (Exception e) {
            System.err.println(e);
            Assert.fail();
        }

        System.out.println("seen: " + lastPerceived);

        ArrayList<String> remembered = query.executeRoomSchemaQuery();
        System.out.println("remembered: " + remembered);
        System.out.print("forgotten: ");
        for (String str : lastPerceived) {
            if (!remembered.contains(str)) {
                System.out.print(str + ";");
            }
        }
        System.out.println();
        System.out.print("added: ");
        for (String str : remembered) {
            if (!lastPerceived.contains(str)) {
                System.out.print(str + ";");
            }
        }
        System.out.println();
    }

    public Map<Integer, Double> performExperiment7Days(AgentMemory mem, String filename, int maxTime) {
        AgentMemory.visualize = false;
        PogamutEndEventListener listener = new PogamutEndEventListener(mem);
        QueryExecutor query = new QueryExecutor(mem);

        ObjectInputStream evtStream = null;
        
        try {
            FileInputStream evtLog = new FileInputStream(filename);
            evtStream = new ObjectInputStream(evtLog);
        } catch (Exception e) {
            System.err.println(e);
            System.out.println("Experiment7Days skipped!");
            Assert.fail();
        }

        Integer currentDayI = 0;
        String currentDayS = "";
        String currentTime = "";

        HashMap<String, Integer> lastExecutionsI = new HashMap<String, Integer>();
        HashMap<String, String> lastExecutionsS = new HashMap<String, String>();

        try {
            PogamutEndEvent evt = null;
            while (true) {
                    evt = (PogamutEndEvent) evtStream.readObject();
                    listener.handlePogamutEndEvent(evt);
                    if (evt.type == pogamutEndEvent.PogamutEndEventType.ATOMIC_ACTION_EXECUTED && evt.time > 0) {
                        //format of time is: "Fr, 03:44, day 12."
                        currentTime = TimeUtils.counterToDate(GMTTime.getRealTimeInTicks(evt.time));
                        currentDayI = Integer.parseInt(currentTime.substring(15, currentTime.length() - 1));
                        currentDayS = currentTime.substring(0, 2);

                        lastExecutionsI.put(evt.trace.get(evt.trace.size() - 1), currentDayI);
                        lastExecutionsS.put(evt.trace.get(evt.trace.size() - 1), currentDayS);
                    }
                    if (evt.time > maxTime) break;
            }
        } catch (IOException e) {
            System.out.println("End of input.");
        } catch (ClassNotFoundException e) {
            System.err.println(e);
            Assert.fail();
        }

        System.out.println("Current day: " + currentDayI);
        String output = "";
        String retrieved;

        Integer minDay;
        Integer maxDay;
        ArrayList<String> days = new ArrayList<String>();
        ArrayList<String> daysOfWeek = new ArrayList<String>();
        daysOfWeek.add("Mo"); daysOfWeek.add("Tu"); daysOfWeek.add("We"); daysOfWeek.add("Th");
        daysOfWeek.add("Fr"); daysOfWeek.add("Sa"); daysOfWeek.add("Su");
        int currentDOW = -1;
        for (int i = 0; i < 7; i++) {
            if (currentDayS.equals(daysOfWeek.get(i))) currentDOW = i;
        }
        if (currentDOW == -1) Assert.fail();

        HashMap<Integer, Double> errors = new HashMap<Integer, Double>();
        HashMap<Integer, Double> errorTotals = new HashMap<Integer, Double>();

        for (Node n : mem.getDecisionTree().topLevelGoals.values()) {
            output = "Goal: ";
            output += n.getName();
            output += ". Last executed: ";
            if (lastExecutionsI.containsKey(n.getName())) {
                output += lastExecutionsS.get(n.getName());
                output += ", " + (currentDayI - lastExecutionsI.get(n.getName())) + " day(s) ago.";
            } else {
                output += "never.";
            }
            output += "\n";

            output += "Retrieved memory: ";
            retrieved = query.executeQuery(ComboType.COMBO_ACTIVITY, false, n.getName());
            //format of retrieved is : "X - Y day(s) ago. Possible days: [Mo]
            output += retrieved;
            output += "\n";
            System.out.println(output);

            if (retrieved.equals("Don't remember.")) continue;

            minDay = Integer.parseInt(retrieved.substring(0, retrieved.indexOf("-") - 1));
            maxDay = Integer.parseInt(retrieved.substring(retrieved.indexOf("-") + 2, retrieved.indexOf("d") - 1));

            retrieved = retrieved.substring(retrieved.indexOf("[")+1, retrieved.indexOf("]"));

            int deviation = 0;
            int dow;
            errors.clear();
            for (int i = minDay; i <= maxDay; i++) {
                dow = i;
                while (currentDOW - dow < 0) {
                    dow -= 7;
                }
                if (retrieved.contains(daysOfWeek.get((currentDOW - dow) % 7)) || retrieved.equals("")) {
                    deviation = Math.abs(i - (currentDayI - lastExecutionsI.get(n.getName())));
                    if (errors.get(deviation) == null) { 
                        errors.put(deviation, 0.0);
                    }
                    errors.put(deviation, errors.get(deviation) + 1);
                }
            }
            Double sum = 0.0;
            for (Double d : errors.values()) {
                sum += d;
            }
            for (Integer key : errors.keySet()) {
                errors.put(key, errors.get(key) / sum);
                if (!errorTotals.containsKey(key)) errorTotals.put(key, 0.0);
                errorTotals.put(key, errorTotals.get(key) + errors.get(key));
            }
        }

        System.out.println ("Frequency of errors in dating events: (n days = x times, ...) ");
        System.out.println (errorTotals);
        return errorTotals;
    }

}