/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d.plane;

import com.google.common.collect.Lists;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import math.geom2d.line.LineSegment2D;
import math.geom2d.polygon.SimplePolygon2D;
import math.geom3d.Point3D;
import math.geom3d.Vector3D;
import math.geom3d.line.LineSegment3D;
import math.geom3d.plane.Plane3D;
import math.geom3d.polygon.SimplePlanarPolygon3D;

public class Plane3DCoordinateSubsystem {
    private Plane3D plane;
    protected Vector3D xUnitVector;
    protected Vector3D yUnitVector;

    public Plane3DCoordinateSubsystem(Plane3D plane) {
        this.plane = plane;
        this.xUnitVector = plane.getVector1().getNormalizedVector();
        this.yUnitVector = plane.getVector2().minus(this.getXUnitVector().times(Vector3D.dotProduct(plane.getVector2(), this.xUnitVector))).getNormalizedVector();
    }

    public Vector3D getXUnitVector() {
        return this.xUnitVector;
    }

    public Vector3D getYUnitVector() {
        return this.yUnitVector;
    }

    public math.geom2d.Point2D project(Point3D point) {
        Vector3D originOffset = new Vector3D(this.plane.getOrigin(), this.plane.project(point));
        return new math.geom2d.Point2D(Vector3D.dotProduct(originOffset, this.getXUnitVector()), Vector3D.dotProduct(originOffset, this.getYUnitVector()));
    }

    public SimplePolygon2D project(SimplePlanarPolygon3D polygon3d) {
        ArrayList vertices2d = Lists.newArrayList();
        for (Point3D vertex3d : polygon3d.getVertices()) {
            vertices2d.add(this.project(vertex3d));
        }
        return new SimplePolygon2D(vertices2d);
    }

    public LineSegment2D project(LineSegment3D lineSegment3D) {
        return new LineSegment2D((Point2D)this.project(lineSegment3D.getFirstPoint()), this.project(lineSegment3D.getLastPoint()));
    }

    public Point3D get(math.geom2d.Point2D point) {
        return this.plane.getOrigin().plus(this.getXUnitVector().times(point.getX())).plus(this.getYUnitVector().times(point.getY()));
    }
}

