/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.line;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.JavaGeomMath;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.UnboundedShapeException;
import math.geom2d.domain.SmoothOrientedCurve2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.LinearShape2D;

@Deprecated
public class LineArc2D
extends AbstractLine2D
implements SmoothOrientedCurve2D,
Cloneable {
    protected double t0 = 0.0;
    protected double t1 = 1.0;

    public LineArc2D(Point2D point1, Point2D point2, double t0, double t1) {
        this(point1.getX(), point1.getY(), point2.getX() - point1.getX(), point2.getY() - point1.getY(), t0, t1);
    }

    public LineArc2D(LinearShape2D line, double t0, double t1) {
        super(line);
        this.t0 = t0;
        this.t1 = t1;
    }

    public LineArc2D(LineArc2D line) {
        this(line.x0, line.y0, line.dx, line.dy, line.t0, line.t1);
    }

    public LineArc2D(double x1, double y1, double dx, double dy, double t0, double t1) {
        super(x1, y1, dx, dy);
        this.t0 = t0;
        this.t1 = t1;
    }

    public LineArc2D create(Point2D p1, Point2D p2, double t0, double t1) {
        return new LineArc2D(p1, p2, t0, t1);
    }

    @Override
    public double getLength() {
        if (this.t0 != Double.NEGATIVE_INFINITY && this.t1 != Double.POSITIVE_INFINITY) {
            return this.getPoint1().getDistance(this.getPoint2());
        }
        return Double.POSITIVE_INFINITY;
    }

    public Point2D getPoint1() {
        if (this.t0 != Double.NEGATIVE_INFINITY) {
            return new Point2D(this.x0 + this.t0 * this.dx, this.y0 + this.t0 * this.dy);
        }
        throw new UnboundedShapeException(this);
    }

    public Point2D getPoint2() {
        if (this.t1 != Double.POSITIVE_INFINITY) {
            return new Point2D(this.x0 + this.t1 * this.dx, this.y0 + this.t1 * this.dy);
        }
        throw new UnboundedShapeException(this);
    }

    public double getX1() {
        if (this.t0 != Double.NEGATIVE_INFINITY) {
            return this.x0 + this.t0 * this.dx;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getY1() {
        if (this.t0 != Double.NEGATIVE_INFINITY) {
            return this.y0 + this.t0 * this.dy;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getX2() {
        if (this.t1 != Double.POSITIVE_INFINITY) {
            return this.x0 + this.t1 * this.dx;
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getY2() {
        if (this.t1 != Double.POSITIVE_INFINITY) {
            return this.y0 + this.t1 * this.dy;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean containsParametric(double t) {
        return this.t0 <= t && t <= this.t1;
    }

    @Override
    public LineArc2D getParallel(double d) {
        double dd = JavaGeomMath.hypot(this.dx, this.dy);
        return new LineArc2D(this.x0 + this.dy * d / dd, this.y0 - this.dx * d / dd, this.dx, this.dy, this.t0, this.t1);
    }

    @Override
    public double getT0() {
        return this.t0;
    }

    @Override
    public double getT1() {
        return this.t1;
    }

    @Override
    public Point2D getPoint(double t) {
        if (t < this.t0) {
            t = this.t0;
        }
        if (t > this.t1) {
            t = this.t1;
        }
        if (Double.isInfinite(t)) {
            throw new UnboundedShapeException(this);
        }
        return new Point2D(this.x0 + this.dx * t, this.y0 + this.dy * t);
    }

    @Override
    public Point2D getFirstPoint() {
        if (!Double.isInfinite(this.t0)) {
            return new Point2D(this.x0 + this.t0 * this.dx, this.y0 + this.t0 * this.dy);
        }
        throw new UnboundedShapeException(this);
    }

    @Override
    public Point2D getLastPoint() {
        if (!Double.isInfinite(this.t1)) {
            return new Point2D(this.x0 + this.t1 * this.dx, this.y0 + this.t1 * this.dy);
        }
        throw new UnboundedShapeException(this);
    }

    @Override
    public Collection<Point2D> getSingularPoints() {
        ArrayList<Point2D> list = new ArrayList<Point2D>(2);
        if (this.t0 != Double.NEGATIVE_INFINITY) {
            list.add(this.getFirstPoint());
        }
        if (this.t1 != Double.POSITIVE_INFINITY) {
            list.add(this.getLastPoint());
        }
        return list;
    }

    @Override
    public boolean isSingular(double pos) {
        if (Math.abs(pos - this.t0) < 1.0E-12) {
            return true;
        }
        return Math.abs(pos - this.t1) < 1.0E-12;
    }

    public Collection<? extends LineArc2D> getContinuousCurves() {
        return LineArc2D.wrapCurve(this);
    }

    @Override
    public LineArc2D getReverseCurve() {
        return new LineArc2D(this.x0, this.y0, -this.dx, -this.dy, -this.t1, -this.t0);
    }

    @Override
    public LineArc2D getSubCurve(double t0, double t1) {
        t0 = Math.max(t0, this.getT0());
        t1 = Math.min(t1, this.getT1());
        return new LineArc2D(this, t0, t1);
    }

    @Override
    public boolean isBounded() {
        if (this.t1 == Double.POSITIVE_INFINITY) {
            return false;
        }
        return this.t0 != Double.NEGATIVE_INFINITY;
    }

    @Override
    public Box2D getBoundingBox() {
        return new Box2D(this.x0 + this.t0 * this.dx, this.x0 + this.t1 * this.dx, this.y0 + this.t0 * this.dy, this.y0 + this.t1 * this.dy);
    }

    @Override
    public boolean contains(java.awt.geom.Point2D pt) {
        return this.contains(pt.getX(), pt.getY());
    }

    @Override
    public boolean contains(double xp, double yp) {
        if (!super.supportContains(xp, yp)) {
            return false;
        }
        double t = this.getPositionOnLine(xp, yp);
        if (t - this.t0 < -1.0E-12) {
            return false;
        }
        return !(t - this.t1 > 1.0E-12);
    }

    public GeneralPath getGeneralPath() {
        if (!this.isBounded()) {
            throw new UnboundedShapeException(this);
        }
        GeneralPath path = new GeneralPath();
        path.moveTo((float)(this.x0 + this.t0 * this.dx), (float)(this.y0 + this.t0 * this.dy));
        path.lineTo((float)(this.x0 + this.t1 * this.dx), (float)(this.y0 + this.t1 * this.dy));
        return path;
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        if (!this.isBounded()) {
            throw new UnboundedShapeException(this);
        }
        if (this.t0 == Double.NEGATIVE_INFINITY) {
            return path;
        }
        if (this.t1 == Double.POSITIVE_INFINITY) {
            return path;
        }
        path.lineTo((float)this.getX1(), (float)this.getY1());
        path.lineTo((float)this.getX2(), (float)this.getY2());
        return path;
    }

    @Override
    public LineArc2D transform(AffineTransform2D trans) {
        double[] tab = trans.getCoefficients();
        double x1 = this.x0 * tab[0] + this.y0 * tab[1] + tab[2];
        double y1 = this.x0 * tab[3] + this.y0 * tab[4] + tab[5];
        return new LineArc2D(x1, y1, this.dx * tab[0] + this.dy * tab[1], this.dx * tab[3] + this.dy * tab[4], this.t0, this.t1);
    }

    public String toString() {
        return new String("LineArc2D(" + this.x0 + "," + this.y0 + "," + this.dx + "," + this.dy + "," + this.t0 + "," + this.t1 + ")");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LineArc2D)) {
            return false;
        }
        LineArc2D arc = (LineArc2D)obj;
        if (!this.isColinear(arc)) {
            return false;
        }
        if (this.t0 == Double.NEGATIVE_INFINITY && this.t1 == Double.POSITIVE_INFINITY) {
            if (arc.t0 != Double.NEGATIVE_INFINITY) {
                return false;
            }
            return arc.t1 == Double.POSITIVE_INFINITY;
        }
        if (this.t0 == Double.NEGATIVE_INFINITY) {
            if (arc.t0 == Double.NEGATIVE_INFINITY) {
                return this.getPoint2().getDistance(arc.getPoint2()) < 1.0E-12;
            }
            if (arc.t1 == Double.POSITIVE_INFINITY) {
                return this.getPoint2().getDistance(arc.getPoint1()) < 1.0E-12;
            }
            return false;
        }
        if (this.t1 == Double.POSITIVE_INFINITY) {
            if (arc.t0 == Double.NEGATIVE_INFINITY) {
                return this.getPoint1().getDistance(arc.getPoint2()) < 1.0E-12;
            }
            if (arc.t1 == Double.POSITIVE_INFINITY) {
                return this.getPoint1().getDistance(arc.getPoint1()) < 1.0E-12;
            }
            return false;
        }
        if (arc.t0 == Double.NEGATIVE_INFINITY || arc.t0 == Double.POSITIVE_INFINITY) {
            return false;
        }
        if (arc.t1 == Double.NEGATIVE_INFINITY || arc.t1 == Double.POSITIVE_INFINITY) {
            return false;
        }
        if (this.getPoint1().getDistance(arc.getPoint1()) < 1.0E-12) {
            return this.getPoint2().getDistance(arc.getPoint2()) < 1.0E-12;
        }
        if (this.getPoint1().getDistance(arc.getPoint2()) > 1.0E-12) {
            return false;
        }
        return !(this.getPoint2().getDistance(arc.getPoint1()) > 1.0E-12);
    }

    @Override
    public LineArc2D clone() {
        return new LineArc2D(this.x0, this.y0, this.dx, this.dy, this.t0, this.t1);
    }
}

