/*
 * Decompiled with CFR 0.152.
 */
package math.bsp.algorithm.raycast;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import math.bsp.IConstBspTree;
import math.bsp.algorithm.raycast.internal.CollisionIterator;

public abstract class BspRayCaster<TData, TBoundary, TRay, TCollision>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final IConstBspTree<TData, TBoundary> tree;
    public final boolean doDuplicateCollisionsOccur;

    public BspRayCaster(IConstBspTree<TData, TBoundary> tree, boolean doDuplicateCollisionsOccur) {
        this.tree = tree;
        this.doDuplicateCollisionsOccur = doDuplicateCollisionsOccur;
    }

    public TCollision getCollision(TRay ray) {
        CollisionIterator iterator = new CollisionIterator(this, ray);
        if (iterator.hasNext()) {
            return (TCollision)iterator.next();
        }
        return null;
    }

    public List<TCollision> getCollisions(TRay ray) {
        ArrayList retval = Lists.newArrayList();
        CollisionIterator iterator = new CollisionIterator(this, ray);
        while (iterator.hasNext()) {
            retval.add(iterator.next());
        }
        return retval;
    }

    public Iterator<TCollision> getCollisionIterator(TRay ray) {
        return new CollisionIterator(this, ray);
    }

    public abstract double computeSideSignedDistanceSquare(TBoundary var1, TRay var2);

    public abstract List<TCollision> getCollisions(TRay var1, double var2, double var4, TData var6);
}

