/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d.polygon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import math.geom2d.Point2D;
import math.geom2d.polygon.SimplePolygon2D;
import math.geom3d.Point3D;
import math.geom3d.plane.Plane3D;

public class SimplePlanarPolygon3D {
    protected List<Point3D> vertices;
    protected transient SimplePolygon2D polygonIn2d = null;
    protected transient Plane3D plane = null;

    public SimplePlanarPolygon3D(Collection<Point3D> vertices) {
        assert (vertices.size() >= 3);
        this.vertices = Collections.unmodifiableList(new ArrayList<Point3D>(vertices));
    }

    public List<Point3D> getVertices() {
        return this.vertices;
    }

    public Plane3D getPlane() {
        if (this.plane == null) {
            this.plane = Plane3D.createPlaneDefinedByPoints(this.vertices);
        }
        return this.plane;
    }

    public SimplePolygon2D getPolygonIn2d() {
        if (this.polygonIn2d == null) {
            this.polygonIn2d = this.getPlane().getCoordinateSubsystem().project(this);
        }
        return this.polygonIn2d;
    }

    public Point3D getCentroid() {
        return this.getPlane().getCoordinateSubsystem().get(this.getPolygonIn2d().getCentroid());
    }

    public double getArea() {
        return this.getPolygonIn2d().getArea();
    }

    public Point3D project(Point3D point) {
        Point2D point2d = this.getPlane().getCoordinateSubsystem().project(point);
        Point2D closest2d = this.getPolygonIn2d().project(point2d);
        return this.getPlane().getCoordinateSubsystem().get(closest2d);
    }

    public double getDistance(Point3D from) {
        return this.project(from).getDistance(from);
    }

    public String toString() {
        String retval = "SimplePlanarPolygon3D( ";
        for (Point3D vertex : this.vertices) {
            if (retval.length() > 23) {
                retval = retval + ", ";
            }
            retval = retval + vertex.toString();
        }
        return retval + " )";
    }
}

