/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d.plane;

import java.io.Serializable;
import math.geom3d.Axis3D;
import math.geom3d.Point3D;
import math.geom3d.Vector3D;
import math.geom3d.line.StraightLine3D;
import math.geom3d.plane.Plane3D;

public class AxisAlignedPlane3D
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Axis3D axis;
    public final double origin;

    public AxisAlignedPlane3D(Axis3D axis, double origin) {
        this.axis = axis;
        this.origin = origin;
    }

    public double getAxisCoord(Point3D point) {
        return this.axis.getCoord(point);
    }

    public double getAxisCoord(Vector3D vector) {
        return this.axis.getCoord(vector);
    }

    public Point3D getLineIntersection(StraightLine3D line) {
        double t = this.getLineIntersectionParametric(line);
        if (!Double.isInfinite(t) && !Double.isNaN(t)) {
            return line.getPoint(t);
        }
        return null;
    }

    public double getLineIntersectionParametric(StraightLine3D line) {
        double distance = this.origin - this.getAxisCoord(line.getOrigin());
        double directionInverse = this.getAxisCoord(line.getVectorInverse());
        if (directionInverse > 1.0E12) {
            return Double.NaN;
        }
        return distance * directionInverse;
    }

    public Plane3D asPlane3D() {
        Plane3D referencePlane = null;
        switch (this.axis) {
            case X: {
                referencePlane = Plane3D.yzPlane;
                break;
            }
            case Y: {
                referencePlane = Plane3D.xzPlane;
                break;
            }
            case Z: {
                referencePlane = Plane3D.xyPlane;
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid axis.");
            }
        }
        return new Plane3D(this.getOriginPoint(), referencePlane.getVector1(), referencePlane.getVector2());
    }

    public Point3D getOriginPoint() {
        switch (this.axis) {
            case X: {
                return new Point3D(this.origin, 0.0, 0.0);
            }
            case Y: {
                return new Point3D(0.0, this.origin, 0.0);
            }
            case Z: {
                return new Point3D(0.0, 0.0, this.origin);
            }
        }
        throw new AssertionError((Object)"Invalid axis.");
    }

    public double getSignedDistance(Point3D point) {
        return this.getAxisCoord(point) - this.origin;
    }

    public String toString() {
        return "AxisAlignedPlane3D( " + this.axis.name() + ", " + this.origin + " )";
    }
}

