/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.line;

import java.util.ArrayList;
import java.util.Collection;
import math.JavaGeomMath;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CirculinearCurve2DUtils;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.conic.CircleArc2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.domain.SmoothOrientedCurve2D;
import math.geom2d.line.InvertedRay2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.Ray2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.transform.CircleInversion2D;

public abstract class AbstractLine2D
extends AbstractSmoothCurve2D
implements SmoothOrientedCurve2D,
LinearShape2D,
CirculinearElement2D {
    protected double x0;
    protected double y0;
    protected double dx;
    protected double dy;

    @Deprecated
    public static final Point2D getIntersection(AbstractLine2D l1, AbstractLine2D l2) {
        double t = ((l1.y0 - l2.y0) * l2.dx - (l1.x0 - l2.x0) * l2.dy) / (l1.dx * l2.dy - l1.dy * l2.dx);
        return new Point2D(l1.x0 + t * l1.dx, l1.y0 + t * l1.dy);
    }

    public static final boolean isColinear(AbstractLine2D line1, AbstractLine2D line2) {
        if (Math.abs(line1.dx * line2.dy - line1.dy * line2.dx) > 1.0E-12) {
            return false;
        }
        return Math.abs((line2.y0 - line1.y0) * line2.dx - (line2.x0 - line1.x0) * line2.dy) / JavaGeomMath.hypot(line2.dx, line2.dy) < 1.0E-12;
    }

    public static final boolean isParallel(AbstractLine2D line1, AbstractLine2D line2) {
        return Math.abs(line1.dx * line2.dy - line1.dy * line2.dx) < 1.0E-12;
    }

    protected AbstractLine2D(double x0, double y0, double dx, double dy) {
        this.x0 = x0;
        this.y0 = y0;
        this.dx = dx;
        this.dy = dy;
    }

    protected AbstractLine2D(Point2D point, Vector2D vector) {
        this.x0 = point.getX();
        this.y0 = point.getY();
        this.dx = vector.getX();
        this.dy = vector.getY();
    }

    protected AbstractLine2D(LinearShape2D line) {
        this(line.getOrigin(), line.getVector());
    }

    public boolean isColinear(LinearShape2D linear) {
        if (!this.isParallel(linear)) {
            return false;
        }
        StraightLine2D line = linear.getSupportingLine();
        if (Math.abs(this.dx) > Math.abs(this.dy)) {
            return !(Math.abs((line.x0 - this.x0) * this.dy / this.dx + this.y0 - line.y0) > 1.0E-12);
        }
        return !(Math.abs((line.y0 - this.y0) * this.dx / this.dy + this.x0 - line.x0) > 1.0E-12);
    }

    public boolean isParallel(LinearShape2D line) {
        return Vector2D.isColinear(this.getVector(), line.getVector());
    }

    protected boolean supportContains(double x, double y) {
        return Math.abs((x - this.x0) * this.dy - (y - this.y0) * this.dx) / JavaGeomMath.hypot(this.dx, this.dy) < 1.0E-12;
    }

    public double[][] getParametric() {
        double[][] tab = new double[2][2];
        tab[0][0] = this.x0;
        tab[0][1] = this.dx;
        tab[1][0] = this.y0;
        tab[1][1] = this.dy;
        return tab;
    }

    public double[] getCartesianEquation() {
        double[] tab = new double[]{this.dy, -this.dx, this.dx * this.y0 - this.dy * this.x0};
        return tab;
    }

    public double[] getPolarCoefficients() {
        double[] tab = new double[2];
        double d = this.getSignedDistance(0.0, 0.0);
        tab[0] = Math.abs(d);
        tab[1] = d > 0.0 ? (this.getHorizontalAngle() + Math.PI) % (Math.PI * 2) : this.getHorizontalAngle();
        return tab;
    }

    public double[] getSignedPolarCoefficients() {
        double[] tab = new double[]{this.getSignedDistance(0.0, 0.0), this.getHorizontalAngle()};
        return tab;
    }

    public double getPositionOnLine(java.awt.geom.Point2D point) {
        return this.getPositionOnLine(point.getX(), point.getY());
    }

    public double getPositionOnLine(double x, double y) {
        return ((y - this.y0) * this.dy + (x - this.x0) * this.dx) / (this.dx * this.dx + this.dy * this.dy);
    }

    public Point2D getProjectedPoint(Point2D p) {
        return this.getProjectedPoint(p.getX(), p.getY());
    }

    public Point2D getProjectedPoint(double x, double y) {
        if (this.contains(x, y)) {
            return new Point2D(x, y);
        }
        double t = this.getPositionOnLine(x, y);
        return new Point2D(this.x0 + t * this.dx, this.y0 + t * this.dy);
    }

    public Point2D getSymmetric(Point2D p) {
        return this.getSymmetric(p.getX(), p.getY());
    }

    public Point2D getSymmetric(double x, double y) {
        double t = 2.0 * this.getPositionOnLine(x, y);
        return new Point2D(2.0 * this.x0 + t * this.dx - x, 2.0 * this.y0 + t * this.dy - y);
    }

    public StraightLine2D getParallel(Point2D point) {
        return new StraightLine2D(point, this.dx, this.dy);
    }

    public StraightLine2D getPerpendicular(Point2D point) {
        return new StraightLine2D(point, -this.dy, this.dx);
    }

    @Override
    public Point2D getOrigin() {
        return new Point2D(this.x0, this.y0);
    }

    @Override
    public Vector2D getVector() {
        return new Vector2D(this.dx, this.dy);
    }

    @Override
    public double getHorizontalAngle() {
        return (Math.atan2(this.dy, this.dx) + Math.PI * 2) % (Math.PI * 2);
    }

    @Override
    public Point2D getIntersection(LinearShape2D line) {
        double t = this.getIntersectionParametric(line);
        if (Double.isInfinite(t) || Double.isNaN(t)) {
            return null;
        }
        return this.getPoint(t);
    }

    public double getIntersectionParametric(LinearShape2D line) {
        Vector2D vect = line.getVector();
        double dx2 = vect.getX();
        double dy2 = vect.getY();
        if (Math.abs(this.dx * dy2 - this.dy * dx2) < 1.0E-12) {
            return Double.NaN;
        }
        Point2D origin = line.getOrigin();
        double x2 = origin.getX();
        double y2 = origin.getY();
        double t = ((this.y0 - y2) * dx2 - (this.x0 - x2) * dy2) / (this.dx * dy2 - this.dy * dx2);
        if (!this.containsParametric(t)) {
            return Double.NaN;
        }
        if (!line.contains(this.getPoint(t))) {
            return Double.NaN;
        }
        return t;
    }

    @Override
    public StraightLine2D getSupportingLine() {
        return new StraightLine2D(this);
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        return CirculinearCurve2DUtils.computeBuffer(this, dist);
    }

    @Override
    public double getLength() {
        if (!this.isBounded()) {
            return Double.POSITIVE_INFINITY;
        }
        return (this.getT1() - this.getT0()) * JavaGeomMath.hypot(this.dx, this.dy);
    }

    @Override
    public double getLength(double pos) {
        return pos * JavaGeomMath.hypot(this.dx, this.dy);
    }

    @Override
    public double getPosition(double length) {
        return length / JavaGeomMath.hypot(this.dx, this.dy);
    }

    @Override
    public CirculinearElement2D transform(CircleInversion2D inv) {
        boolean direct;
        Point2D center = inv.getCenter();
        double r = inv.getRadius();
        Point2D po = this.getProjectedPoint(center);
        double d = this.getDistance(po);
        boolean inf0 = Double.isInfinite(this.getT0());
        boolean inf1 = Double.isInfinite(this.getT1());
        if (Math.abs(d) < 1.0E-12) {
            if (inf0) {
                if (inf1) {
                    return new StraightLine2D(this);
                }
                Point2D p2 = this.getLastPoint().transform(inv);
                return new InvertedRay2D(p2, this.getVector());
            }
            Point2D p1 = this.getFirstPoint().transform(inv);
            if (inf1) {
                return new Ray2D(p1, this.getVector());
            }
            Point2D p2 = this.getLastPoint().transform(inv);
            return new LineSegment2D((java.awt.geom.Point2D)p1, p2);
        }
        double angle = Angle2D.getHorizontalAngle(center, po);
        double r2 = r * r / d / 2.0;
        Point2D c2 = Point2D.createPolar(center, r2, angle);
        boolean bl = direct = !this.isInside(center);
        if (inf0 && inf1) {
            return new Circle2D(c2, r2, direct);
        }
        Point2D p1 = inf0 ? center : this.getFirstPoint();
        Point2D p2 = inf1 ? center : this.getLastPoint();
        double theta1 = Angle2D.getHorizontalAngle(c2, p1);
        double theta2 = Angle2D.getHorizontalAngle(c2, p2);
        return new CircleArc2D(c2, r2, theta1, theta2, direct);
    }

    @Override
    public double getWindingAngle(java.awt.geom.Point2D point) {
        double t0 = this.getT0();
        double t1 = this.getT1();
        double angle1 = t0 == Double.NEGATIVE_INFINITY ? Angle2D.getHorizontalAngle(-this.dx, -this.dy) : Angle2D.getHorizontalAngle(point.getX(), point.getY(), this.x0 + t0 * this.dx, this.y0 + t0 * this.dy);
        double angle2 = t1 == Double.POSITIVE_INFINITY ? Angle2D.getHorizontalAngle(this.dx, this.dy) : Angle2D.getHorizontalAngle(point.getX(), point.getY(), this.x0 + t1 * this.dx, this.y0 + t1 * this.dy);
        if (this.isInside(point)) {
            if (angle2 > angle1) {
                return angle2 - angle1;
            }
            return Math.PI * 2 - angle1 + angle2;
        }
        if (angle2 > angle1) {
            return angle2 - angle1 - Math.PI * 2;
        }
        return angle2 - angle1;
    }

    @Override
    public double getSignedDistance(java.awt.geom.Point2D p) {
        return this.getSignedDistance(p.getX(), p.getY());
    }

    @Override
    public double getSignedDistance(double x, double y) {
        return ((x - this.x0) * this.dy - (y - this.y0) * this.dx) / JavaGeomMath.hypot(this.dx, this.dy);
    }

    @Override
    public boolean isInside(java.awt.geom.Point2D p) {
        return (p.getX() - this.x0) * this.dy - (p.getY() - this.y0) * this.dx < 0.0;
    }

    @Override
    public Vector2D getTangent(double t) {
        return new Vector2D(this.dx, this.dy);
    }

    @Override
    public double getCurvature(double t) {
        return 0.0;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public Collection<? extends AbstractLine2D> getSmoothPieces() {
        return AbstractLine2D.wrapCurve(this);
    }

    @Override
    public Collection<Point2D> getIntersections(LinearShape2D line) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        Point2D point = this.getIntersection(line);
        if (point == null) {
            return points;
        }
        points.add(point);
        return points;
    }

    @Override
    public double getPosition(java.awt.geom.Point2D point) {
        double pos = this.getPositionOnLine(point);
        if (pos < this.getT0()) {
            return Double.NaN;
        }
        if (pos > this.getT1()) {
            return Double.NaN;
        }
        return pos;
    }

    @Override
    public double project(java.awt.geom.Point2D point) {
        double pos = this.getPositionOnLine(point);
        return Math.min(Math.max(pos, this.getT0()), this.getT1());
    }

    @Override
    public AbstractLine2D getSubCurve(double t0, double t1) {
        t0 = Math.max(t0, this.getT0());
        if (Double.isInfinite(t1 = Math.min(t1, this.getT1()))) {
            if (Double.isInfinite(t0)) {
                return new StraightLine2D(this);
            }
            return new Ray2D(this.getPoint(t0), this.getVector());
        }
        if (Double.isInfinite(t0)) {
            return new InvertedRay2D(this.getPoint(t1), this.getVector());
        }
        return new LineSegment2D((java.awt.geom.Point2D)this.getPoint(t0), this.getPoint(t1));
    }

    public Collection<? extends AbstractLine2D> getContinuousCurves() {
        return AbstractLine2D.wrapCurve(this);
    }

    @Override
    public double getDistance(java.awt.geom.Point2D p) {
        return this.getDistance(p.getX(), p.getY());
    }

    @Override
    public double getDistance(double x, double y) {
        Point2D proj = this.getProjectedPoint(x, y);
        if (this.contains(proj)) {
            return proj.distance(x, y);
        }
        double dist = Double.POSITIVE_INFINITY;
        if (!Double.isInfinite(this.getT0())) {
            dist = this.getFirstPoint().getDistance(x, y);
        }
        if (!Double.isInfinite(this.getT1())) {
            dist = Math.min(dist, this.getLastPoint().getDistance(x, y));
        }
        return dist;
    }

    @Override
    public boolean contains(java.awt.geom.Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public abstract boolean containsParametric(double var1);

    @Override
    public boolean isEmpty() {
        return JavaGeomMath.hypot(this.dx, this.dy) < 1.0E-12;
    }

    @Override
    public abstract AbstractLine2D transform(AffineTransform2D var1);

    @Override
    public CurveSet2D<? extends AbstractLine2D> clip(Box2D box) {
        CurveSet2D<ContinuousCurve2D> set = Curve2DUtils.clipContinuousCurve(this, box);
        CurveArray2D<AbstractLine2D> result = new CurveArray2D<AbstractLine2D>(set.getCurveNumber());
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof AbstractLine2D)) continue;
            result.addCurve((AbstractLine2D)curve2D);
        }
        return result;
    }

    @Override
    public abstract AbstractLine2D clone();
}

