/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.domain;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.domain.Boundary2D;
import math.geom2d.domain.ContinuousBoundary2D;
import math.geom2d.domain.ContinuousOrientedCurve2D;
import math.geom2d.domain.Domain2D;
import math.geom2d.domain.GenericDomain2D;
import math.geom2d.domain.OrientedCurve2D;

public class BoundarySet2D<T extends ContinuousBoundary2D>
extends CurveArray2D<T>
implements Boundary2D {
    public BoundarySet2D() {
    }

    public BoundarySet2D(int size) {
        super(size);
    }

    public BoundarySet2D(T[] curves) {
        super(curves);
    }

    public BoundarySet2D(Collection<? extends T> curves) {
        super(curves);
    }

    public BoundarySet2D(T curve) {
        this.addCurve(curve);
    }

    public static <T extends ContinuousBoundary2D> BoundarySet2D<T> create(Collection<T> curves) {
        return new BoundarySet2D<Collection<T>>(curves);
    }

    public static <T extends ContinuousBoundary2D> BoundarySet2D<T> create(T[] curves) {
        return new BoundarySet2D<T[]>(curves);
    }

    public Collection<ContinuousBoundary2D> getBoundaryCurves() {
        ArrayList<ContinuousBoundary2D> list = new ArrayList<ContinuousBoundary2D>(this.curves.size());
        for (Curve2D curve : this.curves) {
            list.add((ContinuousBoundary2D)curve);
        }
        return list;
    }

    @Override
    public Domain2D getDomain() {
        return new GenericDomain2D(this);
    }

    @Override
    public void fill(Graphics2D g2) {
        g2.fill(this.getGeneralPath());
    }

    @Override
    public double getWindingAngle(Point2D point) {
        double angle = 0.0;
        for (OrientedCurve2D curve : this.getCurves()) {
            angle += curve.getWindingAngle(point);
        }
        return angle;
    }

    @Override
    public double getSignedDistance(Point2D p) {
        return this.getSignedDistance(p.getX(), p.getY());
    }

    @Override
    public double getSignedDistance(double x, double y) {
        double minDist = Double.POSITIVE_INFINITY;
        double dist = Double.POSITIVE_INFINITY;
        for (OrientedCurve2D curve : this.getCurves()) {
            if (!(Math.abs(dist = Math.min(dist, curve.getSignedDistance(x, y))) < Math.abs(minDist))) continue;
            minDist = dist;
        }
        return minDist;
    }

    @Override
    public boolean isInside(Point2D point) {
        return this.getSignedDistance(point.getX(), point.getY()) < 0.0;
    }

    @Override
    public BoundarySet2D<? extends ContinuousBoundary2D> getReverseCurve() {
        ContinuousBoundary2D[] curves2 = new ContinuousBoundary2D[this.curves.size()];
        int n = this.curves.size();
        for (int i = 0; i < n; ++i) {
            curves2[i] = (ContinuousBoundary2D)((ContinuousBoundary2D)this.curves.get(n - 1 - i)).getReverseCurve();
        }
        return new BoundarySet2D<ContinuousBoundary2D[]>(curves2);
    }

    @Override
    public CurveSet2D<? extends ContinuousOrientedCurve2D> getSubCurve(double t0, double t1) {
        Curve2D curveSet = super.getSubCurve(t0, t1);
        ArrayList<ContinuousOrientedCurve2D> curves = new ArrayList<ContinuousOrientedCurve2D>();
        for (Curve2D curve : ((CurveSet2D)curveSet).getCurves()) {
            curves.add((ContinuousOrientedCurve2D)curve);
        }
        return new CurveArray2D(curves);
    }

    @Override
    public CurveSet2D<? extends ContinuousOrientedCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curve2DUtils.clipCurve(this, box);
        CurveArray2D<ContinuousOrientedCurve2D> result = new CurveArray2D<ContinuousOrientedCurve2D>(set.getCurveNumber());
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof ContinuousOrientedCurve2D)) continue;
            result.addCurve((ContinuousOrientedCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public BoundarySet2D<? extends ContinuousBoundary2D> transform(AffineTransform2D trans) {
        BoundarySet2D<ContinuousBoundary2D> result = new BoundarySet2D<ContinuousBoundary2D>(this.curves.size());
        for (Curve2D curve : this.curves) {
            result.addCurve((ContinuousBoundary2D)curve.transform(trans));
        }
        return result;
    }
}

