/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.spline;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.domain.ContinuousOrientedCurve2D;
import math.geom2d.line.LinearShape2D;

public class CubicBezierCurve2D
extends AbstractSmoothCurve2D
implements SmoothCurve2D,
ContinuousOrientedCurve2D,
Cloneable {
    protected double x1;
    protected double y1;
    protected double ctrlx1;
    protected double ctrly1;
    protected double ctrlx2;
    protected double ctrly2;
    protected double x2;
    protected double y2;

    public CubicBezierCurve2D() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public CubicBezierCurve2D(double[][] coefs) {
        this(coefs[0][0], coefs[1][0], coefs[0][0] + coefs[0][1] / 3.0, coefs[1][0] + coefs[1][1] / 3.0, coefs[0][0] + 2.0 * coefs[0][1] / 3.0 + coefs[0][2] / 3.0, coefs[1][0] + 2.0 * coefs[1][1] / 3.0 + coefs[1][2] / 3.0, coefs[0][0] + coefs[0][1] + coefs[0][2] + coefs[0][3], coefs[1][0] + coefs[1][1] + coefs[1][2] + coefs[1][3]);
    }

    public CubicBezierCurve2D(java.awt.geom.Point2D p1, java.awt.geom.Point2D ctrl1, java.awt.geom.Point2D ctrl2, java.awt.geom.Point2D p2) {
        this(p1.getX(), p1.getY(), ctrl1.getX(), ctrl1.getY(), ctrl2.getX(), ctrl2.getY(), p2.getX(), p2.getY());
    }

    public CubicBezierCurve2D(java.awt.geom.Point2D p1, Vector2D v1, java.awt.geom.Point2D p2, Vector2D v2) {
        this(p1.getX(), p1.getY(), p1.getX() + v1.getX() / 3.0, p1.getY() + v1.getY() / 3.0, p2.getX() - v2.getX() / 3.0, p2.getY() - v2.getY() / 3.0, p2.getX(), p2.getY());
    }

    public CubicBezierCurve2D(double x1, double y1, double xctrl1, double yctrl1, double xctrl2, double yctrl2, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.ctrlx1 = xctrl1;
        this.ctrly1 = yctrl1;
        this.ctrlx2 = xctrl2;
        this.ctrly2 = yctrl2;
        this.x2 = x2;
        this.y2 = y2;
    }

    public static final CubicBezierCurve2D create(Point2D p1, Point2D c1, Point2D c2, Point2D p2) {
        return new CubicBezierCurve2D((java.awt.geom.Point2D)p1, c1, (java.awt.geom.Point2D)c2, p2);
    }

    public static final CubicBezierCurve2D create(Point2D p1, Vector2D v1, Point2D p2, Vector2D v2) {
        return new CubicBezierCurve2D((java.awt.geom.Point2D)p1, v1, (java.awt.geom.Point2D)p2, v2);
    }

    public Point2D getControl1() {
        return new Point2D(this.ctrlx1, this.ctrly1);
    }

    public Point2D getControl2() {
        return new Point2D(this.ctrlx2, this.ctrly2);
    }

    public Point2D getP1() {
        return this.getFirstPoint();
    }

    public Point2D getP2() {
        return this.getLastPoint();
    }

    public Point2D getCtrlP1() {
        return this.getControl1();
    }

    public Point2D getCtrlP2() {
        return this.getControl2();
    }

    public double[][] getParametric() {
        double[][] tab = new double[2][4];
        tab[0][0] = this.x1;
        tab[0][1] = 3.0 * this.ctrlx1 - 3.0 * this.x1;
        tab[0][2] = 3.0 * this.x1 - 6.0 * this.ctrlx1 + 3.0 * this.ctrlx2;
        tab[0][3] = this.x2 - 3.0 * this.ctrlx2 + 3.0 * this.ctrlx1 - this.x1;
        tab[1][0] = this.y1;
        tab[1][1] = 3.0 * this.ctrly1 - 3.0 * this.y1;
        tab[1][2] = 3.0 * this.y1 - 6.0 * this.ctrly1 + 3.0 * this.ctrly2;
        tab[1][3] = this.y2 - 3.0 * this.ctrly2 + 3.0 * this.ctrly1 - this.y1;
        return tab;
    }

    @Override
    public double getWindingAngle(java.awt.geom.Point2D point) {
        return this.getAsPolyline(100).getWindingAngle(point);
    }

    @Override
    public boolean isInside(java.awt.geom.Point2D pt) {
        return this.getAsPolyline(100).isInside(pt);
    }

    @Override
    public double getSignedDistance(java.awt.geom.Point2D point) {
        if (this.isInside(point)) {
            return -this.getDistance(point.getX(), point.getY());
        }
        return this.getDistance(point.getX(), point.getY());
    }

    @Override
    public double getSignedDistance(double x, double y) {
        if (this.isInside(new Point2D(x, y))) {
            return -this.getDistance(x, y);
        }
        return this.getDistance(x, y);
    }

    @Override
    public Vector2D getTangent(double t) {
        double[][] c = this.getParametric();
        double dx = c[0][1] + (2.0 * c[0][2] + 3.0 * c[0][3] * t) * t;
        double dy = c[1][1] + (2.0 * c[1][2] + 3.0 * c[1][3] * t) * t;
        return new Vector2D(dx, dy);
    }

    @Override
    public double getCurvature(double t) {
        double[][] c = this.getParametric();
        double xp = c[0][1] + (2.0 * c[0][2] + 3.0 * c[0][3] * t) * t;
        double yp = c[1][1] + (2.0 * c[1][2] + 3.0 * c[1][3] * t) * t;
        double xs = 2.0 * c[0][2] + 6.0 * c[0][3] * t;
        double ys = 2.0 * c[1][2] + 6.0 * c[1][3] * t;
        return (xp * ys - yp * xs) / Math.pow(Math.hypot(xp, yp), 3.0);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public double getT0() {
        return 0.0;
    }

    @Override
    public double getT1() {
        return 1.0;
    }

    @Override
    public Collection<Point2D> getIntersections(LinearShape2D line) {
        return this.getAsPolyline(100).getIntersections(line);
    }

    @Override
    public Point2D getPoint(double t) {
        t = Math.min(Math.max(t, 0.0), 1.0);
        double[][] c = this.getParametric();
        double x = c[0][0] + (c[0][1] + (c[0][2] + c[0][3] * t) * t) * t;
        double y = c[1][0] + (c[1][1] + (c[1][2] + c[1][3] * t) * t) * t;
        return new Point2D(x, y);
    }

    @Override
    public Point2D getFirstPoint() {
        return new Point2D(this.x1, this.y1);
    }

    @Override
    public Point2D getLastPoint() {
        return new Point2D(this.x2, this.y2);
    }

    @Override
    public double getPosition(java.awt.geom.Point2D point) {
        int N = 100;
        return this.getAsPolyline(N).getPosition(point) / (double)N;
    }

    @Override
    public double project(java.awt.geom.Point2D point) {
        int N = 100;
        return this.getAsPolyline(N).project(point) / (double)N;
    }

    @Override
    public CubicBezierCurve2D getReverseCurve() {
        return new CubicBezierCurve2D((java.awt.geom.Point2D)this.getLastPoint(), this.getControl1(), (java.awt.geom.Point2D)this.getControl2(), this.getFirstPoint());
    }

    @Override
    public CubicBezierCurve2D getSubCurve(double t0, double t1) {
        if ((t0 = Math.max(t0, 0.0)) > (t1 = Math.min(t1, 1.0))) {
            return null;
        }
        double dt = t1 - t0;
        Vector2D v0 = this.getTangent(t0).times(dt);
        Vector2D v1 = this.getTangent(t1).times(dt);
        return new CubicBezierCurve2D((java.awt.geom.Point2D)this.getPoint(t0), v0, (java.awt.geom.Point2D)this.getPoint(t1), v1);
    }

    @Override
    public boolean contains(double x, double y) {
        return new CubicCurve2D.Double(this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2).contains(x, y);
    }

    @Override
    public boolean contains(java.awt.geom.Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public double getDistance(java.awt.geom.Point2D p) {
        return this.getDistance(p.getX(), p.getY());
    }

    @Override
    public double getDistance(double x, double y) {
        return this.getAsPolyline(100).getDistance(x, y);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public CurveSet2D<? extends CubicBezierCurve2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curve2DUtils.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<CubicBezierCurve2D> result = new CurveArray2D<CubicBezierCurve2D>(set.getCurveNumber());
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof CubicBezierCurve2D)) continue;
            result.addCurve((CubicBezierCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public Box2D getBoundingBox() {
        Point2D p1 = this.getFirstPoint();
        Point2D p2 = this.getControl1();
        Point2D p3 = this.getControl2();
        Point2D p4 = this.getLastPoint();
        double xmin = Math.min(Math.min(p1.getX(), p2.getX()), Math.min(p3.getX(), p4.getX()));
        double xmax = Math.max(Math.max(p1.getX(), p2.getX()), Math.max(p3.getX(), p4.getX()));
        double ymin = Math.min(Math.min(p1.getY(), p2.getY()), Math.min(p3.getY(), p4.getY()));
        double ymax = Math.max(Math.max(p1.getY(), p2.getY()), Math.max(p3.getY(), p4.getY()));
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public CubicBezierCurve2D transform(AffineTransform2D trans) {
        return new CubicBezierCurve2D((java.awt.geom.Point2D)trans.transform(this.getFirstPoint()), trans.transform(this.getControl1()), (java.awt.geom.Point2D)trans.transform(this.getControl2()), trans.transform(this.getLastPoint()));
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        Point2D p2 = this.getControl1();
        Point2D p3 = this.getControl2();
        Point2D p4 = this.getLastPoint();
        path.curveTo(p2.getX(), p2.getY(), p3.getX(), p3.getY(), p4.getX(), p4.getY());
        return path;
    }

    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        Point2D p1 = this.getFirstPoint();
        Point2D p2 = this.getControl1();
        Point2D p3 = this.getControl2();
        Point2D p4 = this.getLastPoint();
        path.moveTo(p1.getX(), p1.getY());
        path.curveTo(p2.getX(), p2.getY(), p3.getX(), p3.getY(), p4.getX(), p4.getY());
        return path;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CubicBezierCurve2D)) {
            return false;
        }
        CubicBezierCurve2D bezier = (CubicBezierCurve2D)obj;
        if (Math.abs(this.x1 - bezier.x1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.y1 - bezier.y1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrlx1 - bezier.ctrlx1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrly1 - bezier.ctrly1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrlx2 - bezier.ctrlx2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ctrly2 - bezier.ctrly2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.x2 - bezier.x2) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(this.y2 - bezier.y2) > 1.0E-12);
    }

    @Override
    public CubicBezierCurve2D clone() {
        return new CubicBezierCurve2D(this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2);
    }
}

