/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.Angle2D;
import math.geom2d.Point2D;
import math.geom2d.Shape2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.conic.CircleArc2D;
import math.geom2d.curve.PolyCurve2D;
import math.geom2d.domain.BoundaryPolyCurve2D;
import math.geom2d.domain.BoundarySet2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Polyline2D;
import math.geom2d.transform.Transform2D;

public class CircleInversion2D
implements Transform2D {
    protected Circle2D circle = new Circle2D();

    public CircleInversion2D() {
        this.circle = new Circle2D(0.0, 0.0, 1.0);
    }

    public CircleInversion2D(Circle2D circle) {
        this.circle = circle;
    }

    public Point2D getCenter() {
        return this.circle.getCenter();
    }

    public double getRadius() {
        return this.circle.getRadius();
    }

    public void setCircle(double xc, double yc, double r) {
        this.circle = new Circle2D(xc, yc, r);
    }

    public void setCircle(Circle2D circle) {
        this.circle = new Circle2D(circle.getCenter(), circle.getRadius());
    }

    public Shape2D transformShape(Shape2D shape) {
        if (shape instanceof Point2D) {
            double xc = this.circle.getCenter().getX();
            double d = this.circle.getCenter().getY();
            double r = this.circle.getRadius();
            Point2D pt = (Point2D)shape;
            double d2 = r * r / pt.getDistance(xc, d);
            double theta = Math.atan2(pt.getY() - d, pt.getX() - xc);
            return Point2D.createPolar(this.circle.getCenter(), d2, theta);
        }
        if (shape instanceof LinearShape2D) {
            Point2D center = this.circle.getCenter();
            double r = this.circle.getRadius();
            LinearShape2D line = (LinearShape2D)shape;
            Point2D po = line.getSupportingLine().getProjectedPoint(center);
            double d = center.getDistance(po);
            if (Math.abs(d) < 1.0E-12) {
                return new StraightLine2D(line);
            }
            double angle = Angle2D.getHorizontalAngle(center, po);
            double r2 = r * r / d / 2.0;
            Point2D c2 = Point2D.createPolar(center, r2, angle);
            if (line instanceof StraightLine2D) {
                return new Circle2D(c2, r2);
            }
            if (line instanceof LineSegment2D) {
                LineSegment2D segment = (LineSegment2D)line;
                Point2D p1 = segment.getFirstPoint();
                Point2D p2 = segment.getLastPoint();
                p1 = this.transformPoint(p1);
                p2 = this.transformPoint(p2);
                double theta1 = Angle2D.getHorizontalAngle(c2, p1);
                double theta2 = Angle2D.getHorizontalAngle(c2, p2);
                boolean direct = new StraightLine2D(segment).isInside(center);
                return new CircleArc2D(c2, r2, theta1, theta2, direct);
            }
        } else {
            if (shape instanceof Circle2D) {
                Point2D center = this.circle.getCenter();
                Circle2D circle = (Circle2D)shape;
                Point2D point2D = circle.getCenter();
                StraightLine2D line = new StraightLine2D((java.awt.geom.Point2D)center, (java.awt.geom.Point2D)point2D);
                Collection<Point2D> points = circle.getIntersections(line);
                Iterator<Point2D> iter = points.iterator();
                Point2D p1 = this.transformPoint(iter.next());
                Point2D p2 = this.transformPoint(iter.next());
                double d = p1.getDistance(p2);
                Point2D point2D2 = Point2D.midPoint(p1, p2);
                return new Circle2D(point2D2, d / 2.0);
            }
            if (shape instanceof Polyline2D) {
                Collection<LineSegment2D> edges = ((Polyline2D)shape).getEdges();
                ArrayList<CircleArc2D> arcs = new ArrayList<CircleArc2D>();
                for (LineSegment2D lineSegment2D : edges) {
                    arcs.add((CircleArc2D)this.transformShape(lineSegment2D));
                }
                return new PolyCurve2D(arcs);
            }
            if (shape instanceof Polygon2D) {
                Collection<? extends LinearRing2D> rings = ((Polygon2D)shape).getRings();
                ArrayList<BoundaryPolyCurve2D<CircleArc2D>> curves = new ArrayList<BoundaryPolyCurve2D<CircleArc2D>>(rings.size());
                for (LinearRing2D linearRing2D : rings) {
                    curves.add(this.transformRing(linearRing2D));
                }
                return new BoundarySet2D(curves);
            }
        }
        return null;
    }

    @Deprecated
    public Shape2D transform(Shape2D shape) {
        return this.transformShape(shape);
    }

    public Point2D transformPoint(java.awt.geom.Point2D pt) {
        Point2D center = this.circle.getCenter();
        double r = this.circle.getRadius();
        double d = r * r / Point2D.getDistance(pt, center);
        double theta = Angle2D.getHorizontalAngle(center, pt);
        return Point2D.createPolar(center, d, theta);
    }

    public BoundaryPolyCurve2D<CircleArc2D> transformRing(LinearRing2D ring) {
        Collection<LineSegment2D> edges = ring.getEdges();
        ArrayList<CircleArc2D> arcs = new ArrayList<CircleArc2D>();
        for (LineSegment2D edge : edges) {
            arcs.add((CircleArc2D)this.transformShape(edge));
        }
        return new BoundaryPolyCurve2D<CircleArc2D>(arcs);
    }

    @Override
    public Point2D transform(java.awt.geom.Point2D pt) {
        Point2D center = this.circle.getCenter();
        double r = this.circle.getRadius();
        double d = r * r / Point2D.getDistance(pt, center);
        double theta = Angle2D.getHorizontalAngle(center, pt);
        return Point2D.createPolar(center, d, theta);
    }

    @Override
    public Point2D[] transform(java.awt.geom.Point2D[] src, Point2D[] dst) {
        int i;
        if (dst == null) {
            dst = new Point2D[src.length];
        }
        if (dst[0] == null) {
            i = 0;
            while (i < dst.length) {
                dst[i] = new Point2D();
                ++i;
            }
        }
        double xc = this.circle.getCenter().getX();
        double yc = this.circle.getCenter().getY();
        double r = this.circle.getRadius();
        i = 0;
        while (i < src.length) {
            double d = java.awt.geom.Point2D.distance(src[i].getX(), src[i].getY(), xc, yc);
            d = r * r / d;
            double theta = Math.atan2(src[i].getY() - yc, src[i].getX() - xc);
            dst[i].setLocation(d * Math.cos(theta), d * Math.sin(theta));
            ++i;
        }
        return dst;
    }
}

