/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon.convhull;

import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.Angle2D;
import math.geom2d.Point2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.SimplePolygon2D;
import math.geom2d.polygon.convhull.ConvexHull2D;

public class JarvisMarch2D
implements ConvexHull2D {
    @Override
    public Polygon2D convexHull(Collection<? extends Point2D> points) {
        Point2D lowestPoint = null;
        double ymin = Double.MAX_VALUE;
        for (Point2D point2D : points) {
            double y = point2D.getY();
            if (!(y < ymin)) continue;
            ymin = y;
            lowestPoint = point2D;
        }
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        Point2D currentPoint = lowestPoint;
        Point2D nextPoint = null;
        double angle = 0.0;
        do {
            arrayList.add(currentPoint);
            nextPoint = this.findNextPoint(currentPoint, angle, points);
            angle = Angle2D.getHorizontalAngle(currentPoint, nextPoint);
        } while ((currentPoint = nextPoint) != lowestPoint);
        SimplePolygon2D convexHull = new SimplePolygon2D(arrayList);
        return convexHull;
    }

    private Point2D findNextPoint(Point2D basePoint, double startAngle, Collection<? extends Point2D> points) {
        Point2D minPoint = null;
        double minAngle = Double.MAX_VALUE;
        for (Point2D point2D : points) {
            if (basePoint.equals(point2D)) continue;
            double angle = Angle2D.getHorizontalAngle(basePoint, point2D);
            if (!((angle = Angle2D.formatAngle(angle - startAngle)) < minAngle)) continue;
            minAngle = angle;
            minPoint = point2D;
        }
        return minPoint;
    }
}

