/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearBoundary2D;
import math.geom2d.circulinear.CirculinearBoundarySet2D;
import math.geom2d.circulinear.CirculinearCurve2DUtils;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.domain.Boundary2DUtils;
import math.geom2d.domain.BoundarySet2D;
import math.geom2d.domain.ContinuousBoundary2D;
import math.geom2d.domain.Domain2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Polyline2D;
import math.geom2d.polygon.SimplePolygon2D;
import math.geom2d.transform.CircleInversion2D;

public class MultiPolygon2D
implements Domain2D,
Polygon2D {
    ArrayList<LinearRing2D> rings = new ArrayList();

    public MultiPolygon2D() {
    }

    public MultiPolygon2D(LinearRing2D ring) {
        this.rings.add(ring);
    }

    public MultiPolygon2D(LinearRing2D[] rings) {
        LinearRing2D[] linearRing2DArray = rings;
        int n = rings.length;
        int n2 = 0;
        while (n2 < n) {
            LinearRing2D ring = linearRing2DArray[n2];
            this.rings.add(ring);
            ++n2;
        }
    }

    public MultiPolygon2D(SimplePolygon2D polygon) {
        this.rings.addAll(((CurveArray2D)((Object)polygon.getBoundary())).getCurves());
    }

    public MultiPolygon2D(Collection<LinearRing2D> lines) {
        this.rings.addAll(lines);
    }

    public void addPolygon(SimplePolygon2D polygon) {
        this.rings.addAll(((CurveArray2D)((Object)polygon.getBoundary())).getCurves());
    }

    public Collection<SimplePolygon2D> getPolygons() {
        ArrayList<SimplePolygon2D> polygons = new ArrayList<SimplePolygon2D>();
        for (LinearRing2D ring : this.rings) {
            polygons.add(new SimplePolygon2D(ring.getVertices()));
        }
        return polygons;
    }

    @Deprecated
    public void addPolyline(LinearRing2D ring) {
        this.rings.add(ring);
    }

    public void addRing(LinearRing2D ring) {
        this.rings.add(ring);
    }

    public Collection<LinearRing2D> getRings() {
        return Collections.unmodifiableList(this.rings);
    }

    @Override
    public CirculinearDomain2D transform(CircleInversion2D inv) {
        return new GenericCirculinearDomain2D((CirculinearBoundary2D)((CirculinearBoundarySet2D)this.getBoundary()).transform(inv));
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        return CirculinearCurve2DUtils.computeBuffer(this.getBoundary(), dist);
    }

    @Override
    public CirculinearBoundarySet2D<LinearRing2D> getBoundary() {
        return new CirculinearBoundarySet2D<LinearRing2D>(this.rings);
    }

    @Override
    public Polygon2D complement() {
        ArrayList<LinearRing2D> reverseLines = new ArrayList<LinearRing2D>(this.rings.size());
        for (LinearRing2D ring : this.rings) {
            reverseLines.add(ring.getReverseCurve());
        }
        return new MultiPolygon2D(reverseLines);
    }

    public Collection<LineSegment2D> getEdges() {
        ArrayList<LineSegment2D> edges = new ArrayList<LineSegment2D>();
        for (LinearRing2D ring : this.rings) {
            edges.addAll(ring.getEdges());
        }
        return edges;
    }

    @Override
    public int getEdgeNumber() {
        int count = 0;
        for (LinearRing2D ring : this.rings) {
            count += ring.getVertexNumber();
        }
        return count;
    }

    @Override
    public Collection<Point2D> getVertices() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (LinearRing2D ring : this.rings) {
            points.addAll(ring.getVertices());
        }
        return points;
    }

    @Override
    public Point2D getVertex(int i) {
        int count = 0;
        Polyline2D boundary = null;
        for (LinearRing2D ring : this.rings) {
            int nv = ring.getVertexNumber();
            if (count + nv > i) {
                boundary = ring;
                break;
            }
            count += nv;
        }
        if (boundary == null) {
            throw new IndexOutOfBoundsException();
        }
        return boundary.getVertex(i - count);
    }

    @Override
    public int getVertexNumber() {
        int count = 0;
        for (LinearRing2D ring : this.rings) {
            count += ring.getVertexNumber();
        }
        return count;
    }

    @Override
    public Box2D getBoundingBox() {
        Box2D box = new Box2D(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (LinearRing2D ring : this.rings) {
            box = box.union(ring.getBoundingBox());
        }
        return box;
    }

    @Override
    public MultiPolygon2D clip(Box2D box) {
        BoundarySet2D<ContinuousBoundary2D> boundary = Boundary2DUtils.clipBoundary(this.getBoundary(), box);
        ArrayList<LinearRing2D> boundaries = new ArrayList<LinearRing2D>(boundary.getCurveNumber());
        for (ContinuousBoundary2D curve : boundary.getBoundaryCurves()) {
            boundaries.add((LinearRing2D)curve);
        }
        return new MultiPolygon2D(boundaries);
    }

    @Override
    public double getDistance(java.awt.geom.Point2D p) {
        return Math.max(((BoundarySet2D)((Object)this.getBoundary())).getSignedDistance(p), 0.0);
    }

    @Override
    public double getDistance(double x, double y) {
        return Math.max(((BoundarySet2D)((Object)this.getBoundary())).getSignedDistance(x, y), 0.0);
    }

    @Override
    public boolean isBounded() {
        CirculinearBoundary2D boundary = this.getBoundary();
        if (!boundary.isBounded()) {
            return false;
        }
        double area = 0.0;
        for (LinearRing2D ring : this.rings) {
            area += ring.getSignedArea();
        }
        return area > 0.0;
    }

    @Override
    public boolean isEmpty() {
        for (LinearRing2D ring : this.rings) {
            if (ring.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MultiPolygon2D transform(AffineTransform2D trans) {
        ArrayList<LinearRing2D> transformed = new ArrayList<LinearRing2D>(this.rings.size());
        for (LinearRing2D ring : this.rings) {
            transformed.add(ring.transform(trans));
        }
        return new MultiPolygon2D(transformed);
    }

    @Override
    public boolean contains(java.awt.geom.Point2D point) {
        double angle = 0.0;
        for (LinearRing2D ring : this.rings) {
            angle += ring.getWindingAngle(point);
        }
        return angle > Math.PI;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D(x, y));
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(((CurveArray2D)((Object)this.getBoundary())).getGeneralPath());
    }

    @Override
    public void fill(Graphics2D g) {
        g.fill(((CurveArray2D)((Object)this.getBoundary())).getGeneralPath());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MultiPolygon2D)) {
            return false;
        }
        MultiPolygon2D polygon = (MultiPolygon2D)obj;
        if (polygon.rings.size() != this.rings.size()) {
            return false;
        }
        int i = 0;
        while (i < this.rings.size()) {
            if (!this.rings.get(i).equals(polygon.rings.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public MultiPolygon2D clone() {
        ArrayList<LinearRing2D> array = new ArrayList<LinearRing2D>(this.rings.size());
        for (LinearRing2D ring : this.rings) {
            array.add(ring.clone());
        }
        return new MultiPolygon2D(array);
    }
}

