/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.domain;

import java.awt.Graphics2D;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.domain.ContinuousBoundary2D;
import math.geom2d.domain.ContinuousOrientedCurve2D;
import math.geom2d.domain.Domain2D;
import math.geom2d.domain.GenericDomain2D;
import math.geom2d.domain.PolyOrientedCurve2D;

public class BoundaryPolyCurve2D<T extends ContinuousOrientedCurve2D>
extends PolyOrientedCurve2D<T>
implements ContinuousBoundary2D {
    public BoundaryPolyCurve2D() {
    }

    public BoundaryPolyCurve2D(int n) {
        super(n);
    }

    public BoundaryPolyCurve2D(T[] curves) {
        super(curves);
    }

    public BoundaryPolyCurve2D(Collection<? extends T> curves) {
        super(curves);
    }

    public static <T extends ContinuousOrientedCurve2D> BoundaryPolyCurve2D<T> create(Collection<T> curves) {
        return new BoundaryPolyCurve2D<T>(curves);
    }

    public static <T extends ContinuousOrientedCurve2D> BoundaryPolyCurve2D<T> create(T[] curves) {
        return new BoundaryPolyCurve2D(curves);
    }

    @Override
    public boolean isClosed() {
        for (ContinuousOrientedCurve2D curve : this.curves) {
            if (curve.isBounded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<? extends ContinuousBoundary2D> getBoundaryCurves() {
        return BoundaryPolyCurve2D.wrapCurve(this);
    }

    @Override
    public Domain2D getDomain() {
        return new GenericDomain2D(this);
    }

    @Override
    public void fill(Graphics2D g2) {
        g2.fill(this.getGeneralPath());
    }

    @Override
    public BoundaryPolyCurve2D<? extends ContinuousOrientedCurve2D> getReverseCurve() {
        ContinuousOrientedCurve2D[] curves2 = new ContinuousOrientedCurve2D[this.curves.size()];
        int n = this.curves.size();
        int i = 0;
        while (i < n) {
            curves2[i] = (ContinuousOrientedCurve2D)((ContinuousOrientedCurve2D)this.curves.get(n - 1 - i)).getReverseCurve();
            ++i;
        }
        return new BoundaryPolyCurve2D(curves2);
    }

    @Override
    public BoundaryPolyCurve2D<ContinuousOrientedCurve2D> transform(AffineTransform2D trans) {
        BoundaryPolyCurve2D<ContinuousOrientedCurve2D> result = new BoundaryPolyCurve2D<ContinuousOrientedCurve2D>();
        for (ContinuousOrientedCurve2D curve : this.curves) {
            result.addCurve((ContinuousOrientedCurve2D)curve.transform(trans));
        }
        return result;
    }
}

