/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.curve;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.line.LinearShape2D;

public class CurveArray2D<T extends Curve2D>
extends CurveSet2D<T>
implements Iterable<T>,
Cloneable {
    public CurveArray2D() {
        this.curves = new ArrayList();
    }

    public CurveArray2D(int n) {
        this();
        this.curves = new ArrayList(n);
    }

    public CurveArray2D(T[] curves) {
        this();
        this.curves = new ArrayList(curves.length);
        T[] TArray = curves;
        int n = curves.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            this.addCurve(element);
            ++n2;
        }
    }

    public CurveArray2D(Collection<? extends T> curves) {
        this();
        this.curves = new ArrayList(curves.size());
        this.curves.addAll(curves);
    }

    public static <T extends Curve2D> CurveArray2D<T> create(Collection<T> curves) {
        return new CurveArray2D<T>(curves);
    }

    public static <T extends Curve2D> CurveArray2D<T> create(T[] curves) {
        return new CurveArray2D(curves);
    }

    @Override
    public double getLocalPosition(double t) {
        int i = this.getCurveIndex(t);
        Curve2D curve = (Curve2D)this.curves.get(i);
        double t0 = curve.getT0();
        double t1 = curve.getT1();
        return Curve2DUtils.fromUnitSegment(t - (double)(2 * i), t0, t1);
    }

    @Override
    public double getGlobalPosition(int i, double t) {
        Curve2D curve = (Curve2D)this.curves.get(i);
        double t0 = curve.getT0();
        double t1 = curve.getT1();
        return Curve2DUtils.toUnitSegment(t, t0, t1) + (double)(i * 2);
    }

    @Override
    public int getCurveIndex(double t) {
        if (this.curves.size() == 0) {
            return 0;
        }
        if (t > (double)(this.curves.size() * 2 - 1)) {
            return this.curves.size() - 1;
        }
        int nc = (int)Math.floor(t);
        int indc = (int)Math.floor(nc / 2);
        if (indc * 2 == nc) {
            return indc;
        }
        return t - (double)nc < 0.5 ? indc : indc + 1;
    }

    @Override
    public void addCurve(T curve) {
        if (!this.curves.contains(curve)) {
            this.curves.add(curve);
        }
    }

    @Override
    public void removeCurve(T curve) {
        this.curves.remove(curve);
    }

    @Override
    public boolean containsCurve(Curve2D curve) {
        return this.curves.contains(curve);
    }

    @Override
    public void clearCurves() {
        this.curves.clear();
    }

    @Override
    public Collection<T> getCurves() {
        return this.curves;
    }

    @Override
    public T getCurve(int index) {
        return (T)((Curve2D)this.curves.get(index));
    }

    @Override
    public T getChildCurve(double t) {
        if (this.curves.size() == 0) {
            return null;
        }
        return (T)((Curve2D)this.curves.get(this.getCurveIndex(t)));
    }

    @Override
    public T getFirstCurve() {
        if (this.curves.size() == 0) {
            return null;
        }
        return (T)((Curve2D)this.curves.get(0));
    }

    @Override
    public T getLastCurve() {
        if (this.curves.size() == 0) {
            return null;
        }
        return (T)((Curve2D)this.curves.get(this.curves.size() - 1));
    }

    @Override
    public int getCurveNumber() {
        return this.curves.size();
    }

    @Override
    public boolean isEmpty() {
        return this.curves.size() == 0;
    }

    @Override
    public Collection<Point2D> getIntersections(LinearShape2D line) {
        ArrayList<Point2D> intersect = new ArrayList<Point2D>();
        for (Curve2D curve : this.curves) {
            intersect.addAll(curve.getIntersections(line));
        }
        return intersect;
    }

    @Override
    public double getT0() {
        return 0.0;
    }

    @Override
    public double getT1() {
        return Math.max(this.curves.size() * 2 - 1, 0);
    }

    @Override
    public Point2D getPoint(double t) {
        if (this.curves.size() == 0) {
            return null;
        }
        if (t < this.getT0()) {
            return this.getFirstCurve().getFirstPoint();
        }
        if (t > this.getT1()) {
            return this.getLastCurve().getLastPoint();
        }
        int nc = (int)Math.floor(t);
        int indc = (int)Math.floor(nc / 2);
        if (indc * 2 == nc) {
            Curve2D curve = (Curve2D)this.curves.get(indc);
            double pos = Curve2DUtils.fromUnitSegment(t - (double)nc, curve.getT0(), curve.getT1());
            return curve.getPoint(pos);
        }
        if (t - (double)nc < 0.5) {
            return ((Curve2D)this.curves.get(indc)).getLastPoint();
        }
        return ((Curve2D)this.curves.get(indc + 1)).getFirstPoint();
    }

    @Override
    public Point2D getFirstPoint() {
        if (this.curves.size() == 0) {
            return null;
        }
        return this.getFirstCurve().getFirstPoint();
    }

    @Override
    public Point2D getLastPoint() {
        if (this.curves.size() == 0) {
            return null;
        }
        return this.getLastCurve().getLastPoint();
    }

    @Override
    public Collection<Point2D> getSingularPoints() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (Curve2D curve : this.curves) {
            Point2D point2;
            for (Point2D point2 : curve.getSingularPoints()) {
                if (points.contains(point2)) continue;
                points.add(point2);
            }
            if (!Curve2DUtils.isLeftInfinite(curve) && !points.contains(point2 = curve.getFirstPoint())) {
                points.add(point2);
            }
            if (Curve2DUtils.isRightInfinite(curve) || points.contains(point2 = curve.getLastPoint())) continue;
            points.add(point2);
        }
        return points;
    }

    @Override
    public boolean isSingular(double pos) {
        if (Math.abs(pos - (double)Math.round(pos)) < 1.0E-12) {
            return true;
        }
        int nc = this.getCurveIndex(pos);
        if ((double)nc - Math.floor(pos / 2.0) > 0.0) {
            return true;
        }
        Curve2D curve = (Curve2D)this.curves.get(nc);
        return curve.isSingular(this.getLocalPosition(pos));
    }

    @Override
    public double getPosition(java.awt.geom.Point2D point) {
        double minDist;
        double dist = minDist = Double.MAX_VALUE;
        double x = point.getX();
        double y = point.getY();
        double pos = 0.0;
        int i = 0;
        for (Curve2D curve : this.curves) {
            dist = curve.getDistance(x, y);
            if (dist < minDist) {
                minDist = dist;
                pos = curve.getPosition(point);
                double t0 = curve.getT0();
                double t1 = curve.getT1();
                pos = Curve2DUtils.toUnitSegment(pos, t0, t1) + (double)(i * 2);
            }
            ++i;
        }
        return pos;
    }

    @Override
    public double project(java.awt.geom.Point2D point) {
        double minDist;
        double dist = minDist = Double.MAX_VALUE;
        double x = point.getX();
        double y = point.getY();
        double pos = 0.0;
        int i = 0;
        for (Curve2D curve : this.curves) {
            dist = curve.getDistance(x, y);
            if (dist < minDist) {
                minDist = dist;
                pos = curve.project(point);
                double t0 = curve.getT0();
                double t1 = curve.getT1();
                pos = Curve2DUtils.toUnitSegment(pos, t0, t1) + (double)(i * 2);
            }
            ++i;
        }
        return pos;
    }

    @Override
    public Curve2D getReverseCurve() {
        int n = this.curves.size();
        Curve2D[] curves2 = new Curve2D[n];
        int i = 0;
        while (i < n) {
            curves2[i] = ((Curve2D)this.curves.get(n - 1 - i)).getReverseCurve();
            ++i;
        }
        return new CurveArray2D(curves2);
    }

    @Override
    public CurveSet2D<? extends Curve2D> getSubCurve(double t0, double t1) {
        int nc = this.curves.size();
        CurveArray2D<Curve2D> res = new CurveArray2D<Curve2D>();
        t0 = Math.min(Math.max(t0, 0.0), (double)(nc * 2) - 0.6);
        t1 = Math.min(Math.max(t1, 0.0), (double)(nc * 2) - 0.6);
        double t0f = Math.floor(t0);
        double t1f = Math.floor(t1);
        int ind0 = (int)Math.floor(t0f / 2.0);
        int ind1 = (int)Math.floor(t1f / 2.0);
        if (t0 - (double)(2 * ind0) > 1.5) {
            ++ind0;
        }
        if (t1 - (double)(2 * ind1) > 1.5) {
            ++ind1;
        }
        t0f = 2 * ind0;
        t1f = 2 * ind1;
        if (ind0 == ind1 && t0 < t1) {
            Curve2D curve = (Curve2D)this.curves.get(ind0);
            double pos0 = Curve2DUtils.fromUnitSegment(t0 - t0f, curve.getT0(), curve.getT1());
            double pos1 = Curve2DUtils.fromUnitSegment(t1 - t1f, curve.getT0(), curve.getT1());
            res.addCurve(curve.getSubCurve(pos0, pos1));
            return res;
        }
        Curve2D curve = (Curve2D)this.curves.get(ind0);
        double pos0 = Curve2DUtils.fromUnitSegment(t0 - t0f, curve.getT0(), curve.getT1());
        res.addCurve(curve.getSubCurve(pos0, curve.getT1()));
        if (ind1 > ind0) {
            int n = ind0 + 1;
            while (n < ind1) {
                res.addCurve((Curve2D)this.curves.get(n));
                ++n;
            }
        } else {
            int n = ind0 + 1;
            while (n < nc) {
                res.addCurve((Curve2D)this.curves.get(n));
                ++n;
            }
            n = 0;
            while (n < ind1) {
                res.addCurve((Curve2D)this.curves.get(n));
                ++n;
            }
        }
        curve = (Curve2D)this.curves.get(ind1);
        double pos1 = Curve2DUtils.fromUnitSegment(t1 - t1f, curve.getT0(), curve.getT1());
        res.addCurve(curve.getSubCurve(curve.getT0(), pos1));
        return res;
    }

    @Override
    public double getDistance(java.awt.geom.Point2D p) {
        return this.getDistance(p.getX(), p.getY());
    }

    @Override
    public double getDistance(double x, double y) {
        double dist = Double.POSITIVE_INFINITY;
        for (Curve2D curve : this.curves) {
            dist = Math.min(dist, curve.getDistance(x, y));
        }
        return dist;
    }

    @Override
    public boolean isBounded() {
        for (Curve2D curve : this.curves) {
            if (curve.isBounded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public CurveSet2D<? extends Curve2D> clip(Box2D box) {
        return Curve2DUtils.clipCurveSet(this, box);
    }

    @Override
    public Box2D getBoundingBox() {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        for (Curve2D curve : this.curves) {
            Box2D box = curve.getBoundingBox();
            xmin = Math.min(xmin, box.getMinX());
            ymin = Math.min(ymin, box.getMinY());
            xmax = Math.max(xmax, box.getMaxX());
            ymax = Math.max(ymax, box.getMaxY());
        }
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public CurveArray2D<? extends Curve2D> transform(AffineTransform2D trans) {
        CurveArray2D<Curve2D> result = new CurveArray2D<Curve2D>(this.curves.size());
        for (Curve2D curve : this.curves) {
            result.addCurve(curve.transform(trans));
        }
        return result;
    }

    @Override
    public Collection<? extends ContinuousCurve2D> getContinuousCurves() {
        ArrayList<? extends ContinuousCurve2D> continuousCurves = new ArrayList<ContinuousCurve2D>();
        for (Curve2D curve : this.curves) {
            if (curve instanceof ContinuousCurve2D) {
                continuousCurves.add((ContinuousCurve2D)curve);
                continue;
            }
            continuousCurves.addAll(curve.getContinuousCurves());
        }
        return continuousCurves;
    }

    @Override
    public boolean contains(java.awt.geom.Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(double x, double y) {
        for (Curve2D curve : this.curves) {
            if (!curve.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        if (this.curves.size() == 0) {
            return path;
        }
        for (ContinuousCurve2D curve : this.getContinuousCurves()) {
            Point2D point = curve.getFirstPoint();
            path.moveTo((float)point.getX(), (float)point.getY());
            path = curve.appendPath(path);
        }
        return path;
    }

    @Override
    public Shape getAsAWTShape() {
        return this.getGeneralPath();
    }

    @Override
    public void draw(Graphics2D g2) {
        for (Curve2D curve : this.curves) {
            curve.draw(g2);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CurveArray2D)) {
            return false;
        }
        CurveArray2D curveSet = (CurveArray2D)obj;
        if (this.getCurveNumber() != curveSet.getCurveNumber()) {
            return false;
        }
        int i = 0;
        while (i < this.curves.size()) {
            if (!((Curve2D)this.curves.get(i)).equals(curveSet.curves.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public CurveArray2D<? extends Curve2D> clone() {
        ArrayList<Curve2D> array = new ArrayList<Curve2D>(this.curves.size());
        for (Curve2D curve : this.curves) {
            array.add(curve);
        }
        return new CurveArray2D(array);
    }

    @Override
    public Iterator<T> iterator() {
        return this.curves.iterator();
    }
}

