/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear;

import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.Box2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearCurve2D;
import math.geom2d.circulinear.CirculinearCurve2DUtils;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.transform.CircleInversion2D;

public class CirculinearCurveSet2D<T extends CirculinearCurve2D>
extends CurveArray2D<T>
implements CirculinearCurve2D {
    public CirculinearCurveSet2D() {
        this.curves = new ArrayList();
    }

    public CirculinearCurveSet2D(int n) {
        this.curves = new ArrayList(n);
    }

    public CirculinearCurveSet2D(T[] curves) {
        this.curves = new ArrayList(curves.length);
        T[] TArray = curves;
        int n = curves.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            this.addCurve(element);
            ++n2;
        }
    }

    public CirculinearCurveSet2D(Collection<? extends T> curves) {
        this.curves = new ArrayList(curves.size());
        this.curves.addAll(curves);
    }

    public static <T extends CirculinearCurve2D> CirculinearCurveSet2D<T> create(Collection<T> curves) {
        return new CirculinearCurveSet2D<T>(curves);
    }

    public static <T extends CirculinearCurve2D> CirculinearCurveSet2D<T> create(T[] curves) {
        return new CirculinearCurveSet2D(curves);
    }

    @Override
    public double getLength() {
        double sum = 0.0;
        for (CirculinearCurve2D curve : this.getCurves()) {
            sum += curve.getLength();
        }
        return sum;
    }

    @Override
    public double getLength(double pos) {
        return CirculinearCurve2DUtils.getLength(this, pos);
    }

    @Override
    public double getPosition(double length) {
        return CirculinearCurve2DUtils.getPosition(this, length);
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        return CirculinearCurve2DUtils.computeBuffer(this, dist);
    }

    @Override
    public CirculinearCurve2D getParallel(double d) {
        return CirculinearCurve2DUtils.createParallel(this, d);
    }

    @Override
    public CirculinearCurveSet2D<CirculinearCurve2D> transform(CircleInversion2D inv) {
        CirculinearCurveSet2D<CirculinearCurve2D> result = new CirculinearCurveSet2D<CirculinearCurve2D>(this.curves.size());
        for (CirculinearCurve2D curve : this.curves) {
            result.addCurve((CirculinearCurve2D)curve.transform(inv));
        }
        return result;
    }

    @Override
    public Collection<? extends CirculinearContinuousCurve2D> getContinuousCurves() {
        ArrayList<? extends CirculinearContinuousCurve2D> result = new ArrayList<CirculinearContinuousCurve2D>();
        for (CirculinearCurve2D curve : this.curves) {
            result.addAll(curve.getContinuousCurves());
        }
        return result;
    }

    @Override
    public CirculinearCurveSet2D<? extends CirculinearCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curve2DUtils.clipCurve(this, box);
        int n = set.getCurveNumber();
        CirculinearCurveSet2D<CirculinearCurve2D> result = new CirculinearCurveSet2D<CirculinearCurve2D>(n);
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof CirculinearCurve2D)) continue;
            result.addCurve((CirculinearCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public CirculinearCurveSet2D<? extends CirculinearCurve2D> getSubCurve(double t0, double t1) {
        CurveSet2D<Curve2D> subcurve = super.getSubCurve(t0, t1);
        CirculinearCurveSet2D<CirculinearCurve2D> result = new CirculinearCurveSet2D<CirculinearCurve2D>(subcurve.getCurveNumber());
        for (Curve2D curve : subcurve) {
            if (curve instanceof CirculinearCurve2D) {
                result.addCurve((CirculinearCurve2D)curve);
                continue;
            }
            System.err.println("CirculinearCurveSet2D.getSubCurve: error in class cast");
        }
        return result;
    }

    @Override
    public CirculinearCurveSet2D<? extends CirculinearCurve2D> getReverseCurve() {
        int n = this.curves.size();
        CirculinearCurve2D[] curves2 = new CirculinearCurve2D[n];
        int i = 0;
        while (i < n) {
            curves2[i] = (CirculinearCurve2D)((CirculinearCurve2D)this.curves.get(n - 1 - i)).getReverseCurve();
            ++i;
        }
        return new CirculinearCurveSet2D(curves2);
    }
}

