/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import math.geom2d.Angle2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.BoundaryPolyCirculinearCurve2D;
import math.geom2d.circulinear.CirculinearBoundarySet2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearContour2D;
import math.geom2d.circulinear.CirculinearCurve2D;
import math.geom2d.circulinear.CirculinearCurveSet2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.circulinear.GenericCirculinearRing2D;
import math.geom2d.circulinear.NonCirculinearClassException;
import math.geom2d.circulinear.PolyCirculinearCurve2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.conic.CircleArc2D;
import math.geom2d.conic.CircularShape2D;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.point.PointSet2D;

public class CirculinearCurve2DUtils {
    public static CirculinearCurve2D convert(Curve2D curve) {
        if (curve instanceof CirculinearCurve2D) {
            return (CirculinearCurve2D)curve;
        }
        if (curve instanceof ContinuousCurve2D) {
            ContinuousCurve2D continuous = (ContinuousCurve2D)curve;
            Collection<? extends SmoothCurve2D> smoothPieces = continuous.getSmoothPieces();
            ArrayList<CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>(smoothPieces.size());
            for (SmoothCurve2D smoothCurve2D : smoothPieces) {
                if (smoothCurve2D instanceof CirculinearElement2D) {
                    elements.add((CirculinearElement2D)smoothCurve2D);
                    continue;
                }
                throw new NonCirculinearClassException(smoothCurve2D);
            }
            return new PolyCirculinearCurve2D(elements);
        }
        if (curve instanceof CurveSet2D) {
            CurveSet2D set = (CurveSet2D)curve;
            Collection<ContinuousCurve2D> continuousCurves = set.getContinuousCurves();
            ArrayList<CirculinearContinuousCurve2D> curves = new ArrayList<CirculinearContinuousCurve2D>(continuousCurves.size());
            for (ContinuousCurve2D continuousCurve2D : continuousCurves) {
                if (continuousCurve2D instanceof CirculinearContinuousCurve2D) {
                    curves.add((CirculinearContinuousCurve2D)continuousCurve2D);
                    continue;
                }
                curves.add((CirculinearContinuousCurve2D)CirculinearCurve2DUtils.convert(continuousCurve2D));
            }
            return new CirculinearCurveSet2D(curves);
        }
        return null;
    }

    public static double getLength(CurveSet2D<? extends CirculinearCurve2D> curve, double pos) {
        double length = 0.0;
        int index = curve.getCurveIndex(pos);
        int i = 0;
        while (i < index) {
            length += curve.getCurve(i).getLength();
            ++i;
        }
        if (index < curve.getCurveNumber()) {
            double pos2 = curve.getLocalPosition(pos - (double)(2 * index));
            length += curve.getCurve(index).getLength(pos2);
        }
        return length;
    }

    public static double getPosition(CurveSet2D<? extends CirculinearCurve2D> curveSet, double length) {
        double pos = 0.0;
        int index = 0;
        double cumLength = CirculinearCurve2DUtils.getLength(curveSet, curveSet.getT0());
        for (CirculinearCurve2D circulinearCurve2D : curveSet.getCurves()) {
            double curveLength = circulinearCurve2D.getLength();
            if (cumLength + curveLength < length) {
                cumLength += curveLength;
                ++index;
                continue;
            }
            double pos2 = circulinearCurve2D.getPosition(length - cumLength);
            pos = curveSet.getGlobalPosition(index, pos2);
            break;
        }
        return pos;
    }

    public static CirculinearCurve2D createParallel(CirculinearCurve2D curve, double dist) {
        if (curve instanceof CirculinearContinuousCurve2D) {
            return CirculinearCurve2DUtils.createContinuousParallel((CirculinearContinuousCurve2D)curve, dist);
        }
        CirculinearCurveSet2D<CirculinearContinuousCurve2D> parallel = new CirculinearCurveSet2D<CirculinearContinuousCurve2D>();
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve.getContinuousCurves()) {
            CirculinearContinuousCurve2D contParallel = CirculinearCurve2DUtils.createContinuousParallel(circulinearContinuousCurve2D, dist);
            if (contParallel == null) continue;
            parallel.addCurve(contParallel);
        }
        return parallel;
    }

    public static CirculinearContinuousCurve2D createContinuousParallel(CirculinearContinuousCurve2D curve, double dist) {
        if (curve instanceof CirculinearElement2D) {
            return (CirculinearElement2D)((CirculinearElement2D)curve).getParallel(dist);
        }
        Collection<? extends CirculinearElement2D> elements = curve.getSmoothPieces();
        Iterator<? extends CirculinearElement2D> iterator = elements.iterator();
        CirculinearElement2D previous = null;
        CirculinearElement2D current = null;
        PolyCirculinearCurve2D<CirculinearContinuousCurve2D> parallel = new PolyCirculinearCurve2D<CirculinearContinuousCurve2D>();
        if (!iterator.hasNext()) {
            return parallel;
        }
        previous = iterator.next();
        CirculinearElement2D elementParallel = (CirculinearElement2D)previous.getParallel(dist);
        parallel.addCurve(elementParallel);
        while (iterator.hasNext()) {
            current = iterator.next();
            CirculinearCurve2DUtils.addCircularJunction(parallel, previous, current, dist);
            parallel.addCurve((CirculinearElement2D)current.getParallel(dist));
            previous = current;
        }
        if (curve.isClosed()) {
            current = elements.iterator().next();
            CirculinearCurve2DUtils.addCircularJunction(parallel, previous, current, dist);
            parallel.setClosed(true);
        }
        return parallel;
    }

    private static void addCircularJunction(PolyCirculinearCurve2D<CirculinearContinuousCurve2D> parallel, CirculinearElement2D previous, CirculinearElement2D current, double dist) {
        double endAngle;
        double startAngle;
        Point2D center = current.getFirstPoint();
        Vector2D vp = previous.getTangent(previous.getT1());
        Vector2D vc = current.getTangent(current.getT0());
        if (dist > 0.0) {
            startAngle = vp.getAngle() - 1.5707963267948966;
            endAngle = vc.getAngle() - 1.5707963267948966;
        } else {
            startAngle = vp.getAngle() + 1.5707963267948966;
            endAngle = vc.getAngle() + 1.5707963267948966;
        }
        startAngle = Angle2D.formatAngle(startAngle);
        endAngle = Angle2D.formatAngle(endAngle);
        double diffAngle = endAngle - startAngle;
        diffAngle = Math.min(diffAngle, Math.PI * 2 - diffAngle);
        if (Math.abs(diffAngle) < 1.0E-10) {
            return;
        }
        parallel.addCurve(new CircleArc2D(center, Math.abs(dist), startAngle, endAngle, dist > 0.0));
    }

    public static Collection<Point2D> findSelfIntersections(CirculinearCurve2D curve) {
        ArrayList<? extends CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>();
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve.getContinuousCurves()) {
            elements.addAll(circulinearContinuousCurve2D.getSmoothPieces());
        }
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>(0);
        int n = elements.size();
        int i = 0;
        while (i < n - 1) {
            CirculinearElement2D elem1 = (CirculinearElement2D)elements.get(i);
            int j = i;
            while (j < n) {
                CirculinearElement2D elem2 = (CirculinearElement2D)elements.get(j);
                for (Point2D inter : CirculinearCurve2DUtils.findIntersections(elem1, elem2)) {
                    if (inter.equals(elem1.getLastPoint()) && inter.equals(elem2.getFirstPoint()) || inter.equals(elem1.getFirstPoint()) && inter.equals(elem2.getLastPoint())) continue;
                    arrayList.add(inter);
                }
                ++j;
            }
            ++i;
        }
        return arrayList;
    }

    public static double[][] locateSelfIntersections(CurveSet2D<? extends CirculinearElement2D> curve) {
        ArrayList<Double> list1 = new ArrayList<Double>(0);
        ArrayList<Double> list2 = new ArrayList<Double>(0);
        int n = curve.getCurveNumber();
        int i = 0;
        while (i < n - 1) {
            CirculinearElement2D elem1 = curve.getCurve(i);
            int j = i + 1;
            while (j < n) {
                CirculinearElement2D elem2 = curve.getCurve(j);
                for (Point2D inter : CirculinearCurve2DUtils.findIntersections(elem1, elem2)) {
                    if (!Double.isInfinite(elem1.getT1()) && !Double.isInfinite(elem2.getT0()) && inter.equals(elem1.getLastPoint()) && inter.equals(elem2.getFirstPoint()) || !Double.isInfinite(elem1.getT0()) && !Double.isInfinite(elem2.getT1()) && inter.equals(elem1.getFirstPoint()) && inter.equals(elem2.getLastPoint())) continue;
                    list1.add((double)(2 * i) + Curve2DUtils.toUnitSegment(elem1.getPosition(inter), elem1.getT0(), elem1.getT1()));
                    list2.add((double)(2 * j) + Curve2DUtils.toUnitSegment(elem2.getPosition(inter), elem2.getT0(), elem2.getT1()));
                }
                ++j;
            }
            ++i;
        }
        int np = list1.size();
        double[][] result = new double[np][2];
        int i2 = 0;
        while (i2 < np) {
            result[i2][0] = (Double)list1.get(i2);
            result[i2][1] = (Double)list2.get(i2);
            ++i2;
        }
        return result;
    }

    public static Collection<Point2D> findIntersections(CirculinearCurve2D curve1, CirculinearCurve2D curve2) {
        ArrayList<? extends CirculinearElement2D> elements1 = new ArrayList<CirculinearElement2D>();
        ArrayList<? extends CirculinearElement2D> elements2 = new ArrayList<CirculinearElement2D>();
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve1.getContinuousCurves()) {
            elements1.addAll(circulinearContinuousCurve2D.getSmoothPieces());
        }
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve2.getContinuousCurves()) {
            elements2.addAll(circulinearContinuousCurve2D.getSmoothPieces());
        }
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>(0);
        int n1 = elements1.size();
        int n2 = elements2.size();
        int i = 0;
        while (i < n1) {
            CirculinearElement2D elem1 = (CirculinearElement2D)elements1.get(i);
            int j = 0;
            while (j < n2) {
                CirculinearElement2D elem2 = (CirculinearElement2D)elements2.get(j);
                for (Point2D inter : CirculinearCurve2DUtils.findIntersections(elem1, elem2)) {
                    arrayList.add(inter);
                }
                ++j;
            }
            ++i;
        }
        return arrayList;
    }

    public static double[][] locateIntersections(CirculinearCurve2D curve1, CirculinearCurve2D curve2) {
        ArrayList<Double> list1 = new ArrayList<Double>(0);
        ArrayList<Double> list2 = new ArrayList<Double>(0);
        ArrayList<? extends CirculinearElement2D> elements1 = new ArrayList<CirculinearElement2D>();
        ArrayList<? extends CirculinearElement2D> elements2 = new ArrayList<CirculinearElement2D>();
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve1.getContinuousCurves()) {
            elements1.addAll(circulinearContinuousCurve2D.getSmoothPieces());
        }
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve2.getContinuousCurves()) {
            elements2.addAll(circulinearContinuousCurve2D.getSmoothPieces());
        }
        int n = elements1.size();
        int n2 = elements2.size();
        int i = 0;
        while (i < n) {
            CirculinearElement2D elem1 = (CirculinearElement2D)elements1.get(i);
            int j = 0;
            while (j < n2) {
                CirculinearElement2D elem2 = (CirculinearElement2D)elements2.get(j);
                for (Point2D inter : CirculinearCurve2DUtils.findIntersections(elem1, elem2)) {
                    list1.add(curve1.getPosition(inter));
                    list2.add(curve2.getPosition(inter));
                }
                ++j;
            }
            ++i;
        }
        int np = list1.size();
        double[][] result = new double[np][2];
        int i2 = 0;
        while (i2 < np) {
            result[i2][0] = (Double)list1.get(i2);
            result[i2][1] = (Double)list2.get(i2);
            ++i2;
        }
        return result;
    }

    public static Collection<Point2D> findIntersections(CirculinearElement2D elem1, CirculinearElement2D elem2) {
        if (elem1 instanceof LinearShape2D) {
            return elem2.getIntersections((LinearShape2D)((Object)elem1));
        }
        if (elem2 instanceof LinearShape2D) {
            return elem1.getIntersections((LinearShape2D)((Object)elem2));
        }
        Circle2D circ1 = ((CircularShape2D)elem1).getSupportingCircle();
        Circle2D circ2 = ((CircularShape2D)elem2).getSupportingCircle();
        ArrayList<Point2D> pts = new ArrayList<Point2D>(2);
        for (Point2D inter : Circle2D.getIntersections(circ1, circ2)) {
            if (!elem1.contains(inter) || !elem2.contains(inter)) continue;
            pts.add(inter);
        }
        return pts;
    }

    public static Collection<CirculinearContinuousCurve2D> splitContinuousCurve(CirculinearContinuousCurve2D curve) {
        double pos2;
        double pos1;
        ArrayList<CirculinearContinuousCurve2D> result = new ArrayList<CirculinearContinuousCurve2D>();
        if (curve instanceof CirculinearElement2D) {
            result.add(curve);
            return result;
        }
        PolyCirculinearCurve2D<CirculinearElement2D> polyCurve = CirculinearCurve2DUtils.createPolyCurve(curve.getSmoothPieces(), curve.isClosed());
        double[][] couples = CirculinearCurve2DUtils.locateSelfIntersections(polyCurve);
        if (couples.length == 0) {
            result.add(CirculinearCurve2DUtils.createPolyCurve(polyCurve.getSmoothPieces(), curve.isClosed()));
            return result;
        }
        TreeMap<Double, Double> twins = new TreeMap<Double, Double>();
        int i = 0;
        while (i < couples.length) {
            pos1 = couples[i][0];
            pos2 = couples[i][1];
            twins.put(pos1, pos2);
            twins.put(pos2, pos1);
            ++i;
        }
        ArrayList<CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>();
        pos1 = polyCurve.getT0();
        double pos0 = pos2 = ((Double)twins.firstKey()).doubleValue();
        CirculinearCurve2DUtils.addElements(elements, (CirculinearContinuousCurve2D)polyCurve.getSubCurve(pos1, pos2));
        while (twins.higherKey(pos1 = ((Double)twins.remove(pos2)).doubleValue()) != null) {
            pos2 = twins.higherKey(pos1);
            CirculinearCurve2DUtils.addElements(elements, (CirculinearContinuousCurve2D)polyCurve.getSubCurve(pos1, pos2));
        }
        pos2 = polyCurve.getT1();
        CirculinearCurve2DUtils.addElements(elements, (CirculinearContinuousCurve2D)polyCurve.getSubCurve(pos1, pos2));
        result.add(CirculinearCurve2DUtils.createPolyCurve(elements, curve.isClosed()));
        while (!twins.isEmpty()) {
            elements = new ArrayList();
            pos0 = (Double)twins.firstKey();
            pos1 = (Double)twins.get(pos0);
            pos2 = twins.higherKey(pos1);
            CirculinearCurve2DUtils.addElements(elements, (CirculinearContinuousCurve2D)polyCurve.getSubCurve(pos1, pos2));
            while (pos2 != pos0) {
                pos1 = (Double)twins.remove(pos2);
                if (twins.higherKey(pos1) == null) break;
                pos2 = twins.higherKey(pos1);
                CirculinearCurve2DUtils.addElements(elements, (CirculinearContinuousCurve2D)polyCurve.getSubCurve(pos1, pos2));
            }
            pos1 = (Double)twins.remove(pos2);
            result.add(CirculinearCurve2DUtils.createPolyCurve(elements, true));
        }
        return result;
    }

    private static PolyCirculinearCurve2D<CirculinearElement2D> createPolyCurve(Collection<? extends CirculinearElement2D> elements, boolean closed) {
        return new PolyCirculinearCurve2D<CirculinearElement2D>(elements, closed);
    }

    public static Collection<CirculinearContour2D> splitIntersectingContours(CirculinearContour2D curve1, CirculinearContour2D curve2) {
        double pos2;
        double pos1;
        ArrayList<CirculinearContour2D> contours = new ArrayList<CirculinearContour2D>();
        double[][] couples = CirculinearCurve2DUtils.locateIntersections(curve1, curve2);
        if (couples.length == 0) {
            contours.add(curve1);
            contours.add(curve2);
            return contours;
        }
        TreeMap<Double, Double> twins1 = new TreeMap<Double, Double>();
        TreeMap<Double, Double> twins2 = new TreeMap<Double, Double>();
        TreeSet<Double> positions1 = new TreeSet<Double>();
        TreeSet<Double> positions2 = new TreeSet<Double>();
        int i = 0;
        while (i < couples.length) {
            pos1 = couples[i][0];
            pos2 = couples[i][1];
            twins1.put(pos1, pos2);
            twins2.put(pos2, pos1);
            positions1.add(pos1);
            positions2.add(pos2);
            ++i;
        }
        while (!twins1.isEmpty()) {
            double pos0;
            ArrayList<CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>();
            pos1 = pos0 = ((Double)twins2.firstEntry().getValue()).doubleValue();
            do {
                pos2 = CirculinearCurve2DUtils.nextValue(positions1, pos1);
                CirculinearCurve2DUtils.addElements(elements, (CirculinearContinuousCurve2D)curve1.getSubCurve(pos1, pos2));
                pos1 = (Double)twins1.remove(pos2);
                pos2 = CirculinearCurve2DUtils.nextValue(positions2, pos1);
                CirculinearCurve2DUtils.addElements(elements, (CirculinearContinuousCurve2D)curve2.getSubCurve(pos1, pos2));
            } while ((pos1 = ((Double)twins2.remove(pos2)).doubleValue()) != pos0);
            contours.add(new BoundaryPolyCirculinearCurve2D<CirculinearElement2D>(elements, true));
        }
        return contours;
    }

    public static Collection<CirculinearContour2D> splitIntersectingContours(Collection<? extends CirculinearContour2D> curves) {
        int ind0;
        double pos2;
        double pos1;
        double pos0 = 0.0;
        CirculinearContour2D[] curveArray = curves.toArray(new CirculinearContour2D[0]);
        int nCurves = curves.size();
        ArrayList twinIndices = new ArrayList(nCurves);
        ArrayList<TreeMap<Double, Double>> twinPositions = new ArrayList<TreeMap<Double, Double>>(nCurves);
        int i = 0;
        while (i < nCurves) {
            twinIndices.add(i, new TreeMap());
            twinPositions.add(i, new TreeMap());
            ++i;
        }
        ArrayList positions = new ArrayList(nCurves);
        int i2 = 0;
        while (i2 < nCurves) {
            positions.add(i2, new TreeSet());
            ++i2;
        }
        i2 = 0;
        while (i2 < nCurves - 1) {
            CirculinearContour2D curve1 = curveArray[i2];
            int j = i2 + 1;
            while (j < nCurves) {
                CirculinearContour2D curve2 = curveArray[j];
                double[][] couples = CirculinearCurve2DUtils.locateIntersections(curve1, curve2);
                int k = 0;
                while (k < couples.length) {
                    pos1 = couples[k][0];
                    pos2 = couples[k][1];
                    ((TreeSet)positions.get(i2)).add(pos1);
                    ((TreeSet)positions.get(j)).add(pos2);
                    ((TreeMap)twinIndices.get(i2)).put(pos1, j);
                    ((TreeMap)twinIndices.get(j)).put(pos2, i2);
                    twinPositions.get(i2).put(pos1, pos2);
                    twinPositions.get(j).put(pos2, pos1);
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        ArrayList<CirculinearContour2D> contours = new ArrayList<CirculinearContour2D>();
        int i3 = 0;
        while (i3 < nCurves) {
            if (((TreeMap)twinPositions.get(i3)).isEmpty()) {
                contours.add(curveArray[i3]);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < nCurves) {
            if (!curveArray[i3].isBounded() && !twinPositions.get(i3).isEmpty()) {
                pos0 = twinPositions.get(i3).firstEntry().getKey();
                ind0 = (Integer)((TreeMap)twinIndices.get(i3)).firstEntry().getValue();
                ArrayList<CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>();
                CirculinearContour2D curve0 = curveArray[i3];
                CirculinearCurve2DUtils.addElements(elements, (CirculinearContinuousCurve2D)curve0.getSubCurve(curve0.getT0(), pos0));
                pos1 = twinPositions.get(i3).firstEntry().getValue();
                int ind = ind0;
                do {
                    CirculinearContour2D curve = curveArray[ind];
                    pos2 = CirculinearCurve2DUtils.nextValue((TreeSet)positions.get(ind), pos1);
                    if (pos2 < pos1 && !curve.isBounded()) {
                        CirculinearCurve2DUtils.addElements(elements, (CirculinearContinuousCurve2D)curve.getSubCurve(pos1, curve.getT1()));
                        continue;
                    }
                    CirculinearCurve2DUtils.addElements(elements, (CirculinearContinuousCurve2D)curve.getSubCurve(pos1, pos2));
                    pos1 = twinPositions.get(ind).remove(pos2);
                    ind = (Integer)((TreeMap)twinIndices.get(ind)).remove(pos2);
                } while (ind != ind0);
                twinPositions.get(i3).remove(pos0);
                ((TreeMap)twinIndices.get(i3)).remove(pos0);
                contours.add(BoundaryPolyCirculinearCurve2D.create(elements, true));
            }
            ++i3;
        }
        while (!CirculinearCurve2DUtils.isAllEmpty(twinPositions)) {
            ArrayList<CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>();
            ind0 = 0;
            int i4 = 0;
            while (i4 < nCurves) {
                if (!twinPositions.get(i4).isEmpty()) {
                    pos0 = twinPositions.get(i4).firstEntry().getValue();
                    ind0 = (Integer)((TreeMap)twinIndices.get(i4)).firstEntry().getValue();
                    break;
                }
                ++i4;
            }
            if (ind0 == 0) {
                System.out.println("No more intersections, but was not detected");
            }
            pos1 = pos0;
            int ind = ind0;
            do {
                pos2 = CirculinearCurve2DUtils.nextValue((TreeSet)positions.get(ind), pos1);
                CirculinearCurve2DUtils.addElements(elements, (CirculinearContinuousCurve2D)curveArray[ind].getSubCurve(pos1, pos2));
                pos1 = twinPositions.get(ind).remove(pos2);
                ind = (Integer)((TreeMap)twinIndices.get(ind)).remove(pos2);
            } while (pos1 != pos0 || ind != ind0);
            contours.add(BoundaryPolyCirculinearCurve2D.create(elements, true));
        }
        return contours;
    }

    private static void addElements(Collection<CirculinearElement2D> elements, CirculinearContinuousCurve2D curve) {
        elements.addAll(curve.getSmoothPieces());
    }

    private static boolean isAllEmpty(Collection<TreeMap<Double, Double>> coll) {
        for (TreeMap<Double, Double> map : coll) {
            if (map.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static double nextValue(TreeSet<Double> tree, double value) {
        if (tree.higher(value) == null) {
            return tree.first();
        }
        return tree.higher(value);
    }

    public static CirculinearDomain2D computeBuffer(CirculinearCurve2D curve, double dist) {
        ArrayList<Object> contours = new ArrayList();
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve.getContinuousCurves()) {
            for (CirculinearContinuousCurve2D splitted : CirculinearCurve2DUtils.splitContinuousCurve(circulinearContinuousCurve2D)) {
                contours.addAll(CirculinearCurve2DUtils.computeBufferSimpleContour(splitted, dist));
            }
        }
        contours = new ArrayList<CirculinearContour2D>(CirculinearCurve2DUtils.splitIntersectingContours(contours));
        ArrayList<CirculinearContour2D> arrayList = new ArrayList<CirculinearContour2D>(contours.size());
        for (CirculinearContour2D circulinearContour2D : contours) {
            double distCurves;
            if (CirculinearCurve2DUtils.findIntersections(curve, circulinearContour2D).size() > 0 || (distCurves = CirculinearCurve2DUtils.getDistanceCurveSingularPoints(curve, circulinearContour2D)) < dist - 1.0E-12) continue;
            arrayList.add(circulinearContour2D);
        }
        return new GenericCirculinearDomain2D(new CirculinearBoundarySet2D(arrayList));
    }

    public static CirculinearDomain2D computeBuffer(PointSet2D set, double dist) {
        Collection<Object> contours = new ArrayList(set.getPointNumber());
        for (Point2D point : set) {
            contours.add(new Circle2D(point, Math.abs(dist), dist > 0.0));
        }
        contours = CirculinearCurve2DUtils.splitIntersectingContours(contours);
        ArrayList<CirculinearContour2D> contours2 = new ArrayList<CirculinearContour2D>(contours.size());
        for (CirculinearContour2D circulinearContour2D : contours) {
            double minDist = CirculinearCurve2DUtils.getDistanceCurvePoints(circulinearContour2D, set.getPoints());
            if (minDist < dist - 1.0E-12) continue;
            contours2.add(circulinearContour2D);
        }
        return new GenericCirculinearDomain2D(CirculinearBoundarySet2D.create(contours2));
    }

    public static Collection<? extends CirculinearContour2D> computeBufferSimpleContour(CirculinearContinuousCurve2D curve, double d) {
        Collection<CirculinearContinuousCurve2D> parallels = CirculinearCurve2DUtils.createFreeParallels(curve, d);
        Collection<CirculinearContour2D> contours = CirculinearCurve2DUtils.createContoursFromParallels(curve, parallels);
        Collection<CirculinearContour2D> contours2 = CirculinearCurve2DUtils.removeIntersectingContours(contours, curve, d);
        return contours2;
    }

    private static Collection<CirculinearContinuousCurve2D> createFreeParallels(CirculinearContinuousCurve2D curve, double d) {
        CirculinearContinuousCurve2D parallel1 = (CirculinearContinuousCurve2D)curve.getParallel(d);
        CirculinearContinuousCurve2D parallel2 = (CirculinearContinuousCurve2D)curve.getParallel(-d).getReverseCurve();
        ArrayList<CirculinearContinuousCurve2D> curves = new ArrayList<CirculinearContinuousCurve2D>();
        for (CirculinearContinuousCurve2D split : CirculinearCurve2DUtils.splitContinuousCurve(parallel1)) {
            if (CirculinearCurve2DUtils.findIntersections(curve, split).size() != 0) continue;
            curves.add(split);
        }
        for (CirculinearContinuousCurve2D split : CirculinearCurve2DUtils.splitContinuousCurve(parallel2)) {
            if (CirculinearCurve2DUtils.findIntersections(curve, split).size() != 0) continue;
            curves.add(split);
        }
        return curves;
    }

    private static Collection<CirculinearContour2D> createContoursFromParallels(CirculinearContinuousCurve2D curve, Collection<CirculinearContinuousCurve2D> parallels) {
        ArrayList<CirculinearContour2D> contours = new ArrayList<CirculinearContour2D>();
        if (curve.isClosed()) {
            for (CirculinearContinuousCurve2D continuous : parallels) {
                contours.add(CirculinearCurve2DUtils.convertCurveToBoundary(continuous));
            }
            return contours;
        }
        return CirculinearCurve2DUtils.createContoursFromParallels(parallels);
    }

    private static Collection<CirculinearContour2D> createContoursFromParallels(Collection<CirculinearContinuousCurve2D> parallels) {
        ArrayList<CirculinearContour2D> contours = new ArrayList<CirculinearContour2D>();
        CirculinearContinuousCurve2D curve1 = null;
        CirculinearContinuousCurve2D curve2 = null;
        for (CirculinearContinuousCurve2D continuous : parallels) {
            if (continuous.isClosed()) {
                contours.add(CirculinearCurve2DUtils.convertCurveToBoundary(continuous));
                continue;
            }
            if (curve1 == null) {
                curve1 = continuous;
                continue;
            }
            if (curve2 == null) {
                curve2 = continuous;
                continue;
            }
            System.err.println("more than 2 free curves....");
            return contours;
        }
        if (curve1 != null && curve2 != null) {
            contours.addAll(CirculinearCurve2DUtils.createSingleContourFromTwoParallels(curve1, curve2));
        }
        return contours;
    }

    private static Collection<CirculinearContour2D> createSingleContourFromTwoParallels(CirculinearContinuousCurve2D curve1, CirculinearContinuousCurve2D curve2) {
        ArrayList<CirculinearContour2D> contours = new ArrayList<CirculinearContour2D>();
        if (curve1 != null && curve2 != null) {
            ArrayList<CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>();
            boolean b0 = Curve2DUtils.isLeftInfinite(curve1);
            boolean b1 = Curve2DUtils.isRightInfinite(curve1);
            if (b0 && b1) {
                contours.add(CirculinearCurve2DUtils.convertCurveToBoundary(curve1));
                contours.add(CirculinearCurve2DUtils.convertCurveToBoundary(curve2));
            } else if (b0 && !b1) {
                Point2D p11 = curve1.getFirstPoint();
                Point2D p22 = curve2.getLastPoint();
                elements.addAll(curve2.getSmoothPieces());
                elements.add(CirculinearCurve2DUtils.createCircularCap(p22, p11));
                elements.addAll(curve1.getSmoothPieces());
                contours.add(new GenericCirculinearRing2D((Collection<? extends CirculinearElement2D>)elements));
            } else if (b1 && !b0) {
                Point2D p12 = curve1.getLastPoint();
                Point2D p21 = curve2.getFirstPoint();
                elements.addAll(curve1.getSmoothPieces());
                elements.add(CirculinearCurve2DUtils.createCircularCap(p12, p21));
                elements.addAll(curve2.getSmoothPieces());
                contours.add(new GenericCirculinearRing2D((Collection<? extends CirculinearElement2D>)elements));
            } else {
                Point2D p11 = curve1.getFirstPoint();
                Point2D p12 = curve1.getLastPoint();
                Point2D p21 = curve2.getFirstPoint();
                Point2D p22 = curve2.getLastPoint();
                elements.addAll(curve1.getSmoothPieces());
                elements.add(CirculinearCurve2DUtils.createCircularCap(p12, p21));
                elements.addAll(curve2.getSmoothPieces());
                elements.add(CirculinearCurve2DUtils.createCircularCap(p22, p11));
                contours.add(new GenericCirculinearRing2D((Collection<? extends CirculinearElement2D>)elements));
            }
        }
        return contours;
    }

    private static Collection<CirculinearContour2D> removeIntersectingContours(Collection<CirculinearContour2D> contours, CirculinearCurve2D curve, double d) {
        ArrayList<CirculinearContour2D> contours2 = new ArrayList<CirculinearContour2D>();
        for (CirculinearContour2D contour : contours) {
            for (CirculinearContinuousCurve2D splitted : CirculinearCurve2DUtils.splitContinuousCurve(contour)) {
                double dist = CirculinearCurve2DUtils.getDistanceCurvePoints(curve, splitted.getSingularPoints());
                if (dist - d < -1.0E-12) continue;
                contours2.add(CirculinearCurve2DUtils.convertCurveToBoundary(splitted));
            }
        }
        return contours2;
    }

    private static CirculinearContour2D convertCurveToBoundary(CirculinearContinuousCurve2D curve) {
        if (curve instanceof CirculinearContour2D) {
            return (CirculinearContour2D)curve;
        }
        if (curve.isClosed()) {
            return GenericCirculinearRing2D.create(curve.getSmoothPieces());
        }
        return BoundaryPolyCirculinearCurve2D.create(curve.getSmoothPieces());
    }

    private static CircleArc2D createCircularCap(Point2D p1, Point2D p2) {
        Point2D center = Point2D.midPoint(p1, p2);
        double radius = p1.getDistance(p2) / 2.0;
        double angle1 = Angle2D.getHorizontalAngle(center, p1);
        double angle2 = Angle2D.getHorizontalAngle(center, p2);
        return CircleArc2D.create(center, radius, angle1, angle2, true);
    }

    public static double getDistanceCurvePoints(CirculinearCurve2D curve, Collection<? extends Point2D> points) {
        double minDist = Double.MAX_VALUE;
        for (Point2D point2D : points) {
            minDist = Math.min(minDist, curve.getDistance(point2D));
        }
        return minDist;
    }

    private static double getDistanceCurveSingularPoints(CirculinearCurve2D ref, CirculinearCurve2D curve) {
        Collection<Point2D> points = curve.getSingularPoints();
        if (points.isEmpty()) {
            points = new ArrayList<Point2D>();
            double t = Curve2DUtils.choosePosition(curve.getT0(), curve.getT1());
            points.add(curve.getPoint(t));
        }
        double minDist = Double.MAX_VALUE;
        for (Point2D point : points) {
            minDist = Math.min(minDist, ref.getDistance(point));
        }
        return minDist;
    }
}

