/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearContour2D;
import math.geom2d.circulinear.CirculinearCurve2D;
import math.geom2d.circulinear.CirculinearCurve2DUtils;
import math.geom2d.circulinear.CirculinearCurveSet2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.CirculinearRing2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.circulinear.GenericCirculinearRing2D;
import math.geom2d.circulinear.PolyCirculinearCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.domain.BoundaryPolyCurve2D;
import math.geom2d.domain.ContinuousOrientedCurve2D;
import math.geom2d.transform.CircleInversion2D;

public class BoundaryPolyCirculinearCurve2D<T extends CirculinearContinuousCurve2D>
extends PolyCirculinearCurve2D<T>
implements CirculinearContinuousCurve2D,
CirculinearContour2D {
    public BoundaryPolyCirculinearCurve2D() {
    }

    public BoundaryPolyCirculinearCurve2D(int size) {
        super(size);
    }

    public BoundaryPolyCirculinearCurve2D(T[] curves) {
        super(curves);
    }

    public BoundaryPolyCirculinearCurve2D(T[] curves, boolean closed) {
        super(curves, closed);
    }

    public BoundaryPolyCirculinearCurve2D(Collection<? extends T> curves) {
        super(curves);
    }

    public BoundaryPolyCirculinearCurve2D(Collection<? extends T> curves, boolean closed) {
        super(curves, closed);
    }

    public static <T extends CirculinearContinuousCurve2D> BoundaryPolyCirculinearCurve2D<T> create(Collection<T> curves) {
        return new BoundaryPolyCirculinearCurve2D<T>(curves);
    }

    public static <T extends CirculinearContinuousCurve2D> BoundaryPolyCirculinearCurve2D<T> create(Collection<T> curves, boolean closed) {
        return new BoundaryPolyCirculinearCurve2D<T>(curves, closed);
    }

    public static <T extends CirculinearContour2D> BoundaryPolyCirculinearCurve2D<T> create(T[] curves) {
        return new BoundaryPolyCirculinearCurve2D(curves);
    }

    public static <T extends CirculinearContour2D> BoundaryPolyCirculinearCurve2D<T> create(T[] curves, boolean closed) {
        return new BoundaryPolyCirculinearCurve2D(curves, closed);
    }

    @Override
    public double getLength() {
        double sum = 0.0;
        for (CirculinearCurve2D curve : this.getCurves()) {
            sum += curve.getLength();
        }
        return sum;
    }

    @Override
    public double getLength(double pos) {
        return CirculinearCurve2DUtils.getLength(this, pos);
    }

    @Override
    public double getPosition(double length) {
        return CirculinearCurve2DUtils.getPosition(this, length);
    }

    @Override
    public CirculinearRing2D getParallel(double dist) {
        return GenericCirculinearRing2D.create(CirculinearCurve2DUtils.createContinuousParallel(this, dist).getSmoothPieces());
    }

    @Override
    public BoundaryPolyCirculinearCurve2D<? extends CirculinearContinuousCurve2D> transform(CircleInversion2D inv) {
        int n = this.curves.size();
        BoundaryPolyCirculinearCurve2D<CirculinearContinuousCurve2D> result = new BoundaryPolyCirculinearCurve2D<CirculinearContinuousCurve2D>(n);
        for (CirculinearContinuousCurve2D curve : this.curves) {
            result.addCurve((CirculinearContinuousCurve2D)curve.transform(inv));
        }
        return result;
    }

    @Override
    public void fill(Graphics2D g2) {
        g2.fill(this.getGeneralPath());
    }

    public Collection<BoundaryPolyCirculinearCurve2D<T>> getBoundaryCurves() {
        ArrayList<BoundaryPolyCirculinearCurve2D<T>> list = new ArrayList<BoundaryPolyCirculinearCurve2D<T>>(1);
        list.add(this);
        return list;
    }

    @Override
    public CirculinearDomain2D getDomain() {
        return new GenericCirculinearDomain2D(this);
    }

    @Override
    public Collection<? extends CirculinearElement2D> getSmoothPieces() {
        ArrayList<? extends CirculinearElement2D> result = new ArrayList<CirculinearElement2D>();
        for (CirculinearContinuousCurve2D curve : this.curves) {
            result.addAll(curve.getSmoothPieces());
        }
        return result;
    }

    @Override
    public Collection<? extends BoundaryPolyCirculinearCurve2D<?>> getContinuousCurves() {
        return BoundaryPolyCirculinearCurve2D.wrapCurve(this);
    }

    @Override
    public BoundaryPolyCirculinearCurve2D<? extends CirculinearContinuousCurve2D> getReverseCurve() {
        int n = this.curves.size();
        CirculinearContinuousCurve2D[] curves2 = new CirculinearContinuousCurve2D[n];
        int i = 0;
        while (i < n) {
            curves2[i] = (CirculinearContinuousCurve2D)((CirculinearContinuousCurve2D)this.curves.get(n - 1 - i)).getReverseCurve();
            ++i;
        }
        return new BoundaryPolyCirculinearCurve2D(curves2);
    }

    @Override
    public PolyCirculinearCurve2D<? extends CirculinearContinuousCurve2D> getSubCurve(double t0, double t1) {
        Curve2D subcurve = super.getSubCurve(t0, t1);
        int n = ((CurveArray2D)subcurve).getCurveNumber();
        PolyCirculinearCurve2D<CirculinearContinuousCurve2D> result = new PolyCirculinearCurve2D<CirculinearContinuousCurve2D>(n);
        Iterator iterator = ((CurveArray2D)subcurve).iterator();
        while (iterator.hasNext()) {
            Curve2D curve = (Curve2D)iterator.next();
            if (!(curve instanceof CirculinearContinuousCurve2D)) continue;
            result.addCurve((CirculinearContinuousCurve2D)curve);
        }
        return result;
    }

    @Override
    public CirculinearCurveSet2D<? extends CirculinearContinuousCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curve2DUtils.clipCurve(this, box);
        int n = set.getCurveNumber();
        CirculinearCurveSet2D<CirculinearContinuousCurve2D> result = new CirculinearCurveSet2D<CirculinearContinuousCurve2D>(n);
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof CirculinearContinuousCurve2D)) continue;
            result.addCurve((CirculinearContinuousCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public BoundaryPolyCurve2D<? extends ContinuousOrientedCurve2D> transform(AffineTransform2D trans) {
        int n = this.getCurveNumber();
        BoundaryPolyCurve2D<ContinuousOrientedCurve2D> result = new BoundaryPolyCurve2D<ContinuousOrientedCurve2D>(n);
        for (ContinuousOrientedCurve2D curve : this.curves) {
            result.addCurve((ContinuousOrientedCurve2D)curve.transform(trans));
        }
        result.setClosed(this.isClosed());
        return result;
    }
}

