package cz.cuni.amis.utils.floydwarshall;

import java.util.Collection;
import java.util.List;

/**
 * This class represents the search space for Floyd-Warshall algorithm.
 * <ol>
 * <li>we need to know which nodes are part of the map</li>
 * <li>we need to know the travel cost between two nodes (edge cost)</li>
 * </ol>
 */
@Deprecated
public interface FWMap<NODE> {
	
	/**
	 * This must return the list of ALL NODES that are present in your map (== environment).
	 * These nodes are going to be then used for FW.
	 * <p><p>
	 * IT IS FORBIDDEN TO SHUFFLE NODES IN THIS LIST ... IT MUST ALWAYS RETURN THE VERY SAME LIST (or at least
	 * list that is having every node in the place it was before).  
	 */
	public List<NODE> getNodes();
	
	/**
	 * General cost of having this node at your path. This allows you to say how every node appeals to the agent, 
	 * it may specify "this is a cool node, try to get it on your path" (negative cost) or "this is neutral node"
	 * (zero cost) or "this is a bad node to have on your path" (positive cost).
	 * 
	 * @param node
	 * @return
	 */
	public int getNodeCost(NODE node);
	
	/**
	 * Should return the distance from nodeFrom to nodeTo.
     * You can be sure that nodeTo is among the neighbours of nodeFrom.
     * 
	 * @param nodeFrom
	 * @param nodeTo
	 * @return cost of an edge
	 */
	public int getEdgeCost(NODE nodeFrom, NODE nodeTo);
	
	
}
