/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.Preconditions;
import com.humaorie.dollar.SortedSetWrapper;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

public class SetWrapper<T>
extends AbstractWrapper<T>
implements Dollar.SetWrapper<T> {
    private Set<T> set;

    public SetWrapper(Set<T> set) {
        Preconditions.require(set != null, "set must be non-null", new Object[0]);
        this.set = set;
    }

    @Override
    public SetWrapper<T> copy() {
        Set copy = SetWrapper.createSet(this.set.getClass());
        SetWrapper.addToCollection(copy, this);
        return new SetWrapper(copy);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.set.iterator();
    }

    @Override
    public SetWrapper<T> add(T item) {
        this.set.add(item);
        return this;
    }

    @Override
    public SetWrapper<T> addAll(Iterable<T> items) {
        SetWrapper.addToCollection(this.set, items);
        return this;
    }

    @Override
    public SetWrapper<T> threadSafe() {
        this.set = Collections.synchronizedSet(this.set);
        return this;
    }

    @Override
    public SetWrapper<T> immutable() {
        this.set = Collections.unmodifiableSet(this.set);
        return this;
    }

    @Override
    public Dollar.SetWrapper<T> checked(Class<T> requiredClass) {
        this.set = Collections.checkedSet(this.set, requiredClass);
        return this;
    }

    @Override
    public Set<T> toSet() {
        return this.set;
    }

    @Override
    public T[] toArray() {
        return SetWrapper.iterableToArray(this.set, this.set.size());
    }

    @Override
    public Dollar.Wrapper<T> reverse() {
        return this;
    }

    @Override
    public Dollar.Wrapper<T> shuffle(Random random) {
        return this;
    }

    @Override
    public Dollar.Wrapper<T> sort() {
        return new SortedSetWrapper<T>(this.set);
    }

    public boolean equals(Object object) {
        if (object instanceof SetWrapper) {
            SetWrapper setWrapper = (SetWrapper)object;
            return this.set.equals(setWrapper.set);
        }
        return false;
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public String toString() {
        return this.set.toString();
    }
}

