/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.ConcatWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.Preconditions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public class RepeatWrapper<T>
extends AbstractWrapper<T> {
    protected final ConcatWrapper<T> concatWrapper;

    public RepeatWrapper(ConcatWrapper<T> concatWrapper) {
        this.concatWrapper = concatWrapper;
    }

    public RepeatWrapper(Dollar.Wrapper<T> wrapper, int n) {
        Preconditions.require(wrapper != null, "n must be positive", new Object[0]);
        Preconditions.require(n > 0, "n must be positive", new Object[0]);
        this.concatWrapper = new ConcatWrapper(new LinkedList());
        for (int i = 0; i < n; ++i) {
            this.concatWrapper.concat(wrapper.copy());
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.concatWrapper.iterator();
    }

    @Override
    public Dollar.Wrapper<T> shuffle(Random random) {
        Preconditions.require(random != null, "random must be non-null", new Object[0]);
        return this.concatWrapper.shuffle(random);
    }

    @Override
    public int size() {
        return this.concatWrapper.size();
    }

    @Override
    public Dollar.Wrapper<T> copy() {
        return new RepeatWrapper<T>((ConcatWrapper)this.concatWrapper.copy());
    }

    @Override
    public Dollar.Wrapper<T> sort() {
        return this.concatWrapper.sort();
    }

    public boolean equals(Object object) {
        if (object instanceof RepeatWrapper) {
            RepeatWrapper repeatWrapper = (RepeatWrapper)object;
            return this.concatWrapper.equals(repeatWrapper.concatWrapper);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        return hash *= 83 + this.concatWrapper.hashCode();
    }
}

