/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.Preconditions;
import java.util.Random;

public abstract class RandomWrapper<T>
extends AbstractWrapper<T>
implements Dollar.RandomWrapper<T> {
    protected Random random;
    protected int samples;

    public RandomWrapper(Random random, int samples) {
        this.generator(random);
        this.samples(samples);
    }

    @Override
    public final RandomWrapper<T> samples(int newSamples) {
        Preconditions.require(newSamples > 0, "samples must be positive", new Object[0]);
        this.samples = newSamples;
        return this;
    }

    @Override
    public final Dollar.RandomWrapper<T> generator(Random random) {
        Preconditions.require(random != null, "random must be non-null", new Object[0]);
        this.random = random;
        return this;
    }

    @Override
    public Dollar.Wrapper<T> shuffle(Random random) {
        return this;
    }

    @Override
    public Dollar.Wrapper<T> reverse() {
        return this;
    }

    @Override
    public Dollar.Wrapper<T> slice(int i, int j) {
        if (i >= 0 && j < this.samples) {
            this.samples = j - i;
        }
        return this;
    }

    @Override
    public int size() {
        return this.samples;
    }
}

