/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.RandomIterator;
import com.humaorie.dollar.RandomWrapper;
import java.util.Iterator;
import java.util.Random;

class RandomLongWrapper
extends RandomWrapper<Long> {
    private final long upTo;

    public RandomLongWrapper(Random random, int samples, long upTo) {
        super(random, samples);
        this.upTo = upTo;
    }

    @Override
    public Iterator<Long> iterator() {
        return new RandomIterator<Long>(this.samples){

            @Override
            public Long nextRandom() {
                return RandomLongWrapper.this.random.nextLong() % RandomLongWrapper.this.upTo;
            }
        };
    }

    @Override
    public Dollar.Wrapper<Long> copy() {
        return new RandomLongWrapper(this.random, this.samples, this.upTo);
    }

    public boolean equals(Object object) {
        if (object instanceof RandomLongWrapper) {
            RandomLongWrapper randomLongWrapper = (RandomLongWrapper)object;
            return this.random == randomLongWrapper.random && this.samples == randomLongWrapper.samples && this.upTo == randomLongWrapper.upTo;
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash *= 79 + this.random.hashCode();
        hash = (int)((long)hash * (79L + this.upTo));
        return hash *= 79 + this.samples;
    }
}

