/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.RandomIterator;
import com.humaorie.dollar.RandomWrapper;
import java.util.Iterator;
import java.util.Random;

class RandomFloatWrapper
extends RandomWrapper<Float> {
    private final float upTo;

    public RandomFloatWrapper(Random random, int samples, float upTo) {
        super(random, samples);
        this.upTo = upTo;
    }

    @Override
    public Iterator<Float> iterator() {
        return new RandomIterator<Float>(this.samples){

            @Override
            public Float nextRandom() {
                return Float.valueOf(RandomFloatWrapper.this.random.nextFloat() * RandomFloatWrapper.this.upTo);
            }
        };
    }

    @Override
    public Dollar.Wrapper<Float> copy() {
        return new RandomFloatWrapper(this.random, this.samples, this.upTo);
    }

    public boolean equals(Object object) {
        if (object instanceof RandomFloatWrapper) {
            RandomFloatWrapper randomFloatWrapper = (RandomFloatWrapper)object;
            return this.random == randomFloatWrapper.random && this.samples == randomFloatWrapper.samples && this.upTo == randomFloatWrapper.upTo;
        }
        return false;
    }

    public int hashCode() {
        int hash = 23;
        hash *= 79 + this.random.hashCode();
        hash = (int)((float)hash * (79.0f + this.upTo));
        return hash *= 79 + this.samples;
    }
}

