/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.RandomIterator;
import com.humaorie.dollar.RandomWrapper;
import java.util.Iterator;
import java.util.Random;

class RandomDoubleWrapper
extends RandomWrapper<Double> {
    private final double upTo;

    public RandomDoubleWrapper(Random random, int samples, double upTo) {
        super(random, samples);
        this.upTo = upTo;
    }

    @Override
    public Iterator<Double> iterator() {
        return new RandomIterator<Double>(this.samples){

            @Override
            public Double nextRandom() {
                return RandomDoubleWrapper.this.random.nextDouble() * RandomDoubleWrapper.this.upTo;
            }
        };
    }

    @Override
    public Dollar.Wrapper<Double> copy() {
        return new RandomDoubleWrapper(this.random, this.samples, this.upTo);
    }

    public boolean equals(Object object) {
        if (object instanceof RandomDoubleWrapper) {
            RandomDoubleWrapper randomDoubleWrapper = (RandomDoubleWrapper)object;
            return this.random == randomDoubleWrapper.random && this.samples == randomDoubleWrapper.samples && this.upTo == randomDoubleWrapper.upTo;
        }
        return false;
    }

    public int hashCode() {
        int hash = 29;
        hash *= 79 + this.random.hashCode();
        hash = (int)((double)hash * (79.0 + this.upTo));
        return hash *= 79 + this.samples;
    }
}

