/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.Preconditions;
import java.util.Iterator;

public class LazyMappedWrapper<R, T>
extends AbstractWrapper<R> {
    private final Dollar.Wrapper<T> delegate;
    private final Dollar.Function<R, T> mapper;

    public LazyMappedWrapper(Dollar.Wrapper<T> delegate, Dollar.Function<R, T> mapper) {
        Preconditions.require(delegate != null, "delegate must be non-null", new Object[0]);
        Preconditions.require(mapper != null, "mapper must be non-null", new Object[0]);
        this.delegate = delegate;
        this.mapper = mapper;
    }

    @Override
    public Dollar.Wrapper<R> copy() {
        return new LazyMappedWrapper<R, T>(this.delegate.copy(), this.mapper);
    }

    @Override
    public Iterator<R> iterator() {
        final Iterator unmapped = this.delegate.iterator();
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return unmapped.hasNext();
            }

            @Override
            public R next() {
                return LazyMappedWrapper.this.mapper.call(unmapped.next());
            }

            @Override
            public void remove() {
                unmapped.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.delegate.size();
    }
}

