/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.ListWrapper;
import com.humaorie.dollar.Preconditions;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class DateRangeWrapper
extends AbstractWrapper<Date> {
    private final Date begin;
    private final Date end;
    private final int step;
    private final int field;
    static final int SECOND = 1000;
    static final int MINUTE = 60000;
    static final int HOUR = 3600000;
    static final int DAY = 86400000;
    static final int YEAR = 1471228928;

    public DateRangeWrapper(Date begin, Date end, int step, int field) {
        Preconditions.require(begin != null, "begin date must be non-null", new Object[0]);
        Preconditions.require(end != null, "end date must be non-null", new Object[0]);
        this.begin = begin;
        this.end = end;
        this.step = step;
        this.field = field;
    }

    public DateRangeWrapper(Date begin, Date end) {
        this(begin, end, 1);
    }

    public DateRangeWrapper(Date begin, Date end, int step) {
        this(begin, end, step, 5);
    }

    @Override
    public Iterator<Date> iterator() {
        return new DateIterator(this.begin, this.end);
    }

    @Override
    public Dollar.Wrapper<Date> copy() {
        return new DateRangeWrapper(this.begin, this.end, this.step, this.field);
    }

    @Override
    public Dollar.Wrapper<Date> repeat(int n) {
        long diff = this.getDiff();
        int size = this.size();
        Date end = new Date(this.begin.getTime() + (long)(n * size) * diff * (long)this.step - (long)(n == 0 ? 0 : 1));
        return new DateRangeWrapper(this.begin, end, this.step, this.field);
    }

    @Override
    public int size() {
        if (this.begin.equals(this.end)) {
            return 0;
        }
        long d = this.getDiff();
        return (int)((long)((int)(this.end.getTime() - this.begin.getTime())) / (d * (long)this.step)) + 1;
    }

    @Override
    public Dollar.Wrapper<Date> slice(int i, int j) {
        if (i >= 0 && j < this.size()) {
            long diff = this.getDiff();
            Date begin = new Date(this.begin.getTime() + (long)i * diff * (long)this.step);
            Date end = new Date(this.begin.getTime() + (long)(j - 1) * diff * (long)this.step);
            return new DateRangeWrapper(begin, end, this.step, this.field);
        }
        return this;
    }

    protected long getDiff() {
        long d;
        switch (this.field) {
            case 14: {
                d = 1L;
                break;
            }
            case 13: {
                d = 1000L;
                break;
            }
            case 12: {
                d = 60000L;
                break;
            }
            case 10: 
            case 11: {
                d = 3600000L;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                d = 86400000L;
                break;
            }
            case 1: {
                d = 1471228928L;
                break;
            }
            default: {
                d = -1702967296L;
            }
        }
        return d;
    }

    @Override
    public Dollar.Wrapper<Date> shuffle(Random random) {
        return new ListWrapper<Date>(this).shuffle();
    }

    @Override
    public Dollar.Wrapper<Date> reverse() {
        return new DateRangeWrapper(this.end, this.begin, this.step * -1, this.field);
    }

    public boolean equals(Object object) {
        if (object instanceof DateRangeWrapper) {
            DateRangeWrapper dateRangeWrapper = (DateRangeWrapper)object;
            return dateRangeWrapper.begin.equals(this.begin) && dateRangeWrapper.end.equals(this.end);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash *= 53 + this.begin.hashCode();
        return hash *= 53 + this.end.hashCode();
    }

    private class DateIterator
    implements Iterator<Date> {
        private Date current;
        private final Date end;

        public DateIterator(Date begin, Date end) {
            this.current = begin;
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.current.before(this.end);
        }

        @Override
        public Date next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.current);
            calendar.add(DateRangeWrapper.this.field, DateRangeWrapper.this.step);
            this.current = calendar.getTime();
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported for DateWrapper");
        }
    }
}

