/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.ArrayWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.Preconditions;
import com.humaorie.dollar.RepeatCharSequenceWrapper;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class CharSequenceWrapper
extends AbstractWrapper<Character> {
    private final CharSequence charSequence;

    public CharSequenceWrapper(CharSequence charSequence) {
        Preconditions.require(charSequence != null, "charSequence must be non-null", new Object[0]);
        this.charSequence = charSequence;
    }

    @Override
    public Dollar.Wrapper<Character> repeat(int n) {
        Preconditions.require(n > 0, "n must be positive", new Object[0]);
        return new RepeatCharSequenceWrapper(this.charSequence, n);
    }

    @Override
    public Dollar.Wrapper<Character> copy() {
        return new CharSequenceWrapper(this.charSequence);
    }

    @Override
    public Dollar.Wrapper<Character> reverse() {
        return new CharSequenceWrapper(new StringBuilder(this.charSequence).reverse().toString());
    }

    @Override
    public Dollar.Wrapper<Character> shuffle(Random random) {
        Preconditions.require(random != null, "random must be non-null", new Object[0]);
        StringBuilder stringBuilder = new StringBuilder(this.charSequence);
        for (int i = 0; i < stringBuilder.length(); ++i) {
            int j = random.nextInt(stringBuilder.length());
            char c = stringBuilder.charAt(i);
            stringBuilder.setCharAt(i, stringBuilder.charAt(j));
            stringBuilder.setCharAt(j, c);
        }
        return new CharSequenceWrapper(stringBuilder.toString());
    }

    @Override
    public int size() {
        return this.charSequence.length();
    }

    @Override
    public Dollar.Wrapper<Character> slice(int i, int j) {
        if (i >= 0 && j < this.charSequence.length()) {
            return new CharSequenceWrapper(this.charSequence.subSequence(i, j));
        }
        return this;
    }

    @Override
    public Iterator<Character> iterator() {
        return new CharSequenceIterator(this.charSequence);
    }

    @Override
    public Dollar.Wrapper<Character> sort() {
        return new ArrayWrapper.CharArrayWrapper(CharSequenceWrapper.charSequenceToArray(this.charSequence)).sort();
    }

    public Character[] toArray() {
        return (Character[])new ArrayWrapper.CharArrayWrapper(CharSequenceWrapper.charSequenceToArray(this.charSequence)).toArray();
    }

    public boolean equals(Object object) {
        if (object instanceof CharSequenceWrapper) {
            CharSequenceWrapper charSequenceWrapper = (CharSequenceWrapper)object;
            return this.charSequence.equals(charSequenceWrapper.charSequence);
        }
        return false;
    }

    public int hashCode() {
        return this.charSequence.hashCode();
    }

    public String toString() {
        return this.charSequence.toString();
    }

    private static char[] charSequenceToArray(CharSequence charSequence) {
        char[] array = new char[charSequence.length()];
        for (int i = 0; i < charSequence.length(); ++i) {
            array[i] = charSequence.charAt(i);
        }
        return array;
    }

    public static class CharSequenceIterator
    implements Iterator<Character> {
        private final CharSequence charSequence;
        private int i;

        public CharSequenceIterator(CharSequence charSequence) {
            this.charSequence = charSequence;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.charSequence.length();
        }

        @Override
        public Character next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return Character.valueOf(this.charSequence.charAt(this.i++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported for CharSequenceWrapper");
        }
    }
}

