/*
 * Decompiled with CFR 0.152.
 */
package com.humaorie.dollar;

import com.humaorie.dollar.AbstractWrapper;
import com.humaorie.dollar.Dollar;
import com.humaorie.dollar.Preconditions;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;

public class ArrayWrapper<T>
extends AbstractWrapper<T>
implements Dollar.ArrayWrapper<T> {
    protected T[] array;
    static final Map<Class<?>, Class<?>> PRIMITIVE = new HashMap();
    static final Map<Class<?>, Object> ZERO;

    public ArrayWrapper(T[] array) {
        Preconditions.require(array != null, "array must be non-null", new Object[0]);
        this.array = array;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator<T>(this.array);
    }

    @Override
    public Dollar.Wrapper<T> copy() {
        T[] copy = Arrays.copyOf(this.array, this.array.length);
        return new ArrayWrapper<T>(copy);
    }

    @Override
    public Dollar.Wrapper<T> fill(T object) {
        Arrays.fill(this.array, object);
        return this;
    }

    @Override
    public Dollar.Wrapper<T> shuffle(Random random) {
        Preconditions.require(random != null, "random must be non-null", new Object[0]);
        for (int i = 0; i < this.size(); ++i) {
            int j = random.nextInt(this.size());
            T item = this.array[i];
            this.array[i] = this.array[j];
            this.array[j] = item;
        }
        return this;
    }

    @Override
    public Dollar.Wrapper<T> slice(int i, int j) {
        if (i >= 0 && j < this.array.length) {
            this.array = Arrays.copyOfRange(this.array, i, j);
        }
        return this;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public Dollar.Wrapper<T> sort() {
        Arrays.sort(this.array);
        return this;
    }

    @Override
    public Dollar.Wrapper<T> repeat(int n) {
        Preconditions.require(n > 0, "n must be positive", new Object[0]);
        T[] repeated = Arrays.copyOf(this.array, n * this.size());
        for (int i = 1; i < n; ++i) {
            System.arraycopy(this.array, 0, repeated, i * n, this.array.length);
        }
        return new ArrayWrapper<T>(repeated);
    }

    @Override
    public Dollar.Wrapper<T> reverse() {
        for (int i = 0; i < this.array.length / 2; ++i) {
            T temp = this.array[i];
            this.array[i] = this.array[this.array.length - i - 1];
            this.array[this.array.length - i - 1] = temp;
        }
        return this;
    }

    @Override
    public T[] toArray() {
        return this.array;
    }

    public boolean equals(Object object) {
        if (object instanceof ArrayWrapper) {
            ArrayWrapper arrayWrapper = (ArrayWrapper)object;
            return Arrays.equals(this.array, arrayWrapper.array);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    @Override
    public boolean[] toBooleanArray() {
        return (boolean[])ArrayWrapper.toUnboxedArray(Boolean.class, this.array);
    }

    @Override
    public byte[] toByteArray() {
        return (byte[])ArrayWrapper.toUnboxedArray(Byte.class, this.array);
    }

    @Override
    public char[] toCharArray() {
        return (char[])ArrayWrapper.toUnboxedArray(Character.class, this.array);
    }

    @Override
    public double[] toDoubleArray() {
        return (double[])ArrayWrapper.toUnboxedArray(Double.class, this.array);
    }

    @Override
    public float[] toFloatArray() {
        return (float[])ArrayWrapper.toUnboxedArray(Float.class, this.array);
    }

    @Override
    public int[] toIntArray() {
        return (int[])ArrayWrapper.toUnboxedArray(Integer.class, this.array);
    }

    @Override
    public long[] toLongArray() {
        return (long[])ArrayWrapper.toUnboxedArray(Long.class, this.array);
    }

    @Override
    public short[] toShortArray() {
        return (short[])ArrayWrapper.toUnboxedArray(Short.class, this.array);
    }

    protected static <T> T[] toBoxedArray(Class<T> boxClass, Object components) {
        int length = Array.getLength(components);
        Object res = Array.newInstance(boxClass, length);
        for (int i = 0; i < length; ++i) {
            Array.set(res, i, Array.get(components, i));
        }
        return (Object[])res;
    }

    protected static <T> Object toUnboxedArray(Class<?> wantedClass, T[] components) {
        Preconditions.require(components != null, "array must be non-null", new Object[0]);
        Class<?> primitive = PRIMITIVE.get(wantedClass);
        if (!ZERO.containsKey(components.getClass().getComponentType())) {
            return Array.newInstance(primitive, 0);
        }
        int length = components.length;
        Object unboxed = Array.newInstance(primitive, length);
        Object zero = ZERO.get(wantedClass);
        for (int i = 0; i < length; ++i) {
            if (components[i] == null) {
                Array.set(unboxed, i, zero);
                continue;
            }
            Array.set(unboxed, i, components[i]);
        }
        return unboxed;
    }

    static {
        PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE.put(Character.class, Character.TYPE);
        PRIMITIVE.put(Byte.class, Byte.TYPE);
        PRIMITIVE.put(Short.class, Short.TYPE);
        PRIMITIVE.put(Integer.class, Integer.TYPE);
        PRIMITIVE.put(Long.class, Long.TYPE);
        PRIMITIVE.put(Float.class, Float.TYPE);
        PRIMITIVE.put(Double.class, Double.TYPE);
        PRIMITIVE.put(Boolean.TYPE, Boolean.TYPE);
        PRIMITIVE.put(Character.TYPE, Character.TYPE);
        PRIMITIVE.put(Byte.TYPE, Byte.TYPE);
        PRIMITIVE.put(Short.TYPE, Short.TYPE);
        PRIMITIVE.put(Integer.TYPE, Integer.TYPE);
        PRIMITIVE.put(Long.TYPE, Long.TYPE);
        PRIMITIVE.put(Float.TYPE, Float.TYPE);
        PRIMITIVE.put(Double.TYPE, Double.TYPE);
        ZERO = new HashMap();
        ZERO.put(Boolean.class, false);
        ZERO.put(Boolean.TYPE, false);
        ZERO.put(Character.class, Character.valueOf('\u0000'));
        ZERO.put(Character.TYPE, Character.valueOf('\u0000'));
        ZERO.put(Byte.class, (byte)0);
        ZERO.put(Byte.TYPE, (byte)0);
        ZERO.put(Short.class, (short)0);
        ZERO.put(Short.TYPE, (short)0);
        ZERO.put(Integer.class, 0);
        ZERO.put(Integer.TYPE, 0);
        ZERO.put(Long.class, 0L);
        ZERO.put(Long.TYPE, 0L);
        ZERO.put(Float.class, Float.valueOf(0.0f));
        ZERO.put(Float.TYPE, Float.valueOf(0.0f));
        ZERO.put(Double.class, 0.0);
        ZERO.put(Double.TYPE, 0.0);
    }

    public static class DoubleArrayWrapper
    extends ArrayWrapper<Double> {
        public DoubleArrayWrapper(double[] doubles) {
            super(DoubleArrayWrapper.toBoxedArray(Double.class, doubles));
        }

        public DoubleArrayWrapper(Double[] doubles) {
            super(doubles);
        }

        @Override
        public double[] toDoubleArray() {
            return (double[])DoubleArrayWrapper.toUnboxedArray(Double.class, this.array);
        }
    }

    public static class FloatArrayWrapper
    extends ArrayWrapper<Float> {
        public FloatArrayWrapper(float[] floats) {
            super(FloatArrayWrapper.toBoxedArray(Float.class, floats));
        }

        public FloatArrayWrapper(Float[] floats) {
            super(floats);
        }

        @Override
        public float[] toFloatArray() {
            return (float[])FloatArrayWrapper.toUnboxedArray(Float.TYPE, this.array);
        }

        @Override
        public double[] toDoubleArray() {
            return (double[])FloatArrayWrapper.toUnboxedArray(Double.class, this.array);
        }
    }

    public static class LongArrayWrapper
    extends ArrayWrapper<Long> {
        public LongArrayWrapper(long[] longs) {
            super(LongArrayWrapper.toBoxedArray(Long.class, longs));
        }

        public LongArrayWrapper(Long[] longs) {
            super(longs);
        }

        @Override
        public long[] toLongArray() {
            return (long[])LongArrayWrapper.toUnboxedArray(Long.TYPE, this.array);
        }
    }

    public static class IntegerArrayWrapper
    extends ArrayWrapper<Integer> {
        public IntegerArrayWrapper(int[] ints) {
            super(IntegerArrayWrapper.toBoxedArray(Integer.class, ints));
        }

        public IntegerArrayWrapper(Integer[] ints) {
            super(ints);
        }

        @Override
        public int[] toIntArray() {
            return (int[])IntegerArrayWrapper.toUnboxedArray(Integer.TYPE, this.array);
        }

        @Override
        public long[] toLongArray() {
            return (long[])IntegerArrayWrapper.toUnboxedArray(Long.TYPE, this.array);
        }
    }

    public static class ShortArrayWrapper
    extends ArrayWrapper<Short> {
        public ShortArrayWrapper(short[] shorts) {
            super(ShortArrayWrapper.toBoxedArray(Short.class, shorts));
        }

        public ShortArrayWrapper(Short[] shorts) {
            super(shorts);
        }

        @Override
        public short[] toShortArray() {
            return (short[])ShortArrayWrapper.toUnboxedArray(Byte.TYPE, this.array);
        }

        @Override
        public int[] toIntArray() {
            return (int[])ShortArrayWrapper.toUnboxedArray(Integer.TYPE, this.array);
        }

        @Override
        public long[] toLongArray() {
            return (long[])ShortArrayWrapper.toUnboxedArray(Long.TYPE, this.array);
        }
    }

    public static class ByteArrayWrapper
    extends ArrayWrapper<Byte> {
        public ByteArrayWrapper(byte[] bytes) {
            super(ByteArrayWrapper.toBoxedArray(Byte.class, bytes));
        }

        public ByteArrayWrapper(Byte[] bytes) {
            super(bytes);
        }

        @Override
        public byte[] toByteArray() {
            return (byte[])ByteArrayWrapper.toUnboxedArray(Byte.TYPE, this.array);
        }

        @Override
        public char[] toCharArray() {
            return (char[])ByteArrayWrapper.toUnboxedArray(Character.TYPE, this.array);
        }

        @Override
        public short[] toShortArray() {
            return (short[])ByteArrayWrapper.toUnboxedArray(Short.TYPE, this.array);
        }

        @Override
        public int[] toIntArray() {
            return (int[])ByteArrayWrapper.toUnboxedArray(Integer.TYPE, this.array);
        }

        @Override
        public long[] toLongArray() {
            return (long[])ByteArrayWrapper.toUnboxedArray(Long.TYPE, this.array);
        }
    }

    public static class CharArrayWrapper
    extends ArrayWrapper<Character> {
        public CharArrayWrapper(char[] characters) {
            super(CharArrayWrapper.toBoxedArray(Character.class, characters));
        }

        public CharArrayWrapper(Character[] characters) {
            super(characters);
        }

        @Override
        public char[] toCharArray() {
            return (char[])CharArrayWrapper.toUnboxedArray(Character.TYPE, this.array);
        }

        @Override
        public short[] toShortArray() {
            return (short[])CharArrayWrapper.toUnboxedArray(Byte.TYPE, this.array);
        }

        @Override
        public int[] toIntArray() {
            return (int[])CharArrayWrapper.toUnboxedArray(Integer.TYPE, this.array);
        }

        @Override
        public long[] toLongArray() {
            return (long[])CharArrayWrapper.toUnboxedArray(Long.TYPE, this.array);
        }
    }

    public static class BooleanArrayWrapper
    extends ArrayWrapper<Boolean> {
        public BooleanArrayWrapper(boolean[] booleans) {
            super(BooleanArrayWrapper.toBoxedArray(Boolean.class, booleans));
        }

        public BooleanArrayWrapper(Boolean[] booleans) {
            super(booleans);
        }

        @Override
        public boolean[] toBooleanArray() {
            return (boolean[])BooleanArrayWrapper.toUnboxedArray(Boolean.TYPE, this.array);
        }
    }

    private static class ArrayIterator<T>
    implements Iterator<T> {
        private int i = 0;
        private final T[] array;

        public ArrayIterator(T[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.array.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.i++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported for ArrayWrapper");
        }
    }
}

