/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.examples;

import foxtrot.Task;
import foxtrot.Worker;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;

public class SimpleExample
extends JFrame {
    private boolean sleeping;
    private JButton button = new JButton("Take a nap !");

    public static void main(String[] args) {
        SimpleExample example = new SimpleExample();
        example.setVisible(true);
    }

    public SimpleExample() {
        super("Foxtrot Example");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SimpleExample.this.sleeping) {
                    SimpleExample.this.wakeUp();
                } else {
                    SimpleExample.this.sleep();
                }
            }
        });
        this.setDefaultCloseOperation(2);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        c.add(this.button);
        this.setSize(300, 200);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        int x = screen.width - size.width >> 1;
        int y = screen.height - size.height >> 1;
        this.setLocation(x, y);
    }

    private void sleep() {
        this.button.setText("Wake me up!");
        this.workerSleep();
        this.button.setText("Take a nap!");
    }

    private void workerSleep() {
        try {
            Worker.post((Task)new Task(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws InterruptedException {
                    SimpleExample simpleExample = SimpleExample.this;
                    synchronized (simpleExample) {
                        SimpleExample.this.sleeping = true;
                        SimpleExample.this.wait();
                        SimpleExample.this.sleeping = false;
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException x) {
            x.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freezeSleep() {
        try {
            SimpleExample simpleExample = this;
            synchronized (simpleExample) {
                this.sleeping = true;
                this.wait();
                this.sleeping = false;
            }
        }
        catch (InterruptedException x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        SimpleExample simpleExample = this;
        synchronized (simpleExample) {
            this.notifyAll();
        }
    }
}

