/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.examples;

import foxtrot.Task;
import foxtrot.Worker;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;

public class InterruptExample
extends JFrame {
    private JButton button;
    private boolean running;
    private boolean taskInterrupted;

    public static void main(String[] args) {
        InterruptExample example = new InterruptExample();
        example.setVisible(true);
    }

    public InterruptExample() {
        super("Foxtrot Example");
        String label = "Run Task !";
        this.button = new JButton("Run Task !");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InterruptExample.this.onButtonClick("Run Task !");
            }
        });
        this.setDefaultCloseOperation(2);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        c.add(this.button);
        this.setSize(300, 200);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        int x = screen.width - size.width >> 1;
        int y = screen.height - size.height >> 1;
        this.setLocation(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onButtonClick(String label) {
        if (!this.running) {
            this.running = true;
            this.button.setText("Interrupt");
            try {
                ArrayList list = this.getData();
                if (list == null) {
                    return;
                }
                DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            finally {
                this.button.setText(label);
                this.setTaskInterrupted(false);
                this.running = false;
            }
        } else {
            this.button.setText(label);
            this.setTaskInterrupted(true);
        }
    }

    private ArrayList getData() throws Exception {
        return (ArrayList)Worker.post((Task)new Task(){

            public Object run() throws Exception {
                System.out.println("Task started...");
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < 100; ++i) {
                    System.out.println("Heavy Operation number " + (i + 1));
                    Thread.sleep(250L);
                    Object data = new Object();
                    list.add(data);
                    System.out.println("Checking if task is interrupted...");
                    if (InterruptExample.this.isTaskInterrupted()) {
                        System.out.println("Task interrupted !");
                        break;
                    }
                    System.out.println("Task not interrupted, going on");
                }
                if (InterruptExample.this.isTaskInterrupted()) {
                    list.clear();
                    return null;
                }
                return list;
            }
        });
    }

    private synchronized boolean isTaskInterrupted() {
        return this.taskInterrupted;
    }

    private synchronized void setTaskInterrupted(boolean value) {
        this.taskInterrupted = value;
    }
}

