/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.utils;

import java.io.File;
import java.util.Locale;
import java.util.Stack;
import org.openide.util.Utilities;

public class Utils {
    public static boolean equals(File f1, File f2) {
        if (f1 == null) {
            return f2 == null;
        }
        if (f2 == null) {
            return f1 == null;
        }
        if (Utilities.isMac()) {
            return f1.getPath().compareToIgnoreCase(f2.getPath()) == 0;
        }
        return f1.equals(f2);
    }

    public static int hashCode(File file) {
        if (Utilities.isMac()) {
            return file.getPath().toLowerCase(Locale.ENGLISH).hashCode() ^ 0x12D591;
        }
        return file.hashCode();
    }

    public static String getRelativePath(File dir, File file) {
        File tempFile;
        Stack<String> stack = new Stack<String>();
        for (tempFile = file; tempFile != null && !Utils.equals(tempFile, dir); tempFile = tempFile.getParentFile()) {
            stack.push(tempFile.getName());
        }
        if (tempFile == null) {
            return null;
        }
        StringBuilder retval = new StringBuilder();
        while (!stack.isEmpty()) {
            retval.append((String)stack.pop());
            if (stack.isEmpty()) continue;
            retval.append("/");
        }
        return retval.toString();
    }
}

