/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.watcher;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import org.netbeans.modules.masterfs.watcher.Watcher;
import org.openide.filesystems.FileObject;

public abstract class Notifier<KEY> {
    public abstract KEY addWatch(String var1) throws IOException;

    public abstract void removeWatch(KEY var1) throws IOException;

    public abstract String nextEvent() throws IOException, InterruptedException;

    protected void stop() throws IOException {
    }

    class KeyRef
    extends WeakReference<FileObject> {
        private final KEY key;
        private final int hash;

        public KeyRef(FileObject fo, KEY key, ReferenceQueue<FileObject> queue) {
            super(fo, queue);
            this.key = key;
            this.hash = fo.hashCode();
            if (key != null) {
                Watcher.LOG.log(Level.FINE, "Adding watch for {0}", key);
            }
        }

        @Override
        public FileObject get() {
            return (FileObject)super.get();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            try {
                KeyRef kr = (KeyRef)obj;
                FileObject mine = this.get();
                FileObject theirs = kr.get();
                if (mine == null) {
                    return theirs == null;
                }
                return mine.equals(theirs);
            }
            catch (ClassCastException ex) {
                return false;
            }
        }

        final void removeWatch() throws IOException {
            Watcher.LOG.log(Level.FINE, "Removing watch for {0}", this.key);
            Notifier.this.removeWatch(this.key);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

