/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.zip.CRC32;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ant.AntBasedGenericType;
import org.netbeans.modules.project.ant.ProjectXMLCatalogReader;
import org.netbeans.spi.project.ProjectFactory2;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class AntBasedProjectFactorySingleton
implements ProjectFactory2 {
    public static final String PROJECT_XML_PATH = "nbproject/project.xml";
    public static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    public static final Logger LOG;
    private static final Map<Project, Reference<AntProjectHelper>> project2Helper;
    private static final Map<AntProjectHelper, Reference<Project>> helper2Project;
    private static final Map<AntBasedProjectType, List<Reference<AntProjectHelper>>> type2Projects;
    private static final Lookup.Result<AntBasedProjectType> antBasedProjectTypes;
    private static Map<String, AntBasedProjectType> antBasedProjectTypesByType;
    public static AntProjectHelperCallback HELPER_CALLBACK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void antBasedProjectTypesRemoved(Set<AntBasedProjectType> removed) {
        ArrayList<AntProjectHelper> helpers = new ArrayList<AntProjectHelper>();
        Class<AntBasedProjectFactorySingleton> clazz = AntBasedProjectFactorySingleton.class;
        synchronized (AntBasedProjectFactorySingleton.class) {
            for (AntBasedProjectType type : removed) {
                List<Reference<AntProjectHelper>> projects = type2Projects.get(type);
                if (projects != null) {
                    for (Reference<AntProjectHelper> r : projects) {
                        AntProjectHelper helper = r.get();
                        if (helper == null) continue;
                        helpers.add(helper);
                    }
                }
                type2Projects.remove(type);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (AntProjectHelper helper : helpers) {
                helper.notifyDeleted();
            }
            return;
        }
    }

    private static synchronized AntBasedProjectType findAntBasedProjectType(String type) {
        if (antBasedProjectTypesByType == null) {
            antBasedProjectTypesByType = new HashMap<String, AntBasedProjectType>();
            for (AntBasedProjectType abpt : antBasedProjectTypes.allInstances()) {
                antBasedProjectTypesByType.put(abpt.getType(), abpt);
            }
        }
        return antBasedProjectTypesByType.get(type);
    }

    public boolean isProject(FileObject dir) {
        File dirF = FileUtil.toFile((FileObject)dir);
        if (dirF == null) {
            return false;
        }
        File projectXmlF = new File(new File(dirF, "nbproject"), "project.xml");
        return projectXmlF.isFile();
    }

    public ProjectManager.Result isProject2(FileObject projectDirectory) {
        if (FileUtil.toFile((FileObject)projectDirectory) == null) {
            return null;
        }
        FileObject projectFile = projectDirectory.getFileObject(PROJECT_XML_PATH);
        if (projectFile == null || !projectFile.isData() || projectFile.isVirtual()) {
            return null;
        }
        File projectDiskFile = FileUtil.toFile((FileObject)projectFile);
        if (projectDiskFile == null) {
            return null;
        }
        try {
            AntBasedProjectType provider;
            String type;
            Element typeEl;
            Document projectXml = this.loadProjectXml(projectDiskFile);
            if (projectXml != null && (typeEl = XMLUtil.findElement((Element)projectXml.getDocumentElement(), (String)"type", (String)PROJECT_NS)) != null && (type = XMLUtil.findText((Node)typeEl)) != null && (provider = AntBasedProjectFactorySingleton.findAntBasedProjectType(type)) != null) {
                if (provider instanceof AntBasedGenericType) {
                    return new ProjectManager.Result(((AntBasedGenericType)provider).getIcon());
                }
                return new ProjectManager.Result(null);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(AntBasedProjectFactorySingleton.class.getName()).log(Level.FINE, "Failed to load the project.xml file.", ex);
        }
        return new ProjectManager.Result(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project loadProject(FileObject projectDirectory, ProjectState state) throws IOException {
        if (FileUtil.toFile((FileObject)projectDirectory) == null) {
            LOG.log(Level.FINER, "no disk dir {0}", projectDirectory);
            return null;
        }
        FileObject projectFile = projectDirectory.getFileObject(PROJECT_XML_PATH);
        if (projectFile == null) {
            LOG.log(Level.FINER, "no {0}/nbproject/project.xml", projectDirectory);
            return null;
        }
        if (!projectFile.isData() || projectFile.isVirtual()) {
            LOG.log(Level.FINE, "not concrete data file {0}/nbproject/project.xml", projectDirectory);
            return null;
        }
        File projectDiskFile = FileUtil.toFile((FileObject)projectFile);
        if (projectDiskFile == null) {
            LOG.log(Level.FINE, "{0} not mappable to file", projectFile);
            return null;
        }
        Document projectXml = this.loadProjectXml(projectDiskFile);
        if (projectXml == null) {
            LOG.log(Level.FINE, "could not load {0}", projectDiskFile);
            return null;
        }
        Element typeEl = XMLUtil.findElement((Element)projectXml.getDocumentElement(), (String)"type", (String)PROJECT_NS);
        if (typeEl == null) {
            LOG.log(Level.FINE, "no <type> in {0}", projectDiskFile);
            return null;
        }
        String type = XMLUtil.findText((Node)typeEl);
        if (type == null) {
            LOG.log(Level.FINE, "no <type> text in {0}", projectDiskFile);
            return null;
        }
        AntBasedProjectType provider = AntBasedProjectFactorySingleton.findAntBasedProjectType(type);
        if (provider == null) {
            LOG.log(Level.FINE, "no provider for {0}", type);
            return null;
        }
        AntProjectHelper helper = HELPER_CALLBACK.createHelper(projectDirectory, projectXml, state, provider);
        Project project = provider.createProject(helper);
        project2Helper.put(project, new WeakReference<AntProjectHelper>(helper));
        Object object = helper2Project;
        synchronized (object) {
            helper2Project.put(helper, new WeakReference<Project>(project));
        }
        object = AntBasedProjectFactorySingleton.class;
        synchronized (AntBasedProjectFactorySingleton.class) {
            List<Reference<AntProjectHelper>> l = type2Projects.get(provider);
            if (l == null) {
                l = new ArrayList<Reference<AntProjectHelper>>();
                type2Projects.put(provider, l);
            }
            l.add(new WeakReference<AntProjectHelper>(helper));
            // ** MonitorExit[var11_11] (shouldn't be in output)
            return project;
        }
    }

    private void print(StringBuilder b, Object o) {
        if (o == null) {
            b.append("null");
        } else {
            Class<?> t = o.getClass();
            if (t.isArray()) {
                Object[] arr = o instanceof Object[] ? (Object[])o : Utilities.toObjectArray((Object)o);
                b.append('[');
                for (int i = 0; i < arr.length; ++i) {
                    if (i > 0) {
                        b.append(", ");
                        if (i == 25) {
                            b.append("...").append(arr.length - 25).append(" more");
                            break;
                        }
                    }
                    this.print(b, arr[i]);
                }
                b.append(']');
            } else if (t.getName().contains("xerces")) {
                b.append(t.getName()).append('@').append(System.identityHashCode(o));
            } else if (o instanceof String) {
                b.append('\"').append(((String)o).replace("\n", "\\n")).append('\"');
            } else {
                b.append(o);
            }
        }
    }

    private void dumpFields(Object o) {
        if (LOG.isLoggable(Level.FINE)) {
            Class<?> implClass = o.getClass();
            StringBuilder b = new StringBuilder("Fields of a(n) ").append(implClass.getName());
            try {
                for (Class<?> c = implClass; c != null; c = c.getSuperclass()) {
                    for (Field f : c.getDeclaredFields()) {
                        if ((f.getModifiers() & 8) > 0) continue;
                        f.setAccessible(true);
                        b.append('\n').append(c.getName()).append('.').append(f.getName()).append('=');
                        this.print(b, f.get(o));
                    }
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            LOG.fine(b.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadProjectXml(File projectDiskFile) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream is = new FileInputStream(projectDiskFile);
        try {
            FileUtil.copy((InputStream)is, (OutputStream)baos);
        }
        finally {
            ((InputStream)is).close();
        }
        byte[] data = baos.toByteArray();
        InputSource src = new InputSource(new ByteArrayInputStream(data));
        src.setSystemId(projectDiskFile.toURI().toString());
        try {
            Document projectXml;
            block22: {
                DocumentBuilder builder;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                try {
                    builder = factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException x) {
                    throw new SAXException(x);
                }
                builder.setErrorHandler(XMLUtil.defaultErrorHandler());
                projectXml = builder.parse(src);
                LOG.finer("parsed document");
                Element projectEl = projectXml.getDocumentElement();
                LOG.finer("got document element");
                String namespace = projectEl.getNamespaceURI();
                LOG.log(Level.FINER, "got namespace {0}", namespace);
                if (!PROJECT_NS.equals(namespace)) {
                    LOG.log(Level.FINE, "{0} had wrong root element namespace {1} when parsed from {2}", new Object[]{projectDiskFile, namespace, baos});
                    this.dumpFields(projectXml);
                    this.dumpFields(projectEl);
                    return null;
                }
                if (!"project".equals(projectEl.getLocalName())) {
                    LOG.log(Level.FINE, "{0} had wrong root element name {1} when parsed from {2}", new Object[]{projectDiskFile, projectEl.getLocalName(), baos});
                    return null;
                }
                Preferences prefs = NbPreferences.forModule(AntBasedProjectFactorySingleton.class);
                String key = "knownValidProjectXmlCRC32s";
                ArrayList<Long> knownHashes = new ArrayList<Long>();
                String knownHashesS = prefs.get(key, null);
                if (knownHashesS != null) {
                    for (String knownHash : knownHashesS.split(",")) {
                        try {
                            knownHashes.add(Long.valueOf(knownHash, 16));
                        }
                        catch (NumberFormatException x) {
                            // empty catch block
                        }
                    }
                }
                CRC32 crc = new CRC32();
                crc.update(data);
                long hash = crc.getValue();
                if (!knownHashes.contains(hash)) {
                    Logger.getLogger(AntBasedProjectFactorySingleton.class.getName()).log(Level.FINE, "Validating: {0}", projectDiskFile);
                    try {
                        ProjectXMLCatalogReader.validate(projectEl);
                        StringBuilder newKnownHashes = new StringBuilder(Long.toString(hash, 16));
                        for (int i = 0; i < knownHashes.size() && i < 100; ++i) {
                            newKnownHashes.append(',');
                            newKnownHashes.append(Long.toString((Long)knownHashes.get(i), 16));
                        }
                        prefs.put(key, newKnownHashes.toString());
                    }
                    catch (SAXException x) {
                        Element corrected = ProjectXMLCatalogReader.autocorrect(projectEl, x);
                        if (corrected != null) {
                            projectXml.replaceChild(corrected, projectEl);
                            if (!projectDiskFile.canWrite()) break block22;
                            FileOutputStream os = new FileOutputStream(projectDiskFile);
                            try {
                                XMLUtil.write((Document)projectXml, (OutputStream)os, (String)"UTF-8");
                            }
                            finally {
                                ((OutputStream)os).close();
                            }
                        }
                        throw x;
                    }
                }
            }
            return projectXml;
        }
        catch (SAXException e) {
            IOException ioe = new IOException(projectDiskFile + ": " + e, e);
            String msg = e.getMessage().replaceFirst("^cvc-[^:]+: ", "").replaceAll("http://www.netbeans.org/ns/", ".../");
            Exceptions.attachLocalizedMessage((Throwable)ioe, (String)NbBundle.getMessage(AntBasedProjectFactorySingleton.class, (String)"AntBasedProjectFactorySingleton.parseError", (Object)projectDiskFile.getName(), (Object)msg));
            throw ioe;
        }
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
        Reference<AntProjectHelper> helperRef = project2Helper.get(project);
        if (helperRef == null) {
            StringBuilder sBuff = new StringBuilder("#191029: no project helper for a ");
            sBuff.append(project.getClass().getName()).append('\n');
            sBuff.append("argument project: ").append(project).append(" => ").append(project.hashCode()).append('\n');
            sBuff.append("project2Helper keys: \n");
            for (Project prj : project2Helper.keySet()) {
                sBuff.append("    project: ").append(prj).append(" => ").append(prj.hashCode()).append('\n');
            }
            LOG.warning(sBuff.toString());
            return;
        }
        AntProjectHelper helper = helperRef.get();
        assert (helper != null) : "AntProjectHelper collected for " + project;
        HELPER_CALLBACK.save(helper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Project getProjectFor(AntProjectHelper helper) {
        Reference<Project> projectRef;
        Map<AntProjectHelper, Reference<Project>> map = helper2Project;
        synchronized (map) {
            projectRef = helper2Project.get(helper);
        }
        assert (projectRef != null) : "Expecting a Project reference for " + helper;
        Project p = projectRef.get();
        assert (p != null) : "Expecting a non-null Project for " + helper;
        return p;
    }

    public static AntProjectHelper getHelperFor(Project p) {
        Reference<AntProjectHelper> helperRef = project2Helper.get(p);
        if (helperRef == null && (p = (Project)p.getLookup().lookup(Project.class)) != null) {
            helperRef = project2Helper.get(p);
        }
        return helperRef != null ? helperRef.get() : null;
    }

    public static AntBasedProjectType create(Map<?, ?> map) {
        return new AntBasedGenericType(map);
    }

    static {
        block3: {
            LOG = Logger.getLogger(AntBasedProjectFactorySingleton.class.getName());
            project2Helper = new WeakHashMap<Project, Reference<AntProjectHelper>>();
            helper2Project = new WeakHashMap<AntProjectHelper, Reference<Project>>();
            type2Projects = new HashMap<AntBasedProjectType, List<Reference<AntProjectHelper>>>();
            antBasedProjectTypesByType = null;
            antBasedProjectTypes = Lookup.getDefault().lookupResult(AntBasedProjectType.class);
            antBasedProjectTypes.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent ev) {
                    Class<AntBasedProjectFactorySingleton> clazz = AntBasedProjectFactorySingleton.class;
                    synchronized (AntBasedProjectFactorySingleton.class) {
                        Set oldTypes = type2Projects.keySet();
                        HashSet removed = new HashSet(oldTypes);
                        removed.removeAll(antBasedProjectTypes.allInstances());
                        antBasedProjectTypesByType = null;
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        AntBasedProjectFactorySingleton.antBasedProjectTypesRemoved(removed);
                        return;
                    }
                }
            });
            Class<AntProjectHelper> c = AntProjectHelper.class;
            try {
                Class.forName(c.getName(), true, c.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)e);
            }
        }
        assert (HELPER_CALLBACK != null);
    }

    public static interface AntProjectHelperCallback {
        public AntProjectHelper createHelper(FileObject var1, Document var2, ProjectState var3, AntBasedProjectType var4);

        public void save(AntProjectHelper var1) throws IOException;
    }
}

