/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.parsing.impl.indexing.Pair;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class LogContext {
    private static final RequestProcessor RP = new RequestProcessor("Thread dump shooter", 1);
    private static final int SECOND_DUMP_DELAY = 5000;
    private final long timestamp;
    private long executed;
    private final EventType eventType;
    private final String message;
    private final StackTraceElement[] stackTrace;
    private final LogContext parent;
    private Queue<LogContext> absorbed;
    private String threadDump;
    private String secondDump;
    private Set<String> filePathsChanged = Collections.emptySet();
    private Set<ClassPath> classPathsChanged = Collections.emptySet();
    private Set<URL> rootsChanged = Collections.emptySet();
    private Set<URL> filesChanged = Collections.emptySet();
    private Set<FileObject> fileObjsChanged = Collections.emptySet();
    private List<URL> scannedSourceRoots = new LinkedList<URL>();
    private long totalScanningTime;
    private URL currentSourceRoot;
    private long currentRootStartTime;
    private URL root;
    private Map<String, Long> totalIndexerTime = new HashMap<String, Long>();
    private static final Logger LOG = Logger.getLogger(LogContext.class.getName());
    private static final String LOG_MESSAGE = "SCAN_CANCELLED";
    private static final String LOG_EXCEEDS_RATE = "SCAN_EXCEEDS_RATE {0}";
    private static final Stats STATS = new Stats();

    public static LogContext create(@NonNull EventType eventType, @NullAllowed String message) {
        return LogContext.create(eventType, message, null);
    }

    public static LogContext create(@NonNull EventType eventType, @NullAllowed String message, @NullAllowed LogContext parent) {
        return new LogContext(eventType, Thread.currentThread().getStackTrace(), message, parent);
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        this.createLogMessage(msg);
        return msg.toString();
    }

    private String createThreadDump() {
        StringBuilder sb = new StringBuilder();
        Map<Thread, StackTraceElement[]> allTraces = Thread.getAllStackTraces();
        for (Thread t : allTraces.keySet()) {
            StackTraceElement[] elems;
            sb.append(String.format("Thread id %d, \"%s\" (%s):\n", new Object[]{t.getId(), t.getName(), t.getState()}));
            for (StackTraceElement l : elems = allTraces.get(t)) {
                sb.append("\t").append(l).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    void log() {
        this.log(true);
    }

    void log(boolean cancel) {
        final LogRecord r = new LogRecord(Level.INFO, cancel ? LOG_MESSAGE : LOG_EXCEEDS_RATE);
        r.setParameters(new Object[]{this});
        r.setResourceBundle(NbBundle.getBundle(LogContext.class));
        r.setResourceBundleName(LogContext.class.getPackage().getName() + ".Bundle");
        r.setLoggerName(LOG.getName());
        Exception e = new Exception(cancel ? "Scan canceled." : "Scan exceeded rate");
        if (cancel) {
            e.setStackTrace(this.stackTrace);
            r.setThrown(e);
        }
        if (cancel) {
            this.threadDump = this.createThreadDump();
            RP.post(new Runnable(){

                @Override
                public void run() {
                    LogContext.this.secondDump = LogContext.this.createThreadDump();
                    LOG.log(r);
                }
            }, 5000);
        } else {
            LOG.log(r);
        }
    }

    synchronized void absorb(@NonNull LogContext other) {
        Parameters.notNull((CharSequence)"other", (Object)other);
        if (this.absorbed == null) {
            this.absorbed = new ArrayDeque<LogContext>();
        }
        this.absorbed.add(other);
    }

    void recordExecuted() {
        this.executed = System.currentTimeMillis();
        STATS.record(this);
    }

    public synchronized void noteRootScanning(URL currentRoot) {
        assert (this.currentSourceRoot == null);
        this.currentRootStartTime = System.currentTimeMillis();
        this.currentSourceRoot = currentRoot;
    }

    public synchronized void finishScannedRoot(URL scannedRoot) {
        if (!scannedRoot.equals(this.currentSourceRoot)) {
            return;
        }
        long time = System.currentTimeMillis();
        this.totalScanningTime += time - this.currentRootStartTime;
        this.scannedSourceRoots.add(scannedRoot);
        this.currentSourceRoot = null;
    }

    public synchronized void addIndexerTime(String fName, long addTime) {
        Long t = this.totalIndexerTime.get(fName);
        if (t == null) {
            t = 0L;
        }
        this.totalIndexerTime.put(fName, t + addTime);
    }

    public synchronized LogContext withRoot(URL root) {
        this.root = root;
        return this;
    }

    public synchronized LogContext addPaths(Collection<? extends ClassPath> paths) {
        if (paths == null || paths.isEmpty()) {
            return this;
        }
        if (this.classPathsChanged.isEmpty()) {
            this.classPathsChanged = new HashSet<ClassPath>(paths.size());
        }
        this.classPathsChanged.addAll(paths);
        return this;
    }

    public synchronized LogContext addFilePaths(Collection<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return this;
        }
        if (this.filePathsChanged.isEmpty()) {
            this.filePathsChanged = new HashSet<String>(paths.size());
        }
        this.filePathsChanged.addAll(paths);
        return this;
    }

    public synchronized LogContext addRoots(Iterable<? extends URL> roots) {
        if (roots == null) {
            return this;
        }
        Iterator<? extends URL> it = roots.iterator();
        if (!it.hasNext()) {
            return this;
        }
        if (this.rootsChanged.isEmpty()) {
            this.rootsChanged = new HashSet<URL>(11);
        }
        while (it.hasNext()) {
            this.rootsChanged.add(it.next());
        }
        return this;
    }

    public synchronized LogContext addFileObjects(Collection<FileObject> files) {
        if (files == null || files.isEmpty()) {
            return this;
        }
        if (this.fileObjsChanged.isEmpty()) {
            this.fileObjsChanged = new HashSet<FileObject>(files.size());
        }
        this.fileObjsChanged.addAll(files);
        return this;
    }

    public synchronized LogContext addFiles(Collection<? extends URL> files) {
        if (files == null || files.isEmpty()) {
            return this;
        }
        if (this.filesChanged.isEmpty()) {
            this.filesChanged = new HashSet<URL>(files.size());
        }
        this.filesChanged.addAll(files);
        return this;
    }

    private LogContext(@NonNull EventType eventType, @NonNull StackTraceElement[] stackTrace, @NullAllowed String message, @NullAllowed LogContext parent) {
        Parameters.notNull((CharSequence)"eventType", (Object)((Object)eventType));
        Parameters.notNull((CharSequence)"stackTrace", (Object)stackTrace);
        this.eventType = eventType;
        this.stackTrace = stackTrace;
        this.message = message;
        this.parent = parent;
        this.timestamp = System.currentTimeMillis();
    }

    private synchronized void createLogMessage(@NonNull StringBuilder sb) {
        sb.append("Type:").append((Object)this.eventType);
        if (this.message != null) {
            sb.append(" Description:").append(this.message);
        }
        sb.append("\nTime scheduled: ").append(new Date(this.timestamp));
        if (this.executed > 0L) {
            sb.append("\nTime executed: ").append(new Date(this.executed));
        } else {
            sb.append("\nNOT executed");
        }
        sb.append("\nScanned roots: ").append(this.scannedSourceRoots).append(", time: ").append(this.totalScanningTime);
        long t = System.currentTimeMillis();
        sb.append("\nCurrent root: ").append(this.currentSourceRoot).append(", time spent so far: ").append(t - this.currentRootStartTime);
        sb.append("\nTime spent in indexers:");
        ArrayList<String> iNames = new ArrayList<String>(this.totalIndexerTime.keySet());
        Collections.sort(iNames);
        for (Map.Entry<String, Long> indexTime : this.totalIndexerTime.entrySet()) {
            sb.append("\n\t").append(indexTime.getKey()).append(": ").append(indexTime.getValue());
        }
        sb.append("\nStacktrace:\n");
        for (StackTraceElement se : this.stackTrace) {
            sb.append('\t').append(se).append('\n');
        }
        if (this.root != null) {
            sb.append("On root: ").append(this.root).append("\n");
        }
        if (!this.rootsChanged.isEmpty()) {
            sb.append("Changed CP roots: ").append(this.rootsChanged).append("\n");
        }
        if (!this.classPathsChanged.isEmpty()) {
            sb.append("Changed ClassPaths:").append(this.classPathsChanged).append("\n");
        }
        if (!this.filesChanged.isEmpty()) {
            sb.append("Changed files(URL): ").append(this.filesChanged.toString().replace(",", "\n\t")).append("\n");
        }
        if (!this.fileObjsChanged.isEmpty()) {
            sb.append("Changed files(FO): ").append(this.fileObjsChanged.toString().replace(",", "\n\t")).append("\n");
        }
        if (!this.filePathsChanged.isEmpty()) {
            sb.append("Changed files(Str): ").append(this.filePathsChanged.toString().replace(",", "\n\t")).append("\n");
        }
        if (this.parent != null) {
            sb.append("Parent {");
            this.parent.createLogMessage(sb);
            sb.append("}\n");
        }
        if (this.threadDump != null) {
            sb.append("Thread dump:\n").append(this.threadDump).append("\n");
        }
        if (this.secondDump != null) {
            sb.append("Thread dump #2 (after ").append(5).append(" seconds):\n").append(this.secondDump).append("\n");
        }
        if (this.absorbed != null) {
            sb.append("Absorbed {");
            for (LogContext a : this.absorbed) {
                a.createLogMessage(sb);
            }
            sb.append("}\n");
        }
    }

    private static long fromMinutes(int mins) {
        return mins * 60 * 1000;
    }

    static class Stats {
        private Map<EventType, RingTimeBuffer> history = new HashMap<EventType, RingTimeBuffer>(7);
        private LinkedHashMap<URL, RingTimeBuffer> rootHistory = new LinkedHashMap(9, 0.7f, true);

        Stats() {
        }

        public synchronized void record(LogContext ctx) {
            EventType type = ctx.eventType;
            if (type == EventType.INDEXER && ctx.root != null) {
                this.recordIndexer(ctx.root, ctx);
            } else {
                this.recordRegular(type, ctx);
            }
        }

        private void expireRoots() {
            RingTimeBuffer rb;
            long l = System.currentTimeMillis();
            l -= LogContext.fromMinutes(EventType.INDEXER.getMinutes());
            Iterator<RingTimeBuffer> it = this.rootHistory.values().iterator();
            while (it.hasNext() && (rb = it.next()).lastTime < l) {
                it.remove();
            }
        }

        private void recordIndexer(URL root, LogContext ctx) {
            this.expireRoots();
            RingTimeBuffer existing = this.rootHistory.get(root);
            if (existing == null) {
                existing = new RingTimeBuffer(EventType.INDEXER.getMinutes() * 2);
                this.rootHistory.put(root, existing);
            }
            existing.mark(ctx);
        }

        private void recordRegular(EventType type, LogContext ctx) {
            RingTimeBuffer buf = this.history.get((Object)type);
            if (buf == null) {
                buf = new RingTimeBuffer(type.getMinutes() * 2);
                this.history.put(type, buf);
            }
            buf.mark(ctx);
        }
    }

    private static class RingTimeBuffer {
        private static final int INITIAL_RINGBUFFER_SIZE = 20;
        private int historyLimit;
        private long[] times = new long[20];
        private LogContext[] contexts = new LogContext[20];
        private int start;
        private int limit;
        private int reportedEnd = -1;
        private long lastTime;

        public RingTimeBuffer(int historyLimit) {
            this.historyLimit = historyLimit;
        }

        private void updateStart(long now) {
            long from = now - LogContext.fromMinutes(this.historyLimit);
            while (!this.isEmpty() && this.times[this.start] < from) {
                this.contexts[this.start] = null;
                if (this.reportedEnd == this.start) {
                    this.reportedEnd = -1;
                }
                this.start = this.inc(this.start);
            }
        }

        private void ensureSpaceAvailable() {
            if (!this.isEmpty() && this.gapSize() == 0) {
                int l;
                long[] times2 = new long[this.times.length * 2];
                LogContext[] contexts2 = new LogContext[this.times.length * 2];
                if (this.limit >= this.start) {
                    System.arraycopy(this.times, this.start, times2, 0, this.limit - this.start);
                    System.arraycopy(this.contexts, this.start, contexts2, 0, this.limit - this.start);
                    l = this.limit - this.start;
                } else {
                    System.arraycopy(this.times, this.start, times2, 0, this.times.length - this.start);
                    System.arraycopy(this.times, 0, times2, this.times.length - this.start, this.limit);
                    System.arraycopy(this.contexts, this.start, contexts2, 0, this.times.length - this.start);
                    System.arraycopy(this.contexts, 0, contexts2, this.times.length - this.start, this.limit);
                    l = this.limit + (this.times.length - this.start);
                }
                this.limit = l;
                this.start = 0;
                this.times = times2;
                this.contexts = contexts2;
            }
        }

        public void mark(LogContext ctx) {
            long l = System.currentTimeMillis();
            this.updateStart(l);
            this.ensureSpaceAvailable();
            this.times[this.limit] = l;
            this.contexts[this.limit] = ctx;
            this.limit = this.inc(this.limit);
            EventType type = ctx.eventType;
            this.checkAndReport(l, type.getMinutes(), type.getTreshold());
            this.lastTime = l;
        }

        private int inc(int i) {
            return (i + 1) % this.ringSize();
        }

        private int ringSize() {
            return this.times.length;
        }

        private boolean isEmpty() {
            return this.start == this.limit;
        }

        private int gapSize() {
            if (this.start > this.limit) {
                return this.start - this.limit;
            }
            return this.start + this.ringSize() - this.limit;
        }

        private int dataSize(int start, int end) {
            if (start < end) {
                return end - start;
            }
            return end + this.ringSize() - start;
        }

        private Pair<Integer, Integer> findHigherRate(long minTime, int minutes, int treshold) {
            int s = this.start;
            int l = -1;
            while (s != this.limit && this.times[s] < minTime) {
                if ((s = this.inc(s)) != l) continue;
                l = -1;
            }
            long minDiff = LogContext.fromMinutes(minutes);
            do {
                if (s == this.limit) {
                    return null;
                }
                if (l == -1) {
                    l = s;
                }
                long t = this.times[s];
                while (l != this.limit && this.times[l] - t < minDiff) {
                    l = this.inc(l);
                }
                if (this.dataSize(s, l) > treshold) {
                    return Pair.of(s, l);
                }
                this.start = s = this.inc(s);
            } while (l != this.limit);
            return null;
        }

        void checkAndReport(long now, int minutes, int treshold) {
            long minTime = now - LogContext.fromMinutes(this.historyLimit);
            Pair<Integer, Integer> found = this.findHigherRate(minTime, minutes, treshold);
            if (found == null) {
                return;
            }
            LOG.log(Level.WARNING, "Excessive indexing rate detected. Dumping suspicious contexts");
            int index = (Integer)found.first;
            while (index != (Integer)found.second) {
                this.contexts[index].log(false);
                index = (index + 1) % this.times.length;
            }
            this.reportedEnd = index;
        }
    }

    public static enum EventType {
        PATH(1, 10),
        FILE(2, 20),
        INDEXER(2, 5),
        MANAGER(1, 10),
        UI(1, 4);

        private int treshold;
        private int minutes;

        private EventType(int minutes, int treshold) {
            String prefix = EventType.class.getName() + "." + this.name();
            Integer m = Integer.getInteger(prefix + ".minutes", minutes);
            Integer t = Integer.getInteger(prefix + ".treshold", treshold);
            this.minutes = m;
            this.treshold = t;
        }

        public int getTreshold() {
            return this.treshold;
        }

        public int getMinutes() {
            return this.minutes;
        }
    }
}

