/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.AccessibilityQuery;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.project.PackageDisplayUtils;
import org.netbeans.spi.java.project.support.ui.PackageRootNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class TreeRootNode
extends FilterNode
implements PropertyChangeListener {
    private final SourceGroup g;

    public TreeRootNode(SourceGroup g) {
        this(DataFolder.findFolder((FileObject)g.getRootFolder()), g);
    }

    private TreeRootNode(DataFolder folder, SourceGroup g) {
        this((Node)new FilterNode(folder.getNodeDelegate(), folder.createNodeChildren((DataFilter)new GroupDataFilter(g))), g);
    }

    private TreeRootNode(Node originalNode, SourceGroup g) {
        super(originalNode, (Children)new PackageFilterChildren(originalNode), (Lookup)new ProxyLookup(new Lookup[]{originalNode.getLookup(), Lookups.singleton((Object)new PathFinder(g))}));
        this.g = g;
        g.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)g));
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = this.g.getIcon(opened);
        if (icon == null) {
            Image image = opened ? super.getOpenedIcon(type) : super.getIcon(type);
            return ImageUtilities.mergeImages((Image)image, (Image)PackageRootNode.PACKAGE_BADGE, (int)7, (int)7);
        }
        return ImageUtilities.icon2Image((Icon)icon);
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    public String getName() {
        return this.g.getName();
    }

    public String getDisplayName() {
        return this.g.getDisplayName();
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeRootNode.this.fireNameChange(null, null);
                TreeRootNode.this.fireDisplayNameChange(null, null);
                TreeRootNode.this.fireIconChange();
                TreeRootNode.this.fireOpenedIconChange();
            }
        });
    }

    private static final class PackageFilterNode
    extends FilterNode {
        private static final String PUBLIC_PACKAGE_BADGE = "org/netbeans/spi/java/project/support/ui/publicBadge.gif";
        private static final String PRIVATE_PACKAGE_BADGE = "org/netbeans/spi/java/project/support/ui/privateBadge.gif";
        private static Image unlockBadge;
        private static Image lockBadge;

        public PackageFilterNode(Node origNode) {
            super(origNode, (Children)new PackageFilterChildren(origNode));
        }

        public void setName(String name) {
            if (Utilities.isJavaIdentifier((String)name)) {
                super.setName(name);
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(TreeRootNode.class, (String)"MSG_InvalidPackageName"), 1));
            }
        }

        public Image getIcon(int type) {
            return this.accessibility(super.getIcon(type));
        }

        public Image getOpenedIcon(int type) {
            return this.accessibility(super.getOpenedIcon(type));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Image accessibility(Image icon) {
            if (icon == null) {
                return icon;
            }
            DataObject dobj = (DataObject)this.getLookup().lookup(DataObject.class);
            if (dobj == null) {
                return icon;
            }
            FileObject fo = dobj.getPrimaryFile();
            if (fo == null) {
                return icon;
            }
            Boolean pub = AccessibilityQuery.isPubliclyAccessible((FileObject)fo);
            if (pub == Boolean.TRUE) {
                Class<PackageFilterNode> clazz = PackageFilterNode.class;
                synchronized (PackageFilterNode.class) {
                    if (unlockBadge == null) {
                        unlockBadge = ImageUtilities.loadImage((String)PUBLIC_PACKAGE_BADGE);
                    }
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return ImageUtilities.mergeImages((Image)icon, (Image)unlockBadge, (int)0, (int)0);
                }
            }
            if (pub == Boolean.FALSE) {
                Class<PackageFilterNode> clazz = PackageFilterNode.class;
                synchronized (PackageFilterNode.class) {
                    if (lockBadge == null) {
                        lockBadge = ImageUtilities.loadImage((String)PRIVATE_PACKAGE_BADGE);
                    }
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return ImageUtilities.mergeImages((Image)icon, (Image)lockBadge, (int)0, (int)0);
                }
            }
            return icon;
        }

        public String getShortDescription() {
            String pkg;
            FileObject f;
            ClassPath src;
            DataObject doj = (DataObject)this.getLookup().lookup(DataObject.class);
            if (doj != null && (src = ClassPath.getClassPath((FileObject)(f = doj.getPrimaryFile()), (String)"classpath/source")) != null && (pkg = src.getResourceName(f, '.', false)) != null) {
                return PackageDisplayUtils.getToolTip(f, pkg);
            }
            return super.getShortDescription();
        }
    }

    private static final class PackageFilterChildren
    extends FilterNode.Children {
        public PackageFilterChildren(Node originalNode) {
            super(originalNode);
        }

        protected Node copyNode(Node originalNode) {
            FileObject fobj = (FileObject)originalNode.getLookup().lookup(FileObject.class);
            return fobj.isFolder() ? new PackageFilterNode(originalNode) : super.copyNode(originalNode);
        }
    }

    private static final class GroupDataFilter
    implements ChangeListener,
    PropertyChangeListener,
    ChangeableDataFilter,
    DataFilter.FileBased {
        private static final long serialVersionUID = 1L;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final SourceGroup g;

        public GroupDataFilter(SourceGroup g) {
            this.g = g;
            VisibilityQuery.getDefault().addChangeListener(WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault()));
            g.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)g));
        }

        public boolean acceptDataObject(DataObject obj) {
            return this.acceptFileObject(obj.getPrimaryFile());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.cs.fireChange();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("containership".equals(e.getPropertyName())) {
                this.cs.fireChange();
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        public boolean acceptFileObject(FileObject fo) {
            return fo.isValid() && this.g.contains(fo) && VisibilityQuery.getDefault().isVisible(fo);
        }
    }

    public static final class PathFinder {
        private final SourceGroup g;

        PathFinder(SourceGroup g) {
            this.g = g;
        }

        public Node findPath(Node rootNode, Object o) {
            FileObject fo;
            if (o instanceof FileObject) {
                fo = (FileObject)o;
            } else if (o instanceof DataObject) {
                fo = ((DataObject)o).getPrimaryFile();
            } else {
                return null;
            }
            FileObject groupRoot = this.g.getRootFolder();
            if (FileUtil.isParentOf((FileObject)groupRoot, (FileObject)fo)) {
                FileObject folder = fo.isFolder() ? fo : fo.getParent();
                String relPath = FileUtil.getRelativePath((FileObject)groupRoot, (FileObject)folder);
                ArrayList<String> path = new ArrayList<String>();
                StringTokenizer strtok = new StringTokenizer(relPath, "/");
                while (strtok.hasMoreTokens()) {
                    String token = strtok.nextToken();
                    path.add(token);
                }
                try {
                    Node folderNode;
                    Node node = folderNode = folder.equals(groupRoot) ? rootNode : NodeOp.findPath((Node)rootNode, Collections.enumeration(path));
                    if (fo.isFolder()) {
                        return folderNode;
                    }
                    Node[] childs = folderNode.getChildren().getNodes(true);
                    for (int i = 0; i < childs.length; ++i) {
                        DataObject dobj = (DataObject)childs[i].getLookup().lookup(DataObject.class);
                        if (dobj == null || !dobj.getPrimaryFile().getNameExt().equals(fo.getNameExt())) continue;
                        return childs[i];
                    }
                }
                catch (NodeNotFoundException e) {
                    e.printStackTrace();
                }
            } else if (groupRoot.equals(fo)) {
                return rootNode;
            }
            return null;
        }
    }
}

