/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.doxia.module.rtf;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class PBMReader {
    public static final int TYPE_PBM = 1;
    public static final int TYPE_PGM = 2;
    public static final int TYPE_PPM = 3;
    private static final boolean TRACE = false;
    private static final String BAD_FILE_FORMAT = "bad file format";
    private static final String UNSUPPORTED_TYPE = "unsupported file type";
    private static final String UNSUPPORTED_FORMAT = "unsupported data format";
    private static final String UNSUPPORTED_DEPTH = "unsupported color depth";
    private int type;
    private boolean binary;
    private int width;
    private int height;
    private int maxValue;
    private int bytesPerLine;
    private InputStream stream;

    public PBMReader(String fileName) throws Exception {
        HeaderReader header = new HeaderReader();
        int length = header.read(fileName);
        if (this.type != 3) {
            throw new Exception(UNSUPPORTED_TYPE);
        }
        if (!this.binary) {
            throw new Exception(UNSUPPORTED_FORMAT);
        }
        if (this.maxValue > 255) {
            throw new Exception(UNSUPPORTED_DEPTH);
        }
        switch (this.type) {
            case 1: {
                this.bytesPerLine = (this.width + 7) / 8;
                break;
            }
            case 2: {
                this.bytesPerLine = this.width;
                break;
            }
            case 3: {
                this.bytesPerLine = 3 * this.width;
            }
        }
        this.stream = new BufferedInputStream(new FileInputStream(fileName));
        this.skip(length);
    }

    public int type() {
        return this.type;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int maxValue() {
        return this.maxValue;
    }

    public int bytesPerLine() {
        return this.bytesPerLine;
    }

    public long skip(long count) throws IOException {
        long skipped = this.stream.skip(count);
        if (skipped < count) {
            int len;
            int n;
            byte[] b = new byte[512];
            while (skipped < count && (n = this.stream.read(b, 0, len = (int)Math.min((long)b.length, count - skipped))) >= 0) {
                skipped += (long)n;
            }
        }
        return skipped;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count;
        int n;
        for (count = 0; count < len && (n = this.stream.read(b, off + count, len - count)) >= 0; count += n) {
        }
        return count;
    }

    public static void main(String[] args) throws Exception {
        PBMReader pbm = new PBMReader(args[0]);
    }

    private class HeaderReader {
        private Reader reader;
        private int offset;

        private HeaderReader() {
        }

        int read(String fileName) throws Exception {
            this.reader = new BufferedReader(new FileReader(fileName));
            this.offset = 0;
            String field = this.getField();
            if (field.length() != 2 || field.charAt(0) != 'P') {
                this.reader.close();
                throw new Exception(PBMReader.BAD_FILE_FORMAT);
            }
            switch (field.charAt(1)) {
                case '1': 
                case '4': {
                    PBMReader.this.type = 1;
                    break;
                }
                case '2': 
                case '5': {
                    PBMReader.this.type = 2;
                    break;
                }
                case '3': 
                case '6': {
                    PBMReader.this.type = 3;
                    break;
                }
                default: {
                    this.reader.close();
                    throw new Exception(PBMReader.BAD_FILE_FORMAT);
                }
            }
            if (field.charAt(1) > '3') {
                PBMReader.this.binary = true;
            } else {
                PBMReader.this.binary = false;
            }
            try {
                PBMReader.this.width = Integer.parseInt(this.getField());
                PBMReader.this.height = Integer.parseInt(this.getField());
                if (PBMReader.this.type == 1) {
                    PBMReader.this.maxValue = 1;
                } else {
                    PBMReader.this.maxValue = Integer.parseInt(this.getField());
                }
            }
            catch (NumberFormatException e) {
                this.reader.close();
                throw new Exception(PBMReader.BAD_FILE_FORMAT);
            }
            this.reader.close();
            return this.offset;
        }

        private String getField() throws IOException {
            StringBuffer field = new StringBuffer();
            try {
                char c;
                while (true) {
                    if ((c = this.getChar()) == '#') {
                        this.skipComment();
                        continue;
                    }
                    if (!Character.isWhitespace(c)) break;
                }
                field.append(c);
                while (!Character.isWhitespace(c = this.getChar())) {
                    if (c == '#') {
                        this.skipComment();
                        break;
                    }
                    field.append(c);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return field.toString();
        }

        private char getChar() throws IOException, EOFException {
            int c = this.reader.read();
            if (c < 0) {
                throw new EOFException();
            }
            ++this.offset;
            return (char)c;
        }

        private void skipComment() throws IOException {
            try {
                while (this.getChar() != '\n') {
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
    }
}

