/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.util.Collection;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

public final class LibraryTypeRegistry {
    private static final String REGISTRY = "org-netbeans-api-project-libraries/LibraryTypeProviders";
    private static LibraryTypeRegistry instance;
    private final Lookup.Result<LibraryTypeProvider> result;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    private LibraryTypeRegistry() {
        Lookup lookup = Lookups.forPath((String)REGISTRY);
        assert (lookup != null);
        this.result = lookup.lookupResult(LibraryTypeProvider.class);
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                LibraryTypeRegistry.this.changeSupport.fireChange();
            }
        });
    }

    public LibraryTypeProvider[] getLibraryTypeProviders() {
        assert (this.result != null);
        Collection instances = this.result.allInstances();
        return instances.toArray(new LibraryTypeProvider[instances.size()]);
    }

    public LibraryTypeProvider getLibraryTypeProvider(String libraryType) {
        LibraryTypeProvider[] providers;
        assert (libraryType != null);
        for (LibraryTypeProvider provider : providers = this.getLibraryTypeProviders()) {
            if (!libraryType.equals(provider.getLibraryType())) continue;
            return provider;
        }
        return null;
    }

    public void addChangeListener(ChangeListener listener) {
        assert (listener != null);
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        assert (listener != null);
        this.changeSupport.removeChangeListener(listener);
    }

    public static synchronized LibraryTypeRegistry getDefault() {
        if (instance == null) {
            instance = new LibraryTypeRegistry();
        }
        return instance;
    }
}

