/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.Image;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.options.TabbedController;
import org.netbeans.spi.options.OptionsCategory;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class OptionsCategoryImpl
extends OptionsCategory {
    private String title;
    private String categoryName;
    private String iconBase;
    private ImageIcon icon;
    private Callable<OptionsPanelController> controller;
    private String keywords;
    private String keywordsCategory;
    private String advancedOptionsFolder;

    public OptionsCategoryImpl(String title, String categoryName, String iconBase, Callable<OptionsPanelController> controller, String keywords, String keywordsCategory, String advancedOptionsFolder) {
        this.title = title;
        this.categoryName = categoryName;
        this.iconBase = iconBase;
        this.controller = controller;
        this.advancedOptionsFolder = advancedOptionsFolder;
        this.keywords = keywords;
        this.keywordsCategory = keywordsCategory;
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null) {
            Image image = ImageUtilities.loadImage((String)this.iconBase);
            if (image != null) {
                return new ImageIcon(image);
            }
            image = ImageUtilities.loadImage((String)(this.iconBase + ".png"));
            if (image != null) {
                return new ImageIcon(image);
            }
            image = ImageUtilities.loadImage((String)(this.iconBase + ".gif"));
            if (image == null) {
                return null;
            }
            this.icon = new ImageIcon(image);
        }
        return this.icon;
    }

    @Override
    public String getCategoryName() {
        return this.categoryName;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public OptionsPanelController create() {
        if (this.advancedOptionsFolder != null) {
            return new TabbedController(this.advancedOptionsFolder);
        }
        try {
            return this.controller.call();
        }
        catch (Exception x) {
            Exceptions.printStackTrace((Throwable)x);
            return new TabbedController("<error>");
        }
    }

    final Map<String, Set<String>> getKeywordsByCategory() {
        if (this.keywordsCategory != null && this.keywords != null) {
            return Collections.singletonMap(this.keywordsCategory, new HashSet<String>(Arrays.asList(this.keywords.split(","))));
        }
        return Collections.emptyMap();
    }
}

