/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.source.classpath.AptCacheForSourceQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManagerEvent;
import org.netbeans.modules.java.source.usages.ClassIndexManagerListener;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.java.source.usages.PersistentClassIndex;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.openide.util.Exceptions;

public final class ClassIndexManager {
    public static final String PROP_SOURCE_ROOT = "source";
    private static final byte OP_ADD = 1;
    private static final byte OP_REMOVE = 2;
    private static ClassIndexManager instance;
    private final Map<URL, ClassIndexImpl> instances = new HashMap<URL, ClassIndexImpl>();
    private final Map<URL, ClassIndexImpl> transientInstances = new HashMap<URL, ClassIndexImpl>();
    private final InternalLock internalLock;
    private final Map<ClassIndexManagerListener, Void> listeners = Collections.synchronizedMap(new IdentityHashMap());
    private boolean invalid;
    private Set<URL> added;
    private Set<URL> removed;
    private int depth = 0;

    private ClassIndexManager() {
        this.internalLock = new InternalLock();
    }

    public void addClassIndexManagerListener(ClassIndexManagerListener listener) {
        assert (listener != null);
        this.listeners.put(listener, null);
    }

    public void removeClassIndexManagerListener(ClassIndexManagerListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    @Deprecated
    public <T> T writeLock(final IndexManager.Action<T> r) throws IOException, InterruptedException {
        return this.prepareWriteLock(new IndexManager.Action<T>(){

            public T run() throws IOException, InterruptedException {
                return IndexManager.writeAccess((IndexManager.Action)r);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T prepareWriteLock(IndexManager.Action<T> r) throws IOException, InterruptedException {
        Object object = this.internalLock;
        synchronized (object) {
            ++this.depth;
            if (this.depth == 1) {
                this.added = new HashSet<URL>();
                this.removed = new HashSet<URL>();
            }
        }
        try {
            InternalLock internalLock;
            HashSet<URL> removedCp;
            HashSet<URL> addedCp;
            try {
                object = r.run();
                addedCp = null;
                removedCp = null;
                internalLock = this.internalLock;
            }
            catch (Throwable throwable) {
                HashSet<URL> addedCp2 = null;
                HashSet<URL> removedCp2 = null;
                InternalLock internalLock2 = this.internalLock;
                synchronized (internalLock2) {
                    if (this.depth == 1) {
                        if (!this.removed.isEmpty()) {
                            removedCp2 = new HashSet<URL>(this.removed);
                            this.removed.clear();
                        }
                        if (!this.added.isEmpty()) {
                            addedCp2 = new HashSet<URL>(this.added);
                            this.added.clear();
                        }
                    }
                }
                if (removedCp2 != null) {
                    this.fire(removedCp2, (byte)2);
                }
                if (addedCp2 != null) {
                    this.fire(addedCp2, (byte)1);
                }
                throw throwable;
            }
            synchronized (internalLock) {
                if (this.depth == 1) {
                    if (!this.removed.isEmpty()) {
                        removedCp = new HashSet<URL>(this.removed);
                        this.removed.clear();
                    }
                    if (!this.added.isEmpty()) {
                        addedCp = new HashSet<URL>(this.added);
                        this.added.clear();
                    }
                }
            }
            if (removedCp != null) {
                this.fire(removedCp, (byte)2);
            }
            if (addedCp != null) {
                this.fire(addedCp, (byte)1);
            }
            return (T)object;
        }
        finally {
            InternalLock internalLock = this.internalLock;
            synchronized (internalLock) {
                --this.depth;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public ClassIndexImpl getUsagesQuery(@NonNull URL root, boolean beforeCreateAllowed) {
        InternalLock internalLock = this.internalLock;
        synchronized (internalLock) {
            assert (root != null);
            if (this.invalid) {
                return null;
            }
            Pair<ClassIndexImpl, Boolean> pair = this.getClassIndex(root, beforeCreateAllowed, false);
            ClassIndexImpl index = (ClassIndexImpl)pair.first;
            if (index != null) {
                return index;
            }
            URL translatedRoot = AptCacheForSourceQuery.getSourceFolder(root);
            if (translatedRoot != null) {
                pair = this.getClassIndex(translatedRoot, beforeCreateAllowed, false);
                index = (ClassIndexImpl)pair.first;
                if (index != null) {
                    return index;
                }
            } else {
                translatedRoot = root;
            }
            if (beforeCreateAllowed) {
                String attr = null;
                try {
                    attr = JavaIndex.getAttribute(translatedRoot, PROP_SOURCE_ROOT, null);
                    if (Boolean.TRUE.toString().equals(attr)) {
                        index = PersistentClassIndex.create(root, JavaIndex.getIndex(root), true);
                        this.transientInstances.put(root, index);
                    } else if (Boolean.FALSE.toString().equals(attr)) {
                        index = PersistentClassIndex.create(root, JavaIndex.getIndex(root), false);
                        this.transientInstances.put(root, index);
                    }
                }
                catch (IOException ioe) {
                }
                catch (IllegalStateException ise) {
                    // empty catch block
                }
            }
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassIndexImpl createUsagesQuery(URL root, boolean source) throws IOException {
        assert (root != null);
        InternalLock internalLock = this.internalLock;
        synchronized (internalLock) {
            if (this.invalid) {
                return null;
            }
            Pair<ClassIndexImpl, Boolean> pair = this.getClassIndex(root, true, true);
            ClassIndexImpl qi = (ClassIndexImpl)pair.first;
            if (qi == null) {
                qi = PersistentClassIndex.create(root, JavaIndex.getIndex(root), source);
                this.instances.put(root, qi);
                if (this.added != null) {
                    this.added.add(root);
                }
            } else if (source && !qi.isSource()) {
                qi.close();
                qi = PersistentClassIndex.create(root, JavaIndex.getIndex(root), source);
                this.instances.put(root, qi);
                if (this.added != null) {
                    this.added.add(root);
                }
            } else if (((Boolean)pair.second).booleanValue() && this.added != null) {
                this.added.add(root);
            }
            return qi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoot(URL root) throws IOException {
        InternalLock internalLock = this.internalLock;
        synchronized (internalLock) {
            ClassIndexImpl ci = this.instances.remove(root);
            if (ci != null) {
                ci.close();
                if (this.removed != null) {
                    this.removed.add(root);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        InternalLock internalLock = this.internalLock;
        synchronized (internalLock) {
            this.invalid = true;
            for (ClassIndexImpl ci : this.instances.values()) {
                try {
                    ci.close();
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(Set<? extends URL> roots, byte op) {
        if (!this.listeners.isEmpty()) {
            ClassIndexManagerListener[] _listeners;
            Map<ClassIndexManagerListener, Void> map = this.listeners;
            synchronized (map) {
                _listeners = this.listeners.keySet().toArray(new ClassIndexManagerListener[this.listeners.size()]);
            }
            ClassIndexManagerEvent event = new ClassIndexManagerEvent(this, roots);
            for (ClassIndexManagerListener listener : _listeners) {
                if (op == 1) {
                    listener.classIndexAdded(event);
                    continue;
                }
                if (op == 2) {
                    listener.classIndexRemoved(event);
                    continue;
                }
                assert (false) : "Unknown op: " + op;
            }
        }
    }

    @NonNull
    private Pair<ClassIndexImpl, Boolean> getClassIndex(URL root, boolean allowTransient, boolean promote) {
        ClassIndexImpl index = this.instances.get(root);
        boolean promoted = false;
        if (index == null && allowTransient) {
            if (promote) {
                index = this.transientInstances.remove(root);
                if (index != null) {
                    this.instances.put(root, index);
                    promoted = true;
                }
            } else {
                index = this.transientInstances.get(root);
            }
        }
        return Pair.of(index, promoted);
    }

    public static synchronized ClassIndexManager getDefault() {
        if (instance == null) {
            instance = new ClassIndexManager();
        }
        return instance;
    }

    private static final class InternalLock {
        private InternalLock() {
        }
    }
}

