/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.parsing.ClasspathInfoListener;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.parsing.JavacParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

class ClassParser
extends Parser {
    private static final Logger LOGGER = Logger.getLogger(Parser.class.getName());
    private final ClasspathInfo info;
    private CompilationInfoImpl ciImpl;
    private final ChangeSupport changeSupport;
    private final ClasspathInfoListener cpInfoListener;

    public ClassParser(ClasspathInfo info) {
        assert (info != null);
        this.info = info;
        this.changeSupport = new ChangeSupport((Object)this);
        this.cpInfoListener = new ClasspathInfoListener(this.changeSupport);
        info.addChangeListener(WeakListeners.change((ChangeListener)this.cpInfoListener, (Object)info));
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        ClassPath srcPath;
        assert (snapshot != null);
        Source source = snapshot.getSource();
        assert (source != null);
        FileObject file = source.getFileObject();
        assert (file != null);
        ClassPath bootPath = this.info.getClassPath(ClasspathInfo.PathKind.BOOT);
        assert (bootPath != null);
        ClassPath compilePath = this.info.getClassPath(ClasspathInfo.PathKind.COMPILE);
        if (compilePath == null) {
            compilePath = ClassPathSupport.createClassPath((URL[])new URL[0]);
        }
        if ((srcPath = this.info.getClassPath(ClasspathInfo.PathKind.SOURCE)) == null) {
            srcPath = ClassPathSupport.createClassPath((URL[])new URL[0]);
        }
        FileObject root = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{bootPath, compilePath, srcPath}).findOwnerRoot(file);
        try {
            this.ciImpl = new CompilationInfoImpl(this.info, file, root);
        }
        catch (IOException ioe) {
            throw new ParseException("ClassParser failure", (Throwable)ioe);
        }
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.ciImpl != null);
        boolean isParserResultTask = task instanceof ParserResultTask;
        boolean isJavaParserResultTask = task instanceof JavaParserResultTask;
        boolean isUserTask = task instanceof UserTask;
        JavacParserResult result = null;
        if (isParserResultTask) {
            JavaSource.Phase requiredPhase;
            JavaSource.Phase currentPhase = this.ciImpl.getPhase();
            if (currentPhase.compareTo(requiredPhase = isJavaParserResultTask ? ((JavaParserResultTask)task).getPhase() : JavaSource.Phase.RESOLVED) < 0) {
                this.ciImpl.setPhase(requiredPhase);
            }
            result = new JavacParserResult(JavaSourceAccessor.getINSTANCE().createCompilationInfo(this.ciImpl));
        } else if (isUserTask) {
            result = new JavacParserResult(JavaSourceAccessor.getINSTANCE().createCompilationController(this.ciImpl));
        } else {
            LOGGER.warning("Ignoring unknown task: " + task);
        }
        return result;
    }

    public void cancel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
        Parameters.notNull((CharSequence)"changeListener", (Object)changeListener);
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Parameters.notNull((CharSequence)"changeListener", (Object)changeListener);
        this.changeSupport.removeChangeListener(changeListener);
    }
}

