/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import com.sun.tools.javac.util.Context;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.Processor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class APTUtils
implements ChangeListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(APTUtils.class.getName());
    private static final String PROCESSOR_PATH = "processorPath";
    private static final String APT_ENABLED = "aptEnabled";
    private static final String ANNOTATION_PROCESSORS = "annotationProcessors";
    private static final Map<URL, APTUtils> knownSourceRootsMap = new HashMap<URL, APTUtils>();
    private static final Map<FileObject, Reference<APTUtils>> auxiliarySourceRootsMap = new WeakHashMap<FileObject, Reference<APTUtils>>();
    private static final Lookup HARDCODED_PROCESSORS = Lookups.forPath((String)"Editors/text/x-java/AnnotationProcessors");
    private final FileObject root;
    private final ClassPath processorPath;
    private final AnnotationProcessingQuery.Result aptOptions;
    private static final Iterable<? extends String> javacPackages = Arrays.asList("com.sun.javadoc.", "com.sun.source.", "javax.annotation.processing.", "javax.lang.model.", "javax.tools.", "com.sun.tools.javac.", "com.sun.tools.javadoc.");

    private APTUtils(FileObject root, ClassPath preprocessorPath, AnnotationProcessingQuery.Result aptOptions) {
        this.root = root;
        this.processorPath = preprocessorPath;
        this.aptOptions = aptOptions;
    }

    public static APTUtils get(FileObject root) {
        APTUtils utils;
        URL rootUrl;
        if (root == null) {
            return null;
        }
        try {
            rootUrl = root.getURL();
        }
        catch (FileStateInvalidException ex) {
            LOG.log(Level.FINE, null, ex);
            return null;
        }
        if (knownSourceRootsMap.containsKey(rootUrl)) {
            APTUtils utils2 = knownSourceRootsMap.get(rootUrl);
            if (utils2 == null) {
                utils2 = APTUtils.create(root);
                knownSourceRootsMap.put(rootUrl, utils2);
            }
            return utils2;
        }
        Reference<APTUtils> utilsRef = auxiliarySourceRootsMap.get(root);
        APTUtils aPTUtils = utils = utilsRef != null ? utilsRef.get() : null;
        if (utils == null) {
            utils = APTUtils.create(root);
            auxiliarySourceRootsMap.put(root, new WeakReference<APTUtils>(utils));
        }
        return utils;
    }

    public static void sourceRootRegistered(FileObject root, URL rootURL) {
        if (root == null || knownSourceRootsMap.containsKey(rootURL) || PathRegistry.getDefault().getUnknownRoots().contains(rootURL)) {
            return;
        }
        Reference<APTUtils> utilsRef = auxiliarySourceRootsMap.remove(root);
        APTUtils utils = utilsRef != null ? utilsRef.get() : null;
        knownSourceRootsMap.put(rootURL, utils);
    }

    public static void sourceRootUnregistered(Iterable<? extends URL> roots) {
        for (URL uRL : roots) {
            knownSourceRootsMap.remove(uRL);
        }
        for (URL uRL : PathRegistry.getDefault().getUnknownRoots()) {
            knownSourceRootsMap.remove(uRL);
        }
    }

    private static APTUtils create(FileObject root) {
        ClassPath pp = ClassPath.getClassPath((FileObject)root, (String)"classpath/processor");
        if (pp == null) {
            return null;
        }
        AnnotationProcessingQuery.Result options = AnnotationProcessingQuery.getAnnotationProcessingOptions((FileObject)root);
        APTUtils utils = new APTUtils(root, pp, options);
        pp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)utils, (Object)pp));
        options.addChangeListener(WeakListeners.change((ChangeListener)utils, (Object)options));
        return utils;
    }

    public boolean aptEnabledOnScan() {
        return this.aptOptions.annotationProcessingEnabled().contains(AnnotationProcessingQuery.Trigger.ON_SCAN);
    }

    public boolean aptEnabledInEditor() {
        return this.aptOptions.annotationProcessingEnabled().contains(AnnotationProcessingQuery.Trigger.IN_EDITOR);
    }

    public Collection<? extends Processor> resolveProcessors(boolean onScan) {
        LinkedList<URL> urls = new LinkedList<URL>();
        for (ClassPath.Entry e : this.processorPath.entries()) {
            urls.add(e.getURL());
        }
        URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]), (ClassLoader)new BypassOpenIDEUtilClassLoader(Context.class.getClassLoader()));
        Collection<Processor> result = this.lookupProcessors(cl, onScan);
        return result;
    }

    public Map<? extends String, ? extends String> processorOptions() {
        return this.aptOptions.processorOptions();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.verifyAttributes(this.root, false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.verifyAttributes(this.root, false);
    }

    private Collection<Processor> lookupProcessors(ClassLoader cl, boolean onScan) {
        Iterable<? extends String> processorNames = this.aptOptions.annotationProcessorsToRun();
        if (processorNames == null) {
            processorNames = this.getProcessorNames(cl);
        }
        LinkedList<Processor> result = new LinkedList<Processor>();
        for (String string : processorNames) {
            try {
                Class<?> clazz = Class.forName(string, true, cl);
                Object instance = clazz.newInstance();
                if (!(instance instanceof Processor)) continue;
                result.add((Processor)instance);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, null, t);
            }
        }
        if (!onScan) {
            result.addAll(HARDCODED_PROCESSORS.lookupAll(Processor.class));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<? extends String> getProcessorNames(ClassLoader cl) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            Enumeration<URL> resources = cl.getResources("META-INF/services/" + Processor.class.getName());
            while (resources.hasMoreElements()) {
                BufferedReader ins = null;
                try {
                    String line;
                    ins = new BufferedReader(new InputStreamReader(resources.nextElement().openStream(), "UTF-8"));
                    while ((line = ins.readLine()) != null) {
                        int hash = line.indexOf(35);
                        String string = line = hash != -1 ? line.substring(0, hash) : line;
                        if ((line = line.trim()).length() <= 0) continue;
                        result.add(line);
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, null, ex);
                }
                finally {
                    if (ins == null) continue;
                    ins.close();
                }
            }
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        return result;
    }

    boolean verifyAttributes(FileObject fo, boolean allFilesIndexing) {
        if (fo == null) {
            return false;
        }
        try {
            URL url = fo.getURL();
            if (JavaIndex.ensureAttributeValue(url, PROCESSOR_PATH, this.processorPath.toString()) && !allFilesIndexing) {
                JavaIndex.LOG.fine("forcing reindex due to processor path change");
                IndexingManager.getDefault().refreshIndex(url, null);
                return true;
            }
            if (JavaIndex.ensureAttributeValue(url, APT_ENABLED, this.aptOptions.annotationProcessingEnabled().contains(AnnotationProcessingQuery.Trigger.ON_SCAN) ? Boolean.TRUE.toString() : null) && !allFilesIndexing) {
                JavaIndex.LOG.fine("forcing reindex due to change in annotation processing options");
                IndexingManager.getDefault().refreshIndex(url, null);
                return true;
            }
            if (JavaIndex.ensureAttributeValue(url, ANNOTATION_PROCESSORS, this.encodeToStirng(this.aptOptions.annotationProcessorsToRun())) && !allFilesIndexing) {
                JavaIndex.LOG.fine("forcing reindex due to change in annotation processors");
                IndexingManager.getDefault().refreshIndex(url, null);
                return true;
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return false;
    }

    private String encodeToStirng(Iterable<? extends String> strings) {
        if (strings == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<? extends String> it = strings.iterator();
        while (it.hasNext()) {
            sb.append((Object)it.next());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    private static final class BypassOpenIDEUtilClassLoader
    extends ClassLoader {
        private final ClassLoader contextCL;

        public BypassOpenIDEUtilClassLoader(ClassLoader contextCL) {
            super(BypassOpenIDEUtilClassLoader.getSystemClassLoader().getParent());
            this.contextCL = contextCL;
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            char f;
            char c = f = name.length() > 4 ? name.charAt(4) : (char)'\u0000';
            if (f == 'x' || f == 's') {
                for (String pack : javacPackages) {
                    if (!name.startsWith(pack)) continue;
                    return this.contextCL.loadClass(name);
                }
            }
            return super.loadClass(name, resolve);
        }
    }
}

