/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.classfile;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractElementVisitor6;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class CodeGenerator {
    private static final Logger LOG = Logger.getLogger(CodeGenerator.class.getName());
    private static final Set<ElementKind> UNUSABLE_KINDS = EnumSet.of(ElementKind.PACKAGE);
    private static final Map<List<ElementKind>, Set<Modifier>> IMPLICIT_MODIFIERS = new HashMap<List<ElementKind>, Set<Modifier>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject generateCode(final ClasspathInfo cpInfo, final ElementHandle<? extends Element> toOpenHandle) {
        if (UNUSABLE_KINDS.contains((Object)toOpenHandle.getKind())) {
            return null;
        }
        try {
            FileObject file = FileUtil.createMemoryFileSystem().getRoot().createData("test.java");
            OutputStream out = file.getOutputStream();
            try {
                FileUtil.copy((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), (OutputStream)out);
            }
            finally {
                out.close();
            }
            JavaSource js = JavaSource.create(cpInfo, file);
            final FileObject[] result = new FileObject[1];
            final boolean[] sourceGenerated = new boolean[1];
            ModificationResult r = js.runModificationTask(new Task<WorkingCopy>(){

                @Override
                public void run(WorkingCopy wc) throws Exception {
                    TypeElement te;
                    wc.toPhase(JavaSource.Phase.PARSED);
                    ClassPath cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT), cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE), cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE)});
                    Object toOpen = toOpenHandle.resolve(wc);
                    TypeElement typeElement = te = toOpen != null ? wc.getElementUtilities().outermostTypeElement((Element)toOpen) : null;
                    if (te == null) {
                        LOG.info("Cannot resolve element: " + toOpenHandle.toString() + " on classpath: " + cp.toString());
                        return;
                    }
                    String resourceName = te.getQualifiedName().toString().replace('.', '/') + ".class";
                    FileObject resource = cp.findResource(resourceName);
                    if (resource == null) {
                        LOG.info("Cannot find resource: " + resourceName + " on classpath: " + cp.toString());
                        return;
                    }
                    FileObject root = cp.findOwnerRoot(resource);
                    if (root == null) {
                        LOG.info("Cannot find owner of: " + FileUtil.getFileDisplayName((FileObject)resource) + " on classpath: " + cp.toString());
                        return;
                    }
                    File sourceRoot = new File(JavaIndex.getIndex(root.getURL()), "gensrc");
                    FileObject sourceRootFO = FileUtil.createFolder((File)sourceRoot);
                    if (sourceRootFO == null) {
                        LOG.info("Cannot create folder: " + sourceRoot);
                        return;
                    }
                    String path = te.getQualifiedName().toString().replace('.', '/') + ".java";
                    FileObject source = sourceRootFO.getFileObject(path);
                    if (source != null) {
                        result[0] = source;
                        if (source.lastModified().compareTo(resource.lastModified()) >= 0) {
                            LOG.fine(FileUtil.getFileDisplayName((FileObject)source) + " is up to date, reusing from cache.");
                            return;
                        }
                    }
                    CompilationUnitTree cut = CodeGenerator.generateCode(wc, te);
                    wc.rewrite(wc.getCompilationUnit(), cut);
                    if (source == null) {
                        result[0] = FileUtil.createData((FileObject)sourceRootFO, (String)path);
                        LOG.fine(FileUtil.getFileDisplayName((FileObject)result[0]) + " does not exist, creating.");
                    } else {
                        LOG.fine(FileUtil.getFileDisplayName((FileObject)source) + " is not up to date, regenerating.");
                    }
                    sourceGenerated[0] = true;
                }
            });
            if (sourceGenerated[0]) {
                File resultFile = FileUtil.toFile((FileObject)result[0]);
                if (resultFile != null && !resultFile.canWrite()) {
                    resultFile.setWritable(true);
                }
                out = result[0].getOutputStream();
                try {
                    FileUtil.copy((InputStream)new ByteArrayInputStream(r.getResultingSource(file).getBytes("UTF-8")), (OutputStream)out);
                }
                finally {
                    out.close();
                }
                if (resultFile != null) {
                    resultFile.setReadOnly();
                }
            }
            return result[0];
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    static CompilationUnitTree generateCode(WorkingCopy wc, TypeElement te) {
        TreeMaker make = wc.getTreeMaker();
        Tree clazz = (Tree)new TreeBuilder(make, wc).visit(te);
        CompilationUnitTree cut = make.CompilationUnit(make.Identifier(((PackageElement)te.getEnclosingElement()).getQualifiedName()), Collections.emptyList(), Collections.singletonList(clazz), wc.getCompilationUnit().getSourceFile());
        return cut;
    }

    private CodeGenerator() {
    }

    static {
        IMPLICIT_MODIFIERS.put(Arrays.asList(ElementKind.ENUM), EnumSet.of(Modifier.STATIC, Modifier.ABSTRACT, Modifier.FINAL));
        IMPLICIT_MODIFIERS.put(Arrays.asList(ElementKind.ANNOTATION_TYPE), EnumSet.of(Modifier.STATIC, Modifier.ABSTRACT));
        IMPLICIT_MODIFIERS.put(Arrays.asList(ElementKind.METHOD, ElementKind.ANNOTATION_TYPE), EnumSet.of(Modifier.ABSTRACT));
        IMPLICIT_MODIFIERS.put(Arrays.asList(ElementKind.METHOD, ElementKind.INTERFACE), EnumSet.of(Modifier.ABSTRACT));
    }

    private static final class TreeBuilder
    extends AbstractElementVisitor6<Tree, Void> {
        private TreeMaker make;
        private WorkingCopy wc;

        public TreeBuilder(TreeMaker make, WorkingCopy wc) {
            this.make = make;
            this.wc = wc;
        }

        @Override
        public Tree visitPackage(PackageElement e, Void p) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Tree visitType(TypeElement e, Void p) {
            LinkedList<Tree> members = new LinkedList<Tree>();
            for (Element element : e.getEnclosedElements()) {
                Tree member = (Tree)this.visit(element);
                if (member == null) continue;
                members.add(member);
            }
            ModifiersTree mods = this.computeMods(e);
            switch (e.getKind()) {
                case CLASS: {
                    return this.make.Class(mods, e.getSimpleName(), this.constructTypeParams(e.getTypeParameters()), this.computeSuper(e.getSuperclass()), this.computeSuper(e.getInterfaces()), members);
                }
                case INTERFACE: {
                    return this.make.Interface(mods, e.getSimpleName(), this.constructTypeParams(e.getTypeParameters()), this.computeSuper(e.getInterfaces()), members);
                }
                case ENUM: {
                    return this.make.Enum(mods, e.getSimpleName(), this.computeSuper(e.getInterfaces()), members);
                }
                case ANNOTATION_TYPE: {
                    return this.make.AnnotationType(mods, e.getSimpleName(), members);
                }
            }
            throw new UnsupportedOperationException();
        }

        private ModifiersTree computeMods(Element e) {
            Set implicitModifiers = (Set)IMPLICIT_MODIFIERS.get(Arrays.asList(e.getKind()));
            if (implicitModifiers == null) {
                implicitModifiers = (Set)IMPLICIT_MODIFIERS.get(Arrays.asList(e.getKind(), e.getEnclosingElement().getKind()));
            }
            EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
            modifiers.addAll(e.getModifiers());
            if (implicitModifiers != null) {
                modifiers.removeAll(implicitModifiers);
            }
            LinkedList<AnnotationTree> annotations = new LinkedList<AnnotationTree>();
            for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
                annotations.add(this.computeAnnotationTree(annotationMirror));
            }
            return this.make.Modifiers(modifiers, annotations);
        }

        private AnnotationTree computeAnnotationTree(AnnotationMirror am) {
            LinkedList<AssignmentTree> params = new LinkedList<AssignmentTree>();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : am.getElementValues().entrySet()) {
                ExpressionTree val = this.createTreeForAnnotationValue(this.make, entry.getValue());
                if (val == null) {
                    LOG.log(Level.WARNING, "Cannot create annotation for: {0}", entry.getValue());
                    continue;
                }
                AssignmentTree vt = this.make.Assignment(this.make.Identifier(entry.getKey().getSimpleName()), val);
                params.add(vt);
            }
            return this.make.Annotation(this.make.Type(am.getAnnotationType()), params);
        }

        private Tree computeSuper(TypeMirror superClass) {
            if (superClass == null) {
                return null;
            }
            if (superClass.getKind() == TypeKind.NONE) {
                return null;
            }
            TypeElement jlObject = this.wc.getElements().getTypeElement("java.lang.Object");
            if (this.wc.getTypes().isSameType(superClass, jlObject.asType())) {
                return null;
            }
            return this.make.Type(superClass);
        }

        private List<Tree> computeSuper(List<? extends TypeMirror> superTypes) {
            LinkedList<Tree> sup = new LinkedList<Tree>();
            if (superTypes != null) {
                for (TypeMirror typeMirror : superTypes) {
                    sup.add(this.make.Type(typeMirror));
                }
            }
            return sup;
        }

        private List<? extends TypeParameterTree> constructTypeParams(List<? extends TypeParameterElement> params) {
            LinkedList<TypeParameterTree> result = new LinkedList<TypeParameterTree>();
            for (TypeParameterElement typeParameterElement : params) {
                result.add((TypeParameterTree)this.visit(typeParameterElement));
            }
            return result;
        }

        @Override
        public Tree visitVariable(VariableElement e, Void p) {
            if (e.getKind() == ElementKind.ENUM_CONSTANT) {
                int mods = 16384;
                ModifiersTree modifiers = this.make.Modifiers(mods, Collections.emptyList());
                return this.make.Variable(modifiers, e.getSimpleName().toString(), this.make.Identifier(e.getEnclosingElement().getSimpleName().toString()), null);
            }
            ModifiersTree mods = this.computeMods(e);
            LiteralTree init = e.getConstantValue() != null ? this.make.Literal(e.getConstantValue()) : null;
            return this.make.Variable(mods, e.getSimpleName(), this.make.Type(e.asType()), init);
        }

        @Override
        public Tree visitExecutable(ExecutableElement e, Void p) {
            if (e.getKind() == ElementKind.STATIC_INIT || e.getKind() == ElementKind.INSTANCE_INIT) {
                return null;
            }
            if (this.wc.getElementUtilities().isSynthetic(e)) {
                return null;
            }
            if (e.getEnclosingElement().getKind() == ElementKind.ENUM) {
                TypeMirror param;
                if ("values".equals(e.getSimpleName().toString()) && e.getParameters().isEmpty()) {
                    return null;
                }
                if ("valueOf".equals(e.getSimpleName().toString()) && e.getParameters().size() == 1 && (param = e.getParameters().get(0).asType()).getKind() == TypeKind.DECLARED && "java.lang.String".equals(((TypeElement)((DeclaredType)param).asElement()).getQualifiedName().toString())) {
                    return null;
                }
            }
            ModifiersTree mods = this.computeMods(e);
            Tree returnValue = e.getReturnType() != null ? this.make.Type(e.getReturnType()) : null;
            LinkedList<VariableTree> parameters = new LinkedList<VariableTree>();
            for (VariableElement variableElement : e.getParameters()) {
                parameters.add((VariableTree)this.visit(variableElement));
            }
            LinkedList<ExpressionTree> throwsList = new LinkedList<ExpressionTree>();
            for (TypeMirror typeMirror : e.getThrownTypes()) {
                throwsList.add((ExpressionTree)this.make.Type(typeMirror));
            }
            if (e.getModifiers().contains((Object)Modifier.ABSTRACT) || e.getModifiers().contains((Object)Modifier.NATIVE)) {
                ExpressionTree expressionTree = this.createTreeForAnnotationValue(this.make, e.getDefaultValue());
                return this.make.Method(mods, (CharSequence)e.getSimpleName(), returnValue, this.constructTypeParams(e.getTypeParameters()), parameters, throwsList, (BlockTree)null, expressionTree);
            }
            return this.make.Method(mods, (CharSequence)e.getSimpleName(), returnValue, this.constructTypeParams(e.getTypeParameters()), parameters, throwsList, "{//compiled code\nthrow new RuntimeException(\"Compiled Code\");}", null);
        }

        @Override
        public Tree visitTypeParameter(TypeParameterElement e, Void p) {
            LinkedList<ExpressionTree> bounds = new LinkedList<ExpressionTree>();
            for (TypeMirror typeMirror : e.getBounds()) {
                bounds.add((ExpressionTree)this.make.Type(typeMirror));
            }
            return this.make.TypeParameter(e.getSimpleName(), bounds);
        }

        private ExpressionTree createTreeForAnnotationValue(final TreeMaker make, AnnotationValue def) {
            if (def == null) {
                return null;
            }
            return def.accept(new AnnotationValueVisitor<ExpressionTree, Void>(){

                @Override
                public ExpressionTree visit(AnnotationValue av, Void p) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public ExpressionTree visit(AnnotationValue av) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public ExpressionTree visitBoolean(boolean b, Void p) {
                    return make.Literal(b);
                }

                @Override
                public ExpressionTree visitByte(byte b, Void p) {
                    return make.Literal(b);
                }

                @Override
                public ExpressionTree visitChar(char c, Void p) {
                    return make.Literal(Character.valueOf(c));
                }

                @Override
                public ExpressionTree visitDouble(double d, Void p) {
                    return make.Literal(d);
                }

                @Override
                public ExpressionTree visitFloat(float f, Void p) {
                    return make.Literal(Float.valueOf(f));
                }

                @Override
                public ExpressionTree visitInt(int i, Void p) {
                    return make.Literal(i);
                }

                @Override
                public ExpressionTree visitLong(long i, Void p) {
                    return make.Literal(i);
                }

                @Override
                public ExpressionTree visitShort(short s, Void p) {
                    return make.Literal(s);
                }

                @Override
                public ExpressionTree visitString(String s, Void p) {
                    return make.Literal(s);
                }

                @Override
                public ExpressionTree visitType(TypeMirror t, Void p) {
                    return make.MemberSelect((ExpressionTree)make.Type(t), "class");
                }

                @Override
                public ExpressionTree visitEnumConstant(VariableElement c, Void p) {
                    return make.QualIdent(c);
                }

                @Override
                public ExpressionTree visitAnnotation(AnnotationMirror a, Void p) {
                    return TreeBuilder.this.computeAnnotationTree(a);
                }

                @Override
                public ExpressionTree visitArray(List<? extends AnnotationValue> vals, Void p) {
                    LinkedList<ExpressionTree> values = new LinkedList<ExpressionTree>();
                    for (AnnotationValue annotationValue : vals) {
                        ExpressionTree val = TreeBuilder.this.createTreeForAnnotationValue(make, annotationValue);
                        if (val == null) {
                            LOG.log(Level.WARNING, "Cannot create annotation for: {0}", annotationValue);
                            continue;
                        }
                        values.add(val);
                    }
                    return make.NewArray(null, Collections.emptyList(), values);
                }

                @Override
                public ExpressionTree visitUnknown(AnnotationValue av, Void p) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            }, null);
        }
    }
}

