/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.util.internal.ByteBuffer;
import org.apache.maven.surefire.util.internal.StringUtils;

public class ForkingRunListener
implements RunListener,
ConsoleLogger,
ConsoleOutputReceiver {
    public static final byte BOOTERCODE_TESTSET_STARTING = 49;
    public static final byte BOOTERCODE_TESTSET_COMPLETED = 50;
    public static final byte BOOTERCODE_STDOUT = 51;
    public static final byte BOOTERCODE_STDERR = 52;
    public static final byte BOOTERCODE_TEST_STARTING = 53;
    public static final byte BOOTERCODE_TEST_SUCCEEDED = 54;
    public static final byte BOOTERCODE_TEST_ERROR = 55;
    public static final byte BOOTERCODE_TEST_FAILED = 56;
    public static final byte BOOTERCODE_TEST_SKIPPED = 57;
    public static final byte BOOTERCODE_TEST_ASSUMPTIONFAILURE = 71;
    public static final byte BOOTERCODE_CONSOLE = 72;
    public static final byte BOOTERCODE_SYSPROPS = 73;
    public static final byte BOOTERCODE_BYE = 90;
    private final PrintStream target;
    private final Integer testSetChannelId;
    private final boolean trimStackTraces;
    private final byte[] stdOutHeader;
    private final byte[] stdErrHeader;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public ForkingRunListener(PrintStream target, int testSetChannelId) {
        this(target, testSetChannelId, false);
    }

    public ForkingRunListener(PrintStream target, int testSetChannelId, boolean trimStackTraces) {
        this.target = target;
        this.testSetChannelId = new Integer(testSetChannelId);
        this.trimStackTraces = trimStackTraces;
        this.stdOutHeader = ForkingRunListener.createHeader((byte)51, testSetChannelId);
        this.stdErrHeader = ForkingRunListener.createHeader((byte)52, testSetChannelId);
        this.sendProps();
    }

    public void testSetStarting(ReportEntry report) {
        this.target.print(this.toString((byte)49, report, this.testSetChannelId));
    }

    public void testSetCompleted(ReportEntry report) {
        this.target.print(this.toString((byte)50, report, this.testSetChannelId));
    }

    public void testStarting(ReportEntry report) {
        this.target.print(this.toString((byte)53, report, this.testSetChannelId));
    }

    public void testSucceeded(ReportEntry report) {
        this.target.print(this.toString((byte)54, report, this.testSetChannelId));
    }

    public void testAssumptionFailure(ReportEntry report) {
        this.target.print(this.toString((byte)71, report, this.testSetChannelId));
    }

    public void testError(ReportEntry report) {
        this.target.print(this.toString((byte)55, report, this.testSetChannelId));
    }

    public void testFailed(ReportEntry report) {
        this.target.print(this.toString((byte)56, report, this.testSetChannelId));
    }

    public void testSkipped(ReportEntry report) {
        this.target.print(this.toString((byte)57, report, this.testSetChannelId));
    }

    void sendProps() {
        Properties systemProperties = System.getProperties();
        if (systemProperties != null) {
            Enumeration<?> propertyKeys = systemProperties.propertyNames();
            while (propertyKeys.hasMoreElements()) {
                String key = (String)propertyKeys.nextElement();
                String value = systemProperties.getProperty(key);
                if (value == null) {
                    value = "null";
                }
                this.target.print(this.toPropertyString(key, value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        byte[] header = stdout ? this.stdOutHeader : this.stdErrHeader;
        byte[] content = new byte[buf.length * 6 + 1];
        int i = StringUtils.escapeJavaStyleString(content, 0, buf, off, len);
        content[i++] = 10;
        PrintStream printStream = this.target;
        synchronized (printStream) {
            this.target.write(header, 0, header.length);
            this.target.write(content, 0, i);
        }
    }

    public static byte[] createHeader(byte booterCode, int testSetChannel) {
        byte[] header = new byte[7];
        header[0] = booterCode;
        header[1] = 44;
        header[6] = 44;
        int i = testSetChannel;
        int charPos = 6;
        int radix = 16;
        int mask = radix - 1;
        do {
            header[--charPos] = (byte)digits[i & mask];
        } while ((i >>>= 4) != 0);
        while (charPos > 2) {
            header[--charPos] = 48;
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String message) {
        byte[] buf = message.getBytes();
        ByteBuffer byteBuffer = new ByteBuffer(7 + buf.length * 6);
        byteBuffer.append((byte)72);
        byteBuffer.comma();
        byteBuffer.append(this.testSetChannelId);
        byteBuffer.comma();
        int i = StringUtils.escapeJavaStyleString(byteBuffer.getData(), byteBuffer.getlength(), buf, 0, buf.length);
        byteBuffer.advance(i);
        byteBuffer.append('\n');
        PrintStream printStream = this.target;
        synchronized (printStream) {
            this.target.write(byteBuffer.getData(), 0, byteBuffer.getlength());
            this.target.flush();
        }
    }

    private String toPropertyString(String key, String value) {
        StringBuffer stringBuffer = new StringBuffer();
        this.append(stringBuffer, (byte)73).comma(stringBuffer);
        this.append(stringBuffer, Integer.toHexString(this.testSetChannelId)).comma(stringBuffer);
        StringUtils.escapeJavaStyleString(stringBuffer, key);
        this.append(stringBuffer, ",");
        StringUtils.escapeJavaStyleString(stringBuffer, value);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String toString(byte operationCode, ReportEntry reportEntry, Integer testSetChannelId) {
        StringBuffer stringBuffer = new StringBuffer();
        this.append(stringBuffer, operationCode).comma(stringBuffer);
        this.append(stringBuffer, Integer.toHexString(testSetChannelId)).comma(stringBuffer);
        this.nullableEncoding(stringBuffer, reportEntry.getSourceName()).comma(stringBuffer);
        this.nullableEncoding(stringBuffer, reportEntry.getName()).comma(stringBuffer);
        this.nullableEncoding(stringBuffer, reportEntry.getGroup()).comma(stringBuffer);
        this.nullableEncoding(stringBuffer, reportEntry.getMessage()).comma(stringBuffer);
        this.nullableEncoding(stringBuffer, reportEntry.getElapsed());
        this.encode(stringBuffer, reportEntry.getStackTraceWriter());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void comma(StringBuffer stringBuffer) {
        stringBuffer.append(",");
    }

    private ForkingRunListener append(StringBuffer stringBuffer, String message) {
        stringBuffer.append(this.encode(message));
        return this;
    }

    private ForkingRunListener append(StringBuffer stringBuffer, byte b) {
        stringBuffer.append((char)b);
        return this;
    }

    private void nullableEncoding(StringBuffer stringBuffer, Integer source) {
        if (source == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(source.toString());
        }
    }

    private String encode(String source) {
        return source;
    }

    private ForkingRunListener nullableEncoding(StringBuffer stringBuffer, String source) {
        if (source == null || source.length() == 0) {
            stringBuffer.append("null");
        } else {
            StringUtils.escapeJavaStyleString(stringBuffer, source);
        }
        return this;
    }

    private void encode(StringBuffer stringBuffer, StackTraceWriter stackTraceWriter) {
        if (stackTraceWriter != null) {
            this.comma(stringBuffer);
            SafeThrowable throwable = stackTraceWriter.getThrowable();
            if (throwable != null) {
                String message = throwable.getLocalizedMessage();
                this.nullableEncoding(stringBuffer, message);
            }
            this.comma(stringBuffer);
            this.nullableEncoding(stringBuffer, this.trimStackTraces ? stackTraceWriter.writeTrimmedTraceToString() : stackTraceWriter.writeTraceToString());
        }
    }
}

