/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public class ResourcesMojo
extends AbstractMojo {
    protected String encoding;
    private File outputDirectory;
    private List resources;
    protected MavenProject project;
    protected List buildFilters;
    protected List filters;
    protected boolean useBuildFilters;
    protected MavenResourcesFiltering mavenResourcesFiltering;
    protected MavenSession session;
    protected String escapeString;
    private boolean overwrite;
    protected boolean includeEmptyDirs;
    protected List nonFilteredFileExtensions;
    protected boolean escapeWindowsPaths;
    protected List delimiters;
    protected boolean useDefaultDelimiters;

    public void execute() throws MojoExecutionException {
        try {
            if (StringUtils.isEmpty((String)this.encoding) && this.isFilteringEnabled(this.getResources())) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            List filters = this.getCombinedFiltersList();
            MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(this.getResources(), this.getOutputDirectory(), this.project, this.encoding, filters, Collections.EMPTY_LIST, this.session);
            mavenResourcesExecution.setEscapeWindowsPaths(this.escapeWindowsPaths);
            mavenResourcesExecution.setInjectProjectBuildFilters(false);
            mavenResourcesExecution.setEscapeString(this.escapeString);
            mavenResourcesExecution.setOverwrite(this.overwrite);
            mavenResourcesExecution.setIncludeEmptyDirs(this.includeEmptyDirs);
            if (this.delimiters != null && !this.delimiters.isEmpty()) {
                LinkedHashSet<String> delims = new LinkedHashSet<String>();
                if (this.useDefaultDelimiters) {
                    delims.addAll(mavenResourcesExecution.getDelimiters());
                }
                Iterator dIt = this.delimiters.iterator();
                while (dIt.hasNext()) {
                    String delim = (String)dIt.next();
                    if (delim == null) {
                        delims.add("${*}");
                        continue;
                    }
                    delims.add(delim);
                }
                mavenResourcesExecution.setDelimiters(delims);
            }
            if (this.nonFilteredFileExtensions != null) {
                mavenResourcesExecution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
            }
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected List getCombinedFiltersList() {
        if (this.filters == null || this.filters.isEmpty()) {
            return this.useBuildFilters ? this.buildFilters : null;
        }
        ArrayList result = new ArrayList();
        if (this.useBuildFilters && this.buildFilters != null && !this.buildFilters.isEmpty()) {
            result.addAll(this.buildFilters);
        }
        result.addAll(this.filters);
        return result;
    }

    private boolean isFilteringEnabled(Collection resources) {
        if (resources != null) {
            Iterator i = resources.iterator();
            while (i.hasNext()) {
                Resource resource = (Resource)i.next();
                if (!resource.isFiltering()) continue;
                return true;
            }
        }
        return false;
    }

    public List getResources() {
        return this.resources;
    }

    public void setResources(List resources) {
        this.resources = resources;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    public List getFilters() {
        return this.filters;
    }

    public void setFilters(List filters) {
        this.filters = filters;
    }

    public List getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(List delimiters) {
        this.delimiters = delimiters;
    }

    public boolean isUseDefaultDelimiters() {
        return this.useDefaultDelimiters;
    }

    public void setUseDefaultDelimiters(boolean useDefaultDelimiters) {
        this.useDefaultDelimiters = useDefaultDelimiters;
    }
}

