/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.validator.UrlValidator;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class LicenseReport
extends AbstractProjectInfoReport {
    private Settings settings;
    private boolean offline;

    public String getName(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.license.name");
    }

    public String getDescription(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.license.description");
    }

    public void executeReport(Locale locale) {
        if (!this.offline) {
            LicenseRenderer r = new LicenseRenderer(this.getSink(), this.getProject(), this.i18n, locale, this.settings);
            r.render();
        } else {
            this.getLog().info((CharSequence)"Not generating license report while offline.");
        }
    }

    public String getOutputName() {
        return "license";
    }

    private static class LicenseRenderer
    extends AbstractMavenReportRenderer {
        private MavenProject project;
        private Settings settings;
        private I18N i18n;
        private Locale locale;

        LicenseRenderer(Sink sink, MavenProject project, I18N i18n, Locale locale, Settings settings) {
            super(sink);
            this.project = project;
            this.settings = settings;
            this.i18n = i18n;
            this.locale = locale;
        }

        public String getTitle() {
            return this.i18n.getString("project-info-report", this.locale, "report.license.title");
        }

        public void renderBody() {
            List licenses = this.project.getModel().getLicenses();
            if (licenses.isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.license.nolicense"));
                this.endSection();
                return;
            }
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.license.overview.title"));
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.license.overview.intro"));
            this.endSection();
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.license.title"));
            Iterator i = licenses.iterator();
            while (i.hasNext()) {
                License license = (License)i.next();
                String name = license.getName();
                String url = license.getUrl();
                String comments = license.getComments();
                this.startSection(name);
                if (!StringUtils.isEmpty((String)comments)) {
                    this.paragraph(comments);
                }
                if (url != null) {
                    URL licenseUrl = null;
                    UrlValidator urlValidator = new UrlValidator(1);
                    if (urlValidator.isValid(url) || url.startsWith("file://")) {
                        try {
                            licenseUrl = new URL(url);
                        }
                        catch (MalformedURLException e) {
                            this.paragraph("The license url [" + url + "] seems to be invalid: " + e.getMessage());
                        }
                    } else {
                        File licenseFile = new File(this.project.getBasedir(), url);
                        if (!licenseFile.exists()) {
                            licenseFile = new File(url);
                        }
                        if (!licenseFile.exists()) {
                            this.paragraph("Maven can't find the file " + licenseFile + " on the system.");
                        }
                        try {
                            licenseUrl = licenseFile.toURL();
                        }
                        catch (MalformedURLException e) {
                            this.paragraph("The license url [" + url + "] seems to be invalid: " + e.getMessage());
                        }
                    }
                    if (licenseUrl != null) {
                        String licenseContent = null;
                        try {
                            licenseContent = this.getLicenseInputStream(licenseUrl);
                        }
                        catch (IOException e) {
                            this.paragraph("Can't read the url [" + licenseUrl + "] : " + e.getMessage());
                        }
                        if (licenseContent != null) {
                            String licenseContentLC = licenseContent.toLowerCase();
                            int bodyStart = licenseContentLC.indexOf("<body");
                            int bodyEnd = licenseContentLC.indexOf("</body>");
                            if ((licenseContentLC.startsWith("<!doctype html") || licenseContentLC.startsWith("<html>")) && bodyStart >= 0 && bodyEnd >= 0) {
                                bodyStart = licenseContentLC.indexOf(">", bodyStart) + 1;
                                String body = licenseContent.substring(bodyStart, bodyEnd);
                                this.link("[Original text]", licenseUrl.toExternalForm());
                                this.paragraph("Copy of the license follows.");
                                body = LicenseRenderer.replaceRelativeLinks(body, LicenseRenderer.baseURL(licenseUrl).toExternalForm());
                                this.sink.rawText(body);
                            } else {
                                this.verbatimText(licenseContent);
                            }
                        }
                    }
                }
                this.endSection();
            }
            this.endSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getLicenseInputStream(URL licenseUrl) throws IOException {
            Proxy proxy;
            String scheme = licenseUrl.getProtocol();
            if (!"file".equals(scheme) && (proxy = this.settings.getActiveProxy()) != null) {
                scheme = "http".equals(scheme) || "https".equals(scheme) ? "http." : ("ftp".equals(scheme) ? "ftp." : "");
                String host = proxy.getHost();
                if (!StringUtils.isEmpty((String)host)) {
                    String userName;
                    Properties p = System.getProperties();
                    p.setProperty(scheme + "proxySet", "true");
                    p.setProperty(scheme + "proxyHost", host);
                    p.setProperty(scheme + "proxyPort", String.valueOf(proxy.getPort()));
                    if (!StringUtils.isEmpty((String)proxy.getNonProxyHosts())) {
                        p.setProperty(scheme + "nonProxyHosts", proxy.getNonProxyHosts());
                    }
                    if (!StringUtils.isEmpty((String)(userName = proxy.getUsername()))) {
                        final String pwd = StringUtils.isEmpty((String)proxy.getPassword()) ? "" : proxy.getPassword();
                        Authenticator.setDefault(new Authenticator(){

                            protected PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(userName, pwd.toCharArray());
                            }
                        });
                    }
                }
            }
            InputStream in = null;
            try {
                in = licenseUrl.openStream();
                String string = IOUtil.toString((InputStream)in, (String)"ISO-8859-1");
                return string;
            }
            finally {
                IOUtil.close((InputStream)in);
            }
        }

        private static URL baseURL(URL aUrl) {
            String urlTxt = aUrl.toExternalForm();
            int lastSlash = urlTxt.lastIndexOf(47);
            if (lastSlash > -1) {
                try {
                    return new URL(urlTxt.substring(0, lastSlash + 1));
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return aUrl;
        }

        private static String replaceRelativeLinks(String html, String baseURL) {
            String url = baseURL;
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            String serverURL = url.substring(0, url.indexOf(47, url.indexOf("//") + 2));
            String content = LicenseRenderer.replaceParts(html, url, serverURL, "[aA]", "[hH][rR][eE][fF]");
            content = LicenseRenderer.replaceParts(content, url, serverURL, "[iI][mM][gG]", "[sS][rR][cC]");
            return content;
        }

        private static String replaceParts(String html, String baseURL, String serverURL, String tagPattern, String attributePattern) {
            Pattern anchor = Pattern.compile("(<\\s*" + tagPattern + "\\s+[^>]*" + attributePattern + "\\s*=\\s*\")([^\"]*)\"([^>]*>)");
            StringBuffer sb = new StringBuffer(html);
            int indx = 0;
            boolean done = false;
            while (!done) {
                Matcher mAnchor = anchor.matcher(sb);
                if (mAnchor.find(indx)) {
                    indx = mAnchor.end(3);
                    if (mAnchor.group(2).startsWith("#")) {
                        // empty if block
                    }
                    if (mAnchor.group(2).startsWith("/")) {
                        sb.insert(mAnchor.start(2), serverURL);
                        indx += serverURL.length();
                        continue;
                    }
                    if (mAnchor.group(2).indexOf(58) >= 0) continue;
                    sb.insert(mAnchor.start(2), baseURL);
                    indx += baseURL.length();
                    continue;
                }
                done = true;
            }
            return sb.toString();
        }
    }
}

