/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Model;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class IssueTrackingReport
extends AbstractProjectInfoReport {
    public String getName(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.issuetracking.name");
    }

    public String getDescription(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.issuetracking.description");
    }

    public void executeReport(Locale locale) {
        IssueTrackingRenderer r = new IssueTrackingRenderer(this.getSink(), this.getProject().getModel(), this.i18n, locale);
        r.render();
    }

    public String getOutputName() {
        return "issue-tracking";
    }

    private static class IssueTrackingRenderer
    extends AbstractMavenReportRenderer {
        private Model model;
        private I18N i18n;
        private Locale locale;

        IssueTrackingRenderer(Sink sink, Model model, I18N i18n, Locale locale) {
            super(sink);
            this.model = model;
            this.i18n = i18n;
            this.locale = locale;
        }

        public String getTitle() {
            return this.i18n.getString("project-info-report", this.locale, "report.issuetracking.title");
        }

        public void renderBody() {
            IssueManagement issueManagement = this.model.getIssueManagement();
            if (issueManagement == null) {
                this.startSection(this.getTitle());
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.issuetracking.noissueManagement"));
                this.endSection();
                return;
            }
            String system = issueManagement.getSystem();
            String url = issueManagement.getUrl();
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.issuetracking.overview.title"));
            if (this.isIssueManagementSystem(system, "jira")) {
                this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.issuetracking.jira.intro"));
            } else if (this.isIssueManagementSystem(system, "bugzilla")) {
                this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.issuetracking.bugzilla.intro"));
            } else if (this.isIssueManagementSystem(system, "scarab")) {
                this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.issuetracking.scarab.intro"));
            } else if (system == null || "".equals(system.trim())) {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.issuetracking.general.intro"));
            } else {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.issuetracking.custom.intro").replaceFirst("%issueManagementSystem%", system));
            }
            this.endSection();
            this.startSection(this.getTitle());
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.issuetracking.intro"));
            this.verbatimLink(url, url);
            this.endSection();
        }

        private boolean isIssueManagementSystem(String system, String im) {
            if (StringUtils.isEmpty((String)system)) {
                return false;
            }
            if (StringUtils.isEmpty((String)im)) {
                return false;
            }
            return system.toLowerCase().startsWith(im.toLowerCase());
        }
    }
}

