/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.pmd.AbstractPmdViolationCheckMojo;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PmdViolationCheckMojo
extends AbstractPmdViolationCheckMojo {
    private int failurePriority;
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.executeCheck("pmd.xml", "violation", "PMD violation", this.failurePriority);
        }
    }

    protected void printError(Map item, String severity) {
        StringBuffer buff = new StringBuffer(100);
        buff.append("PMD " + severity + ": ");
        if (item.containsKey("class")) {
            if (item.containsKey("package")) {
                buff.append(item.get("package"));
                buff.append(".");
            }
            buff.append(item.get("class"));
        } else {
            buff.append(item.get("filename"));
        }
        buff.append(":");
        buff.append(item.get("beginline"));
        buff.append(" Rule:").append(item.get("rule"));
        buff.append(" Priority:").append(item.get("priority"));
        buff.append(" ").append(item.get("text")).append(".");
        this.getLog().info((CharSequence)buff.toString());
    }

    protected Map getErrorDetails(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int attributeCount = 0;
        HashMap<String, String> msgs = new HashMap<String, String>();
        attributeCount = xpp.getAttributeCount();
        for (int index = 0; index < attributeCount; ++index) {
            msgs.put(xpp.getAttributeName(index), xpp.getAttributeValue(index));
        }
        if (xpp.next() == 4) {
            msgs.put("text", xpp.getText().trim());
        }
        return msgs;
    }
}

